/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.util;

import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import me.decce.ixeris.core.shadow.classtransform.TransformerManager;
import me.decce.ixeris.core.shadow.classtransform.mixinstranslator.MixinsTranslator;
import me.decce.ixeris.core.shadow.classtransform.transformer.IAnnotationHandlerPreprocessor;
import me.decce.ixeris.core.shadow.classtransform.utils.tree.BasicClassProvider;
import me.decce.ixeris.core.shadow.classtransform.utils.tree.IClassProvider;
import me.decce.ixeris.core.util.ReflectionHelper;
import net.minecraftforge.securemodules.SecureModuleClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransformationHelper {
    public static final String MODULE_GLFW = "org.lwjgl.glfw";
    public final MethodHandle DEFINE_CLASS = ReflectionHelper.unreflect(() -> ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE));
    public final MethodHandle RESOLVE_CLASS = ReflectionHelper.unreflect(() -> ClassLoader.class.getDeclaredMethod("resolveClass", Class.class));
    public final MethodHandle IMPL_ADD_READS_ALL_UNNAMED = ReflectionHelper.unreflect(() -> Module.class.getDeclaredMethod("implAddReadsAllUnnamed", new Class[0]));
    public final MethodHandle IMPL_ADD_READS = ReflectionHelper.unreflect(() -> Module.class.getDeclaredMethod("implAddReads", Module.class));
    private final Logger LOGGER = LogManager.getLogger();
    public final ClassLoader mcBootstrapClassLoader;
    public final ClassLoader modClassLoader;

    public TransformationHelper(ClassLoader mcBootstrapClassLoader, ClassLoader modClassLoader) {
        this.mcBootstrapClassLoader = mcBootstrapClassLoader;
        this.modClassLoader = modClassLoader;
    }

    public static Module findBootModule(String name) {
        ModuleLayer layer = (ModuleLayer)((IModuleLayerManager)Launcher.INSTANCE.findLayerManager().orElseThrow()).getLayer(IModuleLayerManager.Layer.BOOT).orElseThrow();
        return layer.findModule(name).orElseThrow();
    }

    public void expandGlfwModuleReads() {
        try {
            this.LOGGER.debug("Trying to expand GLFW module reads");
            Module glfwModule = TransformationHelper.findBootModule(MODULE_GLFW);
            this.IMPL_ADD_READS.invoke(glfwModule, TransformationHelper.findBootModule("org.apache.logging.log4j"));
            this.IMPL_ADD_READS_ALL_UNNAMED.invoke(glfwModule);
            this.LOGGER.debug("Successfully expanded GLFW module reads");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Loose catch block
     */
    public byte[] doTransformation(Class<?>[] transformers, boolean useMixinsTranslator, IAnnotationHandlerPreprocessor ... additionalPreprocessor) {
        byte[] byArray;
        InputStream stream;
        ModuleReader reader;
        block17: {
            block16: {
                ModuleLayer layer = (ModuleLayer)((IModuleLayerManager)Launcher.INSTANCE.findLayerManager().orElseThrow()).getLayer(IModuleLayerManager.Layer.BOOT).orElseThrow();
                ResolvedModule module = layer.configuration().findModule(MODULE_GLFW).orElseThrow();
                ModuleReference ref = module.reference();
                reader = ref.open();
                stream = reader.open("org/lwjgl/glfw/GLFW.class").orElseThrow();
                byte[] bytes = stream.readAllBytes();
                TransformerManager manager = this.getTransformerManager(transformers, useMixinsTranslator, additionalPreprocessor);
                long millis = System.currentTimeMillis();
                byte[] transformedBytes = manager.transform("org.lwjgl.glfw.GLFW", bytes);
                long elapsed = System.currentTimeMillis() - millis;
                this.LOGGER.info("Successfully transformed class org.lwjgl.glfw.GLFW in {}ms", (Object)elapsed);
                byArray = transformedBytes;
                if (stream == null) break block16;
                stream.close();
            }
            if (reader == null) break block17;
            reader.close();
        }
        return byArray;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void verifyClassLoaders() {
        if (!"MC-BOOTSTRAP".equals(this.mcBootstrapClassLoader.getName()) && !"SECURE-BOOTSTRAP".equals(this.mcBootstrapClassLoader.getName())) {
            throw new IllegalStateException("IxerisBootstrapper found incorrect MC-BOOTSTRAP classloader: " + this.mcBootstrapClassLoader.getName());
        }
        if (!"LAYER SERVICE".equals(this.modClassLoader.getName()) && !"TRANSFORMER".equals(this.modClassLoader.getName())) {
            throw new IllegalStateException("IxerisBootstrapper found incorrect mod classloader: " + this.modClassLoader.getName());
        }
    }

    public static String toClassName(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name.replace(".class", "").replace('/', '.');
    }

    public void loadCoreClasses(Class<?> serviceClass) {
        this.LOGGER.info("Loading Ixeris coremod");
        URL resource = serviceClass.getResource("/me/decce/ixeris/core");
        try (Stream<Path> stream = Files.walk(Path.of(Objects.requireNonNull(resource).toURI()), new FileVisitOption[0]);){
            LinkedList<Path> classesToLoad = new LinkedList<Path>(stream.filter(p -> !Files.isDirectory(p, new LinkOption[0]) && p.toString().endsWith(".class")).toList());
            while (!classesToLoad.isEmpty()) {
                Path clazz = classesToLoad.remove(0);
                if (this.loadClass(clazz)) continue;
                classesToLoad.add(clazz);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private boolean loadClass(Path path) {
        try {
            String name = TransformationHelper.toClassName(path.toString());
            this.defineClass(this.mcBootstrapClassLoader, name, Files.readAllBytes(path));
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void defineClass(ClassLoader cl, String name, byte[] bytes) throws Throwable {
        Class clazz = this.DEFINE_CLASS.invoke(cl, name, bytes, 0, bytes.length);
        this.RESOLVE_CLASS.invoke(cl, clazz);
    }

    private TransformerManager getTransformerManager(Class<?>[] transformers, boolean useMixinsTranslator, IAnnotationHandlerPreprocessor ... additionalPreprocessor) {
        BasicClassProvider provider = new BasicClassProvider();
        TransformerManager manager = new TransformerManager((IClassProvider)provider);
        if (useMixinsTranslator) {
            manager.addTransformerPreprocessor((IAnnotationHandlerPreprocessor)new MixinsTranslator());
        }
        for (IAnnotationHandlerPreprocessor iAnnotationHandlerPreprocessor : additionalPreprocessor) {
            manager.addTransformerPreprocessor(iAnnotationHandlerPreprocessor);
        }
        for (Class<?> clazz : transformers) {
            manager.addTransformer(clazz.getName());
        }
        return manager;
    }

    public void removeModClassesFromServiceLayer() {
        try {
            MethodHandle packageLookupGetter = ReflectionHelper.unreflectGetter(() -> ModuleClassLoader.class.getDeclaredField("packageLookup"));
            Map packageLookup = packageLookupGetter.invoke(this.modClassLoader);
            packageLookup.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("me.decce.ixeris.core"));
            MethodHandle parentLoadersGetter = ReflectionHelper.unreflectGetter(() -> ModuleClassLoader.class.getDeclaredField("parentLoaders"));
            Map parentLoaders = parentLoadersGetter.invoke(this.modClassLoader);
            parentLoaders.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("me.decce.ixeris.core"));
        }
        catch (Throwable e2) {
            this._removeModClassesFromServiceLayer(e2);
        }
    }

    public void _removeModClassesFromServiceLayer(Throwable throwable) {
        try {
            MethodHandle packageToOurModulesGetter = ReflectionHelper.unreflectGetter(() -> SecureModuleClassLoader.class.getDeclaredField("packageToOurModules"));
            Map packageToOurModules = packageToOurModulesGetter.invoke(this.modClassLoader);
            packageToOurModules.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("me.decce.ixeris.core"));
            MethodHandle packageToParentLoaderGetter = ReflectionHelper.unreflectGetter(() -> SecureModuleClassLoader.class.getDeclaredField("parentLoaders"));
            Map packageToParentLoader = packageToParentLoaderGetter.invoke(this.modClassLoader);
            packageToParentLoader.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("me.decce.ixeris.core"));
        }
        catch (Throwable e2) {
            e2.addSuppressed(throwable);
            throw new RuntimeException(e2);
        }
    }
}

