/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.reflect.localcapture;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import me.decce.ixeris.core.shadow.reflect.Classes;
import me.decce.ixeris.core.shadow.reflect.JavaBypass;
import me.decce.ixeris.core.shadow.reflect.exceptions.MethodNotFoundException;
import me.decce.ixeris.core.shadow.reflect.localcapture.LocalStackFrame;
import me.decce.ixeris.core.shadow.reflect.localcapture.LocalStackFrameImpl;
import me.decce.ixeris.core.shadow.reflect.utils.FieldInitializer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LocalCapturer {
    private static final Class<?> liveStackFrame = Classes.forName("java.lang.LiveStackFrame");
    private static final StackWalker stackWalker = FieldInitializer.reqInit(() -> {
        MethodHandle getStackWalker = JavaBypass.TRUSTED_LOOKUP.findStatic(liveStackFrame, "getStackWalker", MethodType.methodType(StackWalker.class, Set.class));
        return getStackWalker.invokeExact(Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE));
    }, () -> new MethodNotFoundException(liveStackFrame.getName(), "getStackWalker", StackWalker.class));

    public static void forEach(Consumer<LocalStackFrame> consumer) {
        LocalCapturer.walk(s -> {
            s.skip(1L).forEach(consumer);
            return null;
        });
    }

    public static <T> T walk(Function<Stream<LocalStackFrame>, T> function) {
        return (T)stackWalker.walk(s -> function.apply(s.skip(1L).map(LocalStackFrameImpl::new)));
    }

    public static LocalStackFrame[] getStackFrames() {
        return LocalCapturer.walk(s -> (LocalStackFrame[])s.toArray(LocalStackFrame[]::new));
    }
}

