/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.state_caching.window;

import java.util.concurrent.atomic.AtomicIntegerArray;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.glfw.callback_dispatcher.MouseButtonCallbackDispatcher;
import me.decce.ixeris.core.glfw.state_caching.util.InputModeHelper;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwWindowCache;
import org.lwjgl.glfw.GLFW;

public class GlfwMouseButtonCache
extends GlfwWindowCache {
    public static final int MOUSE_BUTTON_UNINITIALIZED = -1;
    private final AtomicIntegerArray buttons;

    public GlfwMouseButtonCache(long window) {
        super(window);
        MouseButtonCallbackDispatcher.get(window).registerMainThreadCallback(this::onMouseButtonCallback);
        this.buttons = new AtomicIntegerArray(8);
        for (int i = 0; i < this.buttons.length(); ++i) {
            this.buttons.set(i, -1);
        }
        this.enableCache();
    }

    public int get(int button) {
        if (InputModeHelper.isStickyMouseButtons(this.window)) {
            return this.blockingGet(button);
        }
        if (button < 0 || button > 7) {
            if (Ixeris.getConfig().shouldLogCacheIssues()) {
                Ixeris.LOGGER.warn("A call to glfwGetMouseButton was made with illegal button: {}", (Object)button);
                Thread.dumpStack();
            }
            return this.blockingGet(button);
        }
        int ret = this.buttons.get(button);
        if (ret == -1) {
            ret = this.blockingGet(button);
            this.buttons.set(button, ret);
        }
        return ret;
    }

    private int blockingGet(int button) {
        this.disableCache();
        int ret = GLFW.glfwGetMouseButton((long)this.window, (int)button);
        this.enableCache();
        return ret;
    }

    private void onMouseButtonCallback(long window, int button, int action, int mods) {
        if (this.window == window && button >= 0 && button <= 7) {
            this.buttons.set(button, action);
        }
    }
}

