/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.reflect.bytecode.builder;

import me.decce.ixeris.core.shadow.reflect.bytecode.BytecodeUtils;
import me.decce.ixeris.core.shadow.reflect.bytecode.builder.BytecodeBuilder;
import me.decce.ixeris.core.shadow.reflect.bytecode.wrapper.BytecodeLabel;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public interface MethodBuilder {
    public MethodBuilder insn(int var1);

    public MethodBuilder int_(int var1, int var2);

    default public MethodBuilder intPush(BytecodeBuilder builder, int i) {
        if (i >= -1 && i <= 5) {
            return this.insn(builder.opcode("ICONST_" + i));
        }
        if (i >= -128 && i <= 127) {
            return this.int_(builder.opcode("BIPUSH"), i);
        }
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            return this.int_(builder.opcode("SIPUSH"), i);
        }
        return this.ldc(i);
    }

    public MethodBuilder var(int var1, int var2);

    public MethodBuilder type(int var1, String var2);

    default public MethodBuilder box(BytecodeBuilder builder, Class<?> primitive) {
        Class<?> boxed = BytecodeUtils.boxed(primitive);
        if (boxed != primitive) {
            this.method(builder.opcode("INVOKESTATIC"), BytecodeUtils.slash(boxed), "valueOf", BytecodeUtils.mdesc(boxed, primitive), false);
        }
        return this;
    }

    default public MethodBuilder unbox(BytecodeBuilder builder, Class<?> primitive) {
        Class<?> boxed = BytecodeUtils.boxed(primitive);
        if (boxed != primitive) {
            this.method(builder.opcode("INVOKEVIRTUAL"), BytecodeUtils.slash(boxed), primitive.getSimpleName() + "Value", BytecodeUtils.mdesc(primitive, new Class[0]), false);
        }
        return this;
    }

    public MethodBuilder field(int var1, String var2, String var3, String var4);

    public MethodBuilder method(int var1, String var2, String var3, String var4, boolean var5);

    public MethodBuilder jump(int var1, BytecodeLabel var2);

    public MethodBuilder label(BytecodeLabel var1);

    public MethodBuilder ldc(Object var1);

    default public MethodBuilder typeLdc(BytecodeBuilder builder, Class<?> clazz) {
        Class<?> boxed = BytecodeUtils.boxed(clazz);
        if (boxed == clazz) {
            this.ldc(builder.type(BytecodeUtils.desc(clazz)));
        } else {
            this.field(builder.opcode("GETSTATIC"), BytecodeUtils.slash(boxed), "TYPE", BytecodeUtils.desc(Class.class));
        }
        return this;
    }

    public MethodBuilder iinc(int var1, int var2);

    public MethodBuilder multiANewArray(String var1, int var2);

    public MethodBuilder tryCatch(BytecodeLabel var1, BytecodeLabel var2, BytecodeLabel var3, String var4);

    public MethodBuilder maxs(int var1, int var2);
}

