/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core;

import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.gson.Gson;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import me.decce.ixeris.core.Ixeris;
import org.lwjgl.system.Platform;

public class IxerisConfig {
    private static final Path CONFIG_PATH = Paths.get("config", new String[0]);
    private static final Path FILE_OLD = CONFIG_PATH.resolve("ixeris.json");
    private static final Path FILE = CONFIG_PATH.resolve("ixeris.toml");
    @Comment(value="Specifies whether to enable the mod on Windows")
    private boolean enabledOnWindows = true;
    @Comment(value="Specifies whether to enable the mod on macOS")
    private boolean enabledOnMacOS = false;
    @Comment(value="Specifies whether to enable the mod on Linux")
    private boolean enabledOnLinux = true;
    private transient Boolean enabledOnCurrentPlatform;
    @Comment(value="Enable to use some experimental GLFW state cache, which may improve performance with some mods")
    private boolean aggressiveCaching;
    @Comment(value="Enable to use a more flexible threading model, which improves performance while obeying threading requirements of the underlying operating system.")
    private boolean flexibleThreading = true;
    @Comment(value="Enable to disallow delaying of any GLFW call. Might reduce performance considerably.")
    private boolean fullyBlockingMode;
    @Comment(value="Specifies the priority of the event polling thread. Valid values are 0~10, where 0 = auto decide.")
    private int eventPollingThreadPriority;
    @Comment(value="Enables logging of blocking calls and stacktrace. Debug Only.")
    private boolean logBlockingCalls;
    @Comment(value="Enables logging of cache issues. Debug Only.")
    private boolean logCacheIssues;

    private IxerisConfig() {
    }

    public boolean isEnabled() {
        if (this.enabledOnCurrentPlatform == null) {
            Platform platform = Platform.get();
            this.enabledOnCurrentPlatform = switch (platform) {
                default -> throw new IncompatibleClassChangeError();
                case Platform.LINUX -> this.enabledOnLinux;
                case Platform.MACOSX -> this.enabledOnMacOS;
                case Platform.WINDOWS -> this.enabledOnWindows;
            };
        }
        return this.enabledOnCurrentPlatform;
    }

    public boolean isAggressiveCaching() {
        return this.aggressiveCaching;
    }

    public boolean useFlexibleThreading() {
        return this.flexibleThreading;
    }

    public boolean isFullyBlockingMode() {
        return this.fullyBlockingMode;
    }

    public boolean shouldLogBlockingCalls() {
        return this.logBlockingCalls;
    }

    public boolean shouldLogCacheIssues() {
        return this.logCacheIssues;
    }

    public int getEventPollingThreadPriority() {
        if (this.eventPollingThreadPriority >= 1 && this.eventPollingThreadPriority <= 10) {
            return this.eventPollingThreadPriority;
        }
        return 8;
    }

    public long getMainThreadSleepTime() {
        return 4L;
    }

    private static CommentedFileConfig makeNightConfig() {
        return (CommentedFileConfig)CommentedFileConfig.builder((Path)FILE, (ConfigFormat)TomlFormat.instance()).preserveInsertionOrder().sync().build();
    }

    public void save() {
        try (CommentedFileConfig config = this.toNightConfig();){
            config.save();
        }
        catch (Exception e) {
            Ixeris.LOGGER.error("Failed to save configuration!", (Throwable)e);
        }
    }

    public static IxerisConfig load() {
        IxerisConfig.maybeImportOld();
        if (FILE.toFile().exists()) {
            try {
                return IxerisConfig.fromNightConfig();
            }
            catch (Exception e) {
                Ixeris.LOGGER.error("Failed to read configuration!", (Throwable)e);
            }
        }
        return new IxerisConfig();
    }

    private CommentedFileConfig toNightConfig() {
        CommentedFileConfig config = IxerisConfig.makeNightConfig();
        try {
            for (Field field : IxerisConfig.class.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || Modifier.isFinal(modifiers)) continue;
                config.set(field.getName(), field.get(this));
                if (!field.isAnnotationPresent(Comment.class)) continue;
                config.setComment(field.getName(), field.getAnnotation(Comment.class).value());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return config;
    }

    private static IxerisConfig fromNightConfig() {
        IxerisConfig config = new IxerisConfig();
        try (CommentedFileConfig night = IxerisConfig.makeNightConfig();){
            night.load();
            for (Field field : IxerisConfig.class.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || Modifier.isFinal(modifiers) || !night.contains(field.getName())) continue;
                field.set(config, night.get(field.getName()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return config;
    }

    private static void maybeImportOld() {
        if (FILE_OLD.toFile().exists()) {
            if (FILE.toFile().exists()) {
                FILE_OLD.toFile().delete();
            } else {
                try {
                    IxerisConfig old = (IxerisConfig)new Gson().fromJson(Files.readString(FILE_OLD), IxerisConfig.class);
                    CommentedFileConfig night = old.toNightConfig();
                    night.set("enabledOnMacOS", (Object)false);
                    night.save();
                    night.close();
                    FILE_OLD.toFile().delete();
                    Ixeris.LOGGER.info("Successfully imported configuration from ixeris.json.");
                }
                catch (Exception e) {
                    Ixeris.LOGGER.error("Failed to import old configuration!", (Throwable)e);
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Comment {
        public String value();
    }
}

