/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.shadow.classtransform.utils.tree;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.decce.ixeris.core.shadow.classtransform.utils.ASMUtils;
import me.decce.ixeris.core.shadow.classtransform.utils.tree.IClassProvider;

@ParametersAreNonnullByDefault
public class BasicClassProvider
implements IClassProvider {
    protected ClassLoader classLoader;

    public BasicClassProvider() {
        this(BasicClassProvider.class.getClassLoader());
    }

    public BasicClassProvider(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public byte[] getClass(String name) throws ClassNotFoundException {
        try (InputStream is = this.classLoader.getResourceAsStream(ASMUtils.slash(name) + ".class");){
            int len;
            Objects.requireNonNull(is, "Class input stream is null");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(name, t);
        }
    }

    @Override
    @Nonnull
    public Map<String, Supplier<byte[]>> getAllClasses() {
        throw new UnsupportedOperationException("Not implemented");
    }
}

