/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import me.decce.ixeris.workarounds.WindowMinimizedStateWorkaround;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.main.SilentInitException;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.profiling.Profiler;
import org.slf4j.Logger;

public class VersionCompatUtils {
    public static void initGameThread() {
    }

    public static void beginInitialization() {
    }

    public static void finishInitialization() {
    }

    public static Minecraft tryCreateMinecraft(GameConfig gameConfig, Logger logger) {
        Minecraft minecraft = null;
        try {
            RenderSystem.initRenderThread();
            VersionCompatUtils.beginInitialization();
            minecraft = new Minecraft(gameConfig);
            VersionCompatUtils.finishInitialization();
            WindowMinimizedStateWorkaround.init();
        }
        catch (SilentInitException silentInitException) {
            Util.shutdownExecutors();
            logger.warn("Failed to create window: ", (Throwable)silentInitException);
            return null;
        }
        catch (Throwable throwable) {
            CrashReport crashReport2 = CrashReport.forThrowable((Throwable)throwable, (String)"Initializing game");
            CrashReportCategory crashReportCategory2 = crashReport2.addCategory("Initialization");
            NativeModuleLister.addCrashSection((CrashReportCategory)crashReportCategory2);
            Minecraft.fillReport((Minecraft)minecraft, (LanguageManager)null, (String)gameConfig.game.launchVersion, (Options)null, (CrashReport)crashReport2);
            Minecraft.crash((Minecraft)minecraft, (File)gameConfig.location.gameDirectory, (CrashReport)crashReport2);
            return null;
        }
        return minecraft;
    }

    public static void profilerPush(String str) {
        Profiler.get().push(str);
    }

    public static void profilerPop() {
        Profiler.get().pop();
    }

    public static void profilerPopPush(String str) {
        VersionCompatUtils.profilerPop();
        VersionCompatUtils.profilerPush(str);
    }

    public static long getMinecraftWindow() {
        Window window = Minecraft.getInstance().getWindow();
        if (window == null) {
            return 0L;
        }
        return window.handle();
    }
}

