/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.threading;

import com.google.common.collect.Queues;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import me.decce.ixeris.core.BlockingException;
import me.decce.ixeris.core.Ixeris;
import org.lwjgl.glfw.GLFW;

public class MainThreadDispatcher {
    public static final String BLOCKING_WARN_LOG = "A GLFW call has been made on non-main thread. This might lead to reduced performance.";
    private static final ConcurrentLinkedQueue<Runnable> mainThreadRecordingQueue = Queues.newConcurrentLinkedQueue();
    private static final Object mainThreadLock = new Object();
    private static boolean pollEvents;

    private static boolean shouldPollEvents() {
        return pollEvents && Ixeris.glfwInitialized;
    }

    public static boolean isOnThread() {
        return Ixeris.isOnMainThread();
    }

    public static <T> T query(Supplier<T> supplier) {
        if (MainThreadDispatcher.isOnThread()) {
            return supplier.get();
        }
        if (Ixeris.getConfig().shouldLogBlockingCalls()) {
            Ixeris.LOGGER.warn(BLOCKING_WARN_LOG, (Throwable)new BlockingException());
        }
        Query<T> query = new Query<T>(supplier);
        MainThreadDispatcher.sendToMainThread(query);
        while (!query.hasFinished) {
            Thread.onSpinWait();
        }
        return query.result;
    }

    public static void run(Runnable runnable) {
        if (Ixeris.getConfig().isFullyBlockingMode()) {
            MainThreadDispatcher.runNow(runnable);
        } else {
            MainThreadDispatcher.runLater(runnable);
        }
    }

    public static void runLater(Runnable runnable) {
        MainThreadDispatcher.sendToMainThread(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendToMainThread(Runnable runnable) {
        Object object = mainThreadLock;
        synchronized (object) {
            mainThreadRecordingQueue.add(runnable);
            mainThreadLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestPollEvents() {
        Object object = mainThreadLock;
        synchronized (object) {
            pollEvents = true;
            mainThreadLock.notify();
        }
    }

    public static void runNow(Runnable runnable) {
        if (MainThreadDispatcher.isOnThread()) {
            runnable.run();
            return;
        }
        if (Ixeris.getConfig().shouldLogBlockingCalls()) {
            Ixeris.LOGGER.warn(BLOCKING_WARN_LOG, (Throwable)new BlockingException());
        }
        MainThreadDispatcher.runNowImpl(runnable);
    }

    public static void runNowImpl(Runnable runnable) {
        ImmediateRunnable runnableWrapper = new ImmediateRunnable(runnable);
        MainThreadDispatcher.sendToMainThread(runnableWrapper);
        while (!runnableWrapper.hasFinished) {
            Thread.onSpinWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replayQueue() {
        while (true) {
            Runnable runnable;
            Object object = mainThreadLock;
            synchronized (object) {
                runnable = MainThreadDispatcher.findNextTask();
                if (runnable == null) {
                    MainThreadDispatcher.await(Ixeris.getConfig().getMainThreadSleepTime());
                    pollEvents = true;
                    break;
                }
            }
            runnable.run();
        }
    }

    private static Runnable findNextTask() {
        Runnable nextTask = mainThreadRecordingQueue.poll();
        if (nextTask == null && MainThreadDispatcher.shouldPollEvents()) {
            nextTask = GLFW::glfwPollEvents;
            pollEvents = false;
        }
        return nextTask;
    }

    public static void await(long timeout) {
        try {
            mainThreadLock.wait(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class Query<T>
    implements Runnable {
        private final Supplier<T> query;
        private volatile T result;
        private volatile boolean hasFinished;

        public Query(Supplier<T> query) {
            this.query = query;
        }

        @Override
        public void run() {
            this.result = this.query.get();
            this.hasFinished = true;
        }
    }

    private static class ImmediateRunnable
    implements Runnable {
        private final Runnable runnable;
        private volatile boolean hasFinished;

        public ImmediateRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
            this.hasFinished = true;
        }
    }
}

