/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.callback_dispatcher;

import it.unimi.dsi.fastutil.longs.Long2ReferenceArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.glfw.callback_dispatcher.CommonCallbacks;
import me.decce.ixeris.core.threading.RenderThreadDispatcher;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.system.Callback;

public class CharCallbackDispatcher {
    private static final Long2ReferenceMap<CharCallbackDispatcher> instance = Long2ReferenceMaps.synchronize((Long2ReferenceMap)new Long2ReferenceArrayMap(1));
    private final ReferenceArrayList<GLFWCharCallbackI> mainThreadCallbacks = new ReferenceArrayList(1);
    private boolean lastCallbackSet;
    public GLFWCharCallbackI lastCallback;
    public long lastCallbackAddress;
    private final long window;
    public volatile boolean suppressChecks;

    private CharCallbackDispatcher(long window) {
        this.window = window;
    }

    public static CharCallbackDispatcher get(long window) {
        if (window == Ixeris.accessor.getMinecraftWindow()) {
            return (CharCallbackDispatcher)instance.computeIfAbsent(window, CharCallbackDispatcher::new);
        }
        return (CharCallbackDispatcher)instance.get(window);
    }

    public synchronized void registerMainThreadCallback(GLFWCharCallbackI callback) {
        this.mainThreadCallbacks.add((Object)callback);
        this.validate();
    }

    public synchronized long update(long newAddress) {
        this.suppressChecks = true;
        long ret = this.lastCallbackAddress;
        if (newAddress == 0L && this.mainThreadCallbacks.isEmpty()) {
            GLFW.nglfwSetCharCallback((long)this.window, (long)0L);
        } else {
            GLFW.nglfwSetCharCallback((long)this.window, (long)CommonCallbacks.charCallback.address());
        }
        this.lastCallbackAddress = newAddress;
        if (!this.lastCallbackSet) {
            this.lastCallback = newAddress == 0L ? null : (GLFWCharCallbackI)Callback.get((long)newAddress);
        }
        this.lastCallbackSet = false;
        this.suppressChecks = false;
        return ret;
    }

    public synchronized void update(GLFWCharCallbackI callback) {
        this.lastCallback = callback;
        this.lastCallbackSet = true;
    }

    public synchronized void validate() {
        this.suppressChecks = true;
        long current = GLFW.nglfwSetCharCallback((long)this.window, (long)CommonCallbacks.charCallback.address());
        if (current == 0L) {
            if (this.mainThreadCallbacks.isEmpty()) {
                GLFW.nglfwSetCharCallback((long)this.window, (long)0L);
            }
        } else if (current != CommonCallbacks.charCallback.address()) {
            this.lastCallback = (GLFWCharCallbackI)Callback.get((long)current);
            this.lastCallbackAddress = current;
        }
        this.suppressChecks = false;
    }

    public void onCallback(long window, int codepoint) {
        if (this.window != window) {
            return;
        }
        for (int i = 0; i < this.mainThreadCallbacks.size(); ++i) {
            ((GLFWCharCallbackI)this.mainThreadCallbacks.get(i)).invoke(window, codepoint);
        }
        if (this.lastCallback != null) {
            RenderThreadDispatcher.runLater(() -> {
                if (this.lastCallback != null) {
                    this.lastCallback.invoke(window, codepoint);
                }
            });
        }
    }

    @FunctionalInterface
    public static interface DispatchedRunnable
    extends Runnable {
    }
}

