/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.callback_dispatcher;

import it.unimi.dsi.fastutil.longs.Long2ReferenceArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.glfw.callback_dispatcher.CommonCallbacks;
import me.decce.ixeris.core.threading.RenderThreadDispatcher;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWWindowIconifyCallbackI;
import org.lwjgl.system.Callback;

public class WindowIconifyCallbackDispatcher {
    private static final Long2ReferenceMap<WindowIconifyCallbackDispatcher> instance = Long2ReferenceMaps.synchronize((Long2ReferenceMap)new Long2ReferenceArrayMap(1));
    private final ReferenceArrayList<GLFWWindowIconifyCallbackI> mainThreadCallbacks = new ReferenceArrayList(1);
    private boolean lastCallbackSet;
    public GLFWWindowIconifyCallbackI lastCallback;
    public long lastCallbackAddress;
    private final long window;
    public volatile boolean suppressChecks;

    private WindowIconifyCallbackDispatcher(long window) {
        this.window = window;
    }

    public static WindowIconifyCallbackDispatcher get(long window) {
        if (window == Ixeris.accessor.getMinecraftWindow()) {
            return (WindowIconifyCallbackDispatcher)instance.computeIfAbsent(window, WindowIconifyCallbackDispatcher::new);
        }
        return (WindowIconifyCallbackDispatcher)instance.get(window);
    }

    public synchronized void registerMainThreadCallback(GLFWWindowIconifyCallbackI callback) {
        this.mainThreadCallbacks.add((Object)callback);
        this.validate();
    }

    public synchronized long update(long newAddress) {
        this.suppressChecks = true;
        long ret = this.lastCallbackAddress;
        if (newAddress == 0L && this.mainThreadCallbacks.isEmpty()) {
            GLFW.nglfwSetWindowIconifyCallback((long)this.window, (long)0L);
        } else {
            GLFW.nglfwSetWindowIconifyCallback((long)this.window, (long)CommonCallbacks.windowIconifyCallback.address());
        }
        this.lastCallbackAddress = newAddress;
        if (!this.lastCallbackSet) {
            this.lastCallback = newAddress == 0L ? null : (GLFWWindowIconifyCallbackI)Callback.get((long)newAddress);
        }
        this.lastCallbackSet = false;
        this.suppressChecks = false;
        return ret;
    }

    public synchronized void update(GLFWWindowIconifyCallbackI callback) {
        this.lastCallback = callback;
        this.lastCallbackSet = true;
    }

    public synchronized void validate() {
        this.suppressChecks = true;
        long current = GLFW.nglfwSetWindowIconifyCallback((long)this.window, (long)CommonCallbacks.windowIconifyCallback.address());
        if (current == 0L) {
            if (this.mainThreadCallbacks.isEmpty()) {
                GLFW.nglfwSetWindowIconifyCallback((long)this.window, (long)0L);
            }
        } else if (current != CommonCallbacks.windowIconifyCallback.address()) {
            this.lastCallback = (GLFWWindowIconifyCallbackI)Callback.get((long)current);
            this.lastCallbackAddress = current;
        }
        this.suppressChecks = false;
    }

    public void onCallback(long window, boolean iconified) {
        if (this.window != window) {
            return;
        }
        for (int i = 0; i < this.mainThreadCallbacks.size(); ++i) {
            ((GLFWWindowIconifyCallbackI)this.mainThreadCallbacks.get(i)).invoke(window, iconified);
        }
        if (this.lastCallback != null) {
            RenderThreadDispatcher.runLater(() -> {
                if (this.lastCallback != null) {
                    this.lastCallback.invoke(window, iconified);
                }
            });
        }
    }

    @FunctionalInterface
    public static interface DispatchedRunnable
    extends Runnable {
    }
}

