/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.glfw.state_caching.window;

import java.nio.IntBuffer;
import me.decce.ixeris.core.glfw.callback_dispatcher.WindowSizeCallbackDispatcher;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwWindowCache;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryStack;

public class GlfwWindowSizeCache
extends GlfwWindowCache {
    public static final int VALUE_UNINITIALIZED = -1;
    private volatile int width = -1;
    private volatile int height = -1;

    public GlfwWindowSizeCache(long window) {
        super(window);
        WindowSizeCallbackDispatcher.get(window).registerMainThreadCallback(this::onWindowSizeCallback);
        this.enableCache();
    }

    private void onWindowSizeCallback(long window, int width, int height) {
        if (this.window == window) {
            this.width = width;
            this.height = height;
        }
    }

    public void get(int[] width, int[] height) {
        if (this.width == -1 || this.height == -1) {
            this.blockingGet();
        }
        width[0] = this.width;
        height[0] = this.height;
    }

    public void get(IntBuffer width, IntBuffer height) {
        if (this.width == -1 || this.height == -1) {
            this.blockingGet();
        }
        width.put(this.width).flip();
        height.put(this.height).flip();
    }

    private void blockingGet() {
        this.disableCache();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer width = stack.mallocInt(1);
            IntBuffer height = stack.mallocInt(1);
            GLFW.glfwGetWindowSize((long)this.window, (IntBuffer)width, (IntBuffer)height);
            this.width = width.get();
            this.height = height.get();
        }
        this.enableCache();
    }
}

