/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.mixins.glfw_state_caching;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import me.decce.ixeris.core.Ixeris;
import me.decce.ixeris.core.glfw.state_caching.GlfwCacheManager;
import me.decce.ixeris.core.glfw.state_caching.global.GlfwKeyNameCache;
import me.decce.ixeris.core.glfw.state_caching.global.GlfwMonitorCache;
import me.decce.ixeris.core.glfw.state_caching.global.GlfwStandardCursorCache;
import me.decce.ixeris.core.glfw.state_caching.util.BufferHelper;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwCursorPosCache;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwFramebufferSizeCache;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwInputModeCache;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwKeyCache;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwMouseButtonCache;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwWindowAttribCache;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwWindowContentScaleCache;
import me.decce.ixeris.core.glfw.state_caching.window.GlfwWindowSizeCache;
import me.decce.ixeris.core.threading.MainThreadDispatcher;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GLFW.class}, remap=false)
public class GLFWMixin {
    @Inject(method={"glfwSetInputMode(JII)V"}, at={@At(value="TAIL")})
    private static void ixeris$glfwSetInputMode(long window, int mode, int value, CallbackInfo ci) {
        if (GlfwCacheManager.hasWindowCache(window)) {
            GlfwCacheManager.getWindowCache(window).inputMode().set(mode, value);
        }
    }

    @Inject(method={"glfwGetInputMode(JI)I"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetInputMode(long window, int mode, CallbackInfoReturnable<Integer> cir) {
        GlfwInputModeCache cache;
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).inputMode()).isCacheEnabled()) {
            cir.setReturnValue((Object)cache.get(mode));
            return;
        }
        cir.setReturnValue((Object)MainThreadDispatcher.query(() -> GLFW.glfwGetInputMode((long)window, (int)mode)));
    }

    @Inject(method={"glfwGetKey(JI)I"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetKey(long window, int key, CallbackInfoReturnable<Integer> cir) {
        GlfwKeyCache cache;
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).keys()).isCacheEnabled()) {
            int ret = cache.get(key);
            if (ret == 2) {
                ret = 1;
            }
            cir.setReturnValue((Object)ret);
            return;
        }
        cir.setReturnValue((Object)MainThreadDispatcher.query(() -> GLFW.glfwGetKey((long)window, (int)key)));
    }

    @Inject(method={"glfwGetKeyName(II)Ljava/lang/String;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetKeyName(int key, int scancode, CallbackInfoReturnable<String> cir) {
        GlfwKeyNameCache cache = GlfwCacheManager.getGlobalCache().keyNames();
        if (cache.isCacheEnabled()) {
            cir.setReturnValue((Object)cache.get(key, scancode));
        } else if (!Ixeris.isOnMainThread()) {
            cir.setReturnValue((Object)MainThreadDispatcher.query(() -> GLFW.glfwGetKeyName((int)key, (int)scancode)));
        }
    }

    @Inject(method={"glfwGetMouseButton(JI)I"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetMouseButton(long window, int button, CallbackInfoReturnable<Integer> cir) {
        GlfwMouseButtonCache cache;
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).mouseButtons()).isCacheEnabled()) {
            cir.setReturnValue((Object)cache.get(button));
            return;
        }
        cir.setReturnValue((Object)MainThreadDispatcher.query(() -> GLFW.glfwGetMouseButton((long)window, (int)button)));
    }

    @Inject(method={"glfwGetPrimaryMonitor()J"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetPrimaryMonitor(CallbackInfoReturnable<Long> cir) {
        if (Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        GlfwMonitorCache cache = GlfwCacheManager.getGlobalCache().monitors();
        if (cache.isCacheEnabled()) {
            cir.setReturnValue((Object)cache.getPrimaryMonitor());
        } else if (!Ixeris.isOnMainThread()) {
            cir.setReturnValue((Object)MainThreadDispatcher.query(GLFW::glfwGetPrimaryMonitor));
        }
    }

    @Inject(method={"glfwGetWindowMonitor(J)J"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetWindowMonitor(long window, CallbackInfoReturnable<Long> cir) {
        me.decce.ixeris.core.glfw.state_caching.window.GlfwMonitorCache cache;
        if (Ixeris.isOnMainThread() || Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).monitor()).isCacheEnabled()) {
            cir.setReturnValue((Object)cache.get());
            return;
        }
        cir.setReturnValue((Object)MainThreadDispatcher.query(() -> GLFW.glfwGetWindowMonitor((long)window)));
    }

    @Inject(method={"glfwSetWindowMonitor(JJIIIII)V"}, at={@At(value="TAIL")})
    private static void ixeris$glfwSetWindowMonitor(long window, long monitor, int xpos, int ypos, int width, int height, int refreshRate, CallbackInfo ci) {
        if (GlfwCacheManager.hasWindowCache(window)) {
            GlfwCacheManager.getWindowCache(window).monitor().set(monitor);
        }
    }

    @Inject(method={"glfwCreateStandardCursor(I)J"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwCreateStandardCursor(int shape, CallbackInfoReturnable<Long> cir) {
        if (Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        GlfwStandardCursorCache cache = GlfwCacheManager.getGlobalCache().standardCursors();
        if (cache.isCacheEnabled()) {
            cir.setReturnValue((Object)cache.create(shape));
        } else if (!Ixeris.isOnMainThread()) {
            cir.setReturnValue((Object)MainThreadDispatcher.query(() -> GLFW.glfwCreateStandardCursor((int)shape)));
        }
    }

    @Inject(method={"glfwDestroyCursor(J)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwDestroyCursor(long cursor, CallbackInfo ci) {
        if (Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        GlfwStandardCursorCache cache = GlfwCacheManager.getGlobalCache().standardCursors();
        if (cache.isCacheEnabled() && cache.isCached(cursor)) {
            ci.cancel();
            cache.destroy(cursor);
        } else if (!Ixeris.isOnMainThread()) {
            ci.cancel();
            MainThreadDispatcher.run(() -> GLFW.glfwDestroyCursor((long)cursor));
        }
    }

    @Inject(method={"glfwGetWindowSize(J[I[I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetWindowSize(long window, int[] width, int[] height, CallbackInfo ci) {
        GlfwWindowSizeCache cache;
        if (Ixeris.isOnMainThread() || Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).windowSize()).isCacheEnabled() && BufferHelper.check(width) && BufferHelper.check(height)) {
            ci.cancel();
            cache.get(width, height);
            return;
        }
        ci.cancel();
        MainThreadDispatcher.runNow(() -> GLFW.glfwGetWindowSize((long)window, (int[])width, (int[])height));
    }

    @Inject(method={"glfwGetWindowSize(JLjava/nio/IntBuffer;Ljava/nio/IntBuffer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetWindowSize(long window, IntBuffer width, IntBuffer height, CallbackInfo ci) {
        GlfwWindowSizeCache cache;
        if (Ixeris.isOnMainThread() || Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).windowSize()).isCacheEnabled() && BufferHelper.check(width) && BufferHelper.check(height)) {
            ci.cancel();
            cache.get(width, height);
            return;
        }
        ci.cancel();
        MainThreadDispatcher.runNow(() -> GLFW.glfwGetWindowSize((long)window, (IntBuffer)width, (IntBuffer)height));
    }

    @Inject(method={"glfwGetFramebufferSize(J[I[I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetFramebufferSize(long window, int[] width, int[] height, CallbackInfo ci) {
        GlfwFramebufferSizeCache cache;
        if (Ixeris.isOnMainThread() || Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).framebufferSize()).isCacheEnabled() && BufferHelper.check(width) && BufferHelper.check(height)) {
            ci.cancel();
            cache.get(width, height);
            return;
        }
        ci.cancel();
        MainThreadDispatcher.runNow(() -> GLFW.glfwGetFramebufferSize((long)window, (int[])width, (int[])height));
    }

    @Inject(method={"glfwGetFramebufferSize(JLjava/nio/IntBuffer;Ljava/nio/IntBuffer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetFramebufferSize(long window, IntBuffer width, IntBuffer height, CallbackInfo ci) {
        if (Ixeris.isOnMainThread() || Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window)) {
            GlfwFramebufferSizeCache cache = GlfwCacheManager.getWindowCache(window).framebufferSize();
            if (cache.isCacheEnabled() && BufferHelper.check(width) && BufferHelper.check(height)) {
                ci.cancel();
                cache.get(width, height);
            }
            return;
        }
        ci.cancel();
        MainThreadDispatcher.runNow(() -> GLFW.glfwGetFramebufferSize((long)window, (IntBuffer)width, (IntBuffer)height));
    }

    @Inject(method={"glfwGetWindowContentScale(J[F[F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetWindowContentScale(long window, float[] xscale, float[] yscale, CallbackInfo ci) {
        GlfwWindowContentScaleCache cache;
        if (Ixeris.isOnMainThread() || Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).contentScale()).isCacheEnabled() && BufferHelper.check(xscale) && BufferHelper.check(yscale)) {
            ci.cancel();
            cache.get(xscale, yscale);
            return;
        }
        ci.cancel();
        MainThreadDispatcher.runNow(() -> GLFW.glfwGetWindowContentScale((long)window, (float[])xscale, (float[])yscale));
    }

    @Inject(method={"glfwGetWindowContentScale(JLjava/nio/FloatBuffer;Ljava/nio/FloatBuffer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetWindowContentScale(long window, FloatBuffer xscale, FloatBuffer yscale, CallbackInfo ci) {
        GlfwWindowContentScaleCache cache;
        if (Ixeris.isOnMainThread() || Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).contentScale()).isCacheEnabled() && BufferHelper.check(xscale) && BufferHelper.check(yscale)) {
            ci.cancel();
            cache.get(xscale, yscale);
            return;
        }
        ci.cancel();
        MainThreadDispatcher.runNow(() -> GLFW.glfwGetWindowContentScale((long)window, (FloatBuffer)xscale, (FloatBuffer)yscale));
    }

    @Inject(method={"glfwGetWindowAttrib(JI)I"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetWindowAttrib(long window, int attrib, CallbackInfoReturnable<Integer> cir) {
        GlfwWindowAttribCache cache;
        if (Ixeris.isOnMainThread()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).attrib()).isCacheEnabled()) {
            cir.setReturnValue((Object)cache.get(attrib));
            return;
        }
        cir.setReturnValue((Object)MainThreadDispatcher.query(() -> GLFW.glfwGetWindowAttrib((long)window, (int)attrib)));
    }

    @Inject(method={"glfwGetCursorPos(J[D[D)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetCursorPos(long window, double[] xpos, double[] ypos, CallbackInfo ci) {
        GlfwCursorPosCache cache;
        if (Ixeris.isOnMainThread() || Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).cursorPos()).isCacheEnabled() && BufferHelper.check(xpos) && BufferHelper.check(ypos)) {
            ci.cancel();
            cache.get(xpos, ypos);
            return;
        }
        ci.cancel();
        MainThreadDispatcher.runNow(() -> GLFW.glfwGetCursorPos((long)window, (double[])xpos, (double[])ypos));
    }

    @Inject(method={"glfwGetCursorPos(JLjava/nio/DoubleBuffer;Ljava/nio/DoubleBuffer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void ixeris$glfwGetCursorPos(long window, DoubleBuffer xpos, DoubleBuffer ypos, CallbackInfo ci) {
        GlfwCursorPosCache cache;
        if (Ixeris.isOnMainThread() || Ixeris.getConfig().useFlexibleThreading()) {
            return;
        }
        if (GlfwCacheManager.hasWindowCache(window) && (cache = GlfwCacheManager.getWindowCache(window).cursorPos()).isCacheEnabled() && BufferHelper.check(xpos) && BufferHelper.check(ypos)) {
            ci.cancel();
            cache.get(xpos, ypos);
            return;
        }
        ci.cancel();
        MainThreadDispatcher.runNow(() -> GLFW.glfwGetCursorPos((long)window, (DoubleBuffer)xpos, (DoubleBuffer)ypos));
    }
}

