/*
 * Decompiled with CFR 0.152.
 */
package me.decce.ixeris.core.transform;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import me.decce.ixeris.core.util.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ClassLoaderHandler {
    public final ClassLoader bootstrapClassLoader;
    public final ClassLoader modClassLoader;
    public final MethodHandle DEFINE_CLASS = ReflectionHelper.unreflect(() -> ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE));
    public final MethodHandle RESOLVE_CLASS = ReflectionHelper.unreflect(() -> ClassLoader.class.getDeclaredMethod("resolveClass", Class.class));
    public static final Set<String> LEGAL_BOOTSTRAP_CLASSLOADERS = Set.of("MC-BOOTSTRAP", "SECURE-BOOTSTRAP", "app");
    public static final Set<String> LEGAL_MOD_CLASSLOADERS = Set.of("LAYER SERVICE", "TRANSFORMER", "FML Early Services");
    protected final Logger LOGGER = LogManager.getLogger();

    public ClassLoaderHandler(ClassLoader bootstrapClassLoader, ClassLoader modClassLoader) {
        this.bootstrapClassLoader = bootstrapClassLoader;
        this.modClassLoader = modClassLoader;
        this.verifyClassLoaders();
    }

    public void verifyClassLoaders() {
        if (!LEGAL_BOOTSTRAP_CLASSLOADERS.contains(this.bootstrapClassLoader.getName())) {
            throw new IllegalStateException("Ixeris found incorrect bootstrap classloader: " + this.bootstrapClassLoader.getName());
        }
        if (!LEGAL_MOD_CLASSLOADERS.contains(this.modClassLoader.getName())) {
            throw new IllegalStateException("Ixeris found incorrect mod classloader: " + this.modClassLoader.getName());
        }
    }

    public static String toClassName(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name.replace(".class", "").replace('/', '.');
    }

    public void loadCoreClasses(Class<?> modClass) {
        this.LOGGER.info("Loading Ixeris coremod");
        try (Stream<Path> stream = this.getClassesStream(modClass);){
            LinkedList<Path> classesToLoad = new LinkedList<Path>(stream.filter(p -> !Files.isDirectory(p, new LinkOption[0]) && p.toString().endsWith(".class")).toList());
            while (!classesToLoad.isEmpty()) {
                Path clazz = classesToLoad.remove(0);
                if (this.loadClass(clazz)) continue;
                classesToLoad.add(clazz);
            }
        }
    }

    protected Stream<Path> getClassesStream(Class<?> modClass) {
        URL resource = modClass.getResource("/me/decce/ixeris/core");
        try {
            return this.walkResource(Objects.requireNonNull(resource).toURI());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected Stream<Path> walkResource(URI resource) throws IOException {
        return Files.walk(Path.of(resource), new FileVisitOption[0]);
    }

    public byte[] readClassBytes(String name) {
        byte[] byArray;
        block8: {
            InputStream stream = Objects.requireNonNull(this.bootstrapClassLoader.getResourceAsStream(name));
            try {
                byArray = stream.readAllBytes();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return byArray;
    }

    private boolean loadClass(Path path) {
        try {
            String name = ClassLoaderHandler.toClassName(path.toString());
            this.defineClass(this.bootstrapClassLoader, name, Files.readAllBytes(path));
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void defineClass(ClassLoader cl, String name, byte[] bytes) throws Throwable {
        Class clazz = this.DEFINE_CLASS.invoke(cl, name, bytes, 0, bytes.length);
        this.RESOLVE_CLASS.invoke(cl, clazz);
    }

    public abstract void removeModClassesFromServiceLayer();
}

