/*
 * Decompiled with CFR 0.152.
 */
package com.avery.maybeinanewlife;

import com.avery.maybeinanewlife.lib.google.common.cache.Cache;
import com.avery.maybeinanewlife.lib.google.common.cache.CacheBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MaybeInANewLife
extends JavaPlugin
implements Listener {
    private Map<String, Integer> warnings;
    private FileConfiguration config;
    private boolean enableWarnings;
    private int maxWarnings;
    private boolean enableEffects;
    private boolean enableLogging;
    private File logFile;
    private HttpClient httpClient;
    private Cache<String, Boolean> contentCache;
    private final Map<String, Long> lastCheckTime = new ConcurrentHashMap<String, Long>();
    private final long CHECK_INTERVAL = 100L;

    public void onEnable() {
        this.warnings = new HashMap<String, Integer>();
        this.setupConfig();
        this.setupHttpClient();
        this.setupCache();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.setupCommands();
        this.displayStartupMessage();
        this.startAutoSave();
    }

    private void setupHttpClient() {
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    private void setupCache() {
        this.contentCache = CacheBuilder.newBuilder().maximumSize(this.config.getInt("cache.max-size", 1000)).expireAfterWrite(Duration.ofSeconds(this.config.getInt("cache.expire-after-write", 3600))).build();
    }

    private void setupConfig() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.enableWarnings = this.config.getBoolean("settings.enable-warnings", true);
        this.maxWarnings = this.config.getInt("settings.max-warnings", 3);
        this.enableEffects = this.config.getBoolean("effects.enabled", true);
        this.enableLogging = this.config.getBoolean("logging.enabled", true);
        if (this.enableLogging) {
            this.setupLogging();
        }
    }

    private void setupLogging() {
        this.logFile = new File(this.getDataFolder(), "violations.log");
        if (!this.logFile.exists()) {
            try {
                this.logFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create log file!");
            }
        }
    }

    private void setupCommands() {
        Objects.requireNonNull(this.getCommand("minl")).setExecutor((sender, command, label, args) -> {
            if (sender.hasPermission("maybeinanewlife.admin") && args.length > 0) {
                switch (args[0].toLowerCase()) {
                    case "reload": {
                        this.reloadConfiguration();
                        sender.sendMessage(ChatColor.GREEN + "Configuration reloaded!");
                        break;
                    }
                    case "stats": {
                        this.showStats(sender);
                    }
                }
            }
            return true;
        });
    }

    private CompletableFuture<Boolean> checkContentAsync(String text) {
        Boolean cachedResult = this.contentCache.getIfPresent(text);
        if (cachedResult != null) {
            return CompletableFuture.completedFuture(cachedResult);
        }
        String normalizedText = text.toLowerCase();
        long currentTime = System.currentTimeMillis();
        Long lastCheck = this.lastCheckTime.get(normalizedText);
        if (lastCheck != null && currentTime - lastCheck < 100L) {
            return CompletableFuture.completedFuture(false);
        }
        this.lastCheckTime.put(normalizedText, currentTime);
        return CompletableFuture.supplyAsync(() -> {
            try {
                String apiUrl = this.config.getString("api.purgomalum.endpoint", "https://www.purgomalum.com/service/containsprofanity") + "?text=" + URLEncoder.encode(text, "UTF-8");
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(apiUrl)).timeout(Duration.ofMillis(this.config.getInt("api.purgomalum.timeout", 5000))).GET().build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    boolean result = Boolean.parseBoolean(response.body());
                    this.contentCache.put(text, result);
                    return result;
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Error checking content", e);
            }
            return false;
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        String message = event.getMessage();
        this.checkContentAsync(message).thenAccept(inappropriate -> {
            if (inappropriate.booleanValue()) {
                event.setCancelled(true);
                this.handleViolation(player, message);
            }
        });
    }

    private void handleViolation(final Player player, String message) {
        if (this.enableLogging) {
            this.logViolation(player, message);
        }
        new BukkitRunnable(){

            public void run() {
                if (MaybeInANewLife.this.enableWarnings) {
                    int currentWarnings = MaybeInANewLife.this.warnings.getOrDefault(player.getName(), 0) + 1;
                    MaybeInANewLife.this.warnings.put(player.getName(), currentWarnings);
                    if (currentWarnings >= MaybeInANewLife.this.maxWarnings) {
                        MaybeInANewLife.this.executeConsequences(player);
                    } else {
                        MaybeInANewLife.this.sendWarning(player, currentWarnings);
                    }
                } else {
                    MaybeInANewLife.this.executeConsequences(player);
                }
            }
        }.runTask((Plugin)this);
    }

    private void executeConsequences(final Player player) {
        new BukkitRunnable(){

            public void run() {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("kill " + player.getName()));
                if (MaybeInANewLife.this.enableEffects) {
                    Location loc = player.getLocation();
                    if (MaybeInANewLife.this.config.getBoolean("effects.lightning.enabled", true)) {
                        int strikes = MaybeInANewLife.this.config.getInt("effects.lightning.strike-count", 3);
                        for (int i = 0; i < strikes; ++i) {
                            player.getWorld().strikeLightningEffect(loc);
                        }
                    }
                    if (MaybeInANewLife.this.config.getBoolean("effects.particles.enabled", true)) {
                        player.getWorld().spawnParticle(Particle.EXPLOSION_LARGE, loc, MaybeInANewLife.this.config.getInt("effects.particles.count", 1));
                    }
                    if (MaybeInANewLife.this.config.getBoolean("effects.sounds.enabled", true)) {
                        player.getWorld().playSound(loc, Sound.valueOf((String)MaybeInANewLife.this.config.getString("effects.sounds.sound", "ENTITY_GENERIC_EXPLODE")), (float)MaybeInANewLife.this.config.getDouble("effects.sounds.volume", 1.0), (float)MaybeInANewLife.this.config.getDouble("effects.sounds.pitch", 1.0));
                    }
                }
                String removalMessage = MaybeInANewLife.this.config.getString("messages.removal").replace("%player%", player.getName());
                String learnMessage = MaybeInANewLife.this.config.getString("messages.learn");
                Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)removalMessage));
                Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)learnMessage));
            }
        }.runTask((Plugin)this);
    }

    private void sendWarning(Player player, int currentWarnings) {
        String warning = this.config.getString("messages.warning").replace("%prefix%", this.config.getString("messages.prefix")).replace("%current%", String.valueOf(currentWarnings)).replace("%max%", String.valueOf(this.maxWarnings));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)warning));
    }

    private void logViolation(Player player, String message) {
        if (!this.enableLogging) {
            return;
        }
        try (FileWriter fw = new FileWriter(this.logFile, true);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter out = new PrintWriter(bw);){
            String logFormat = this.config.getString("logging.format").replace("%date%", new Date().toString()).replace("%type%", "VIOLATION").replace("%player%", player.getName()).replace("%message%", message);
            out.println(logFormat);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not log violation: " + e.getMessage());
        }
    }

    private void startAutoSave() {
        new BukkitRunnable(){

            public void run() {
                MaybeInANewLife.this.saveWarnings();
            }
        }.runTaskTimerAsynchronously((Plugin)this, 6000L, 6000L);
    }

    private void displayStartupMessage() {
        String[] startupMessage;
        for (String line : startupMessage = new String[]{"********************", "", "Maybe In a New Life...", "A life, where no one is bad,", "Where people can be who they want,", "Where there is peace,", "And where people can be happy for each other.", "", "--- Loading \"Maybe In a New Life\"", "--- Version 1.2", "--- Made by Avery (@cgcristi on discord)", "--- Remember to be good..", "", "********************"}) {
            this.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + line);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        int playerWarnings;
        Player player = event.getPlayer();
        if (this.enableWarnings && this.warnings.containsKey(player.getName()) && (playerWarnings = this.warnings.get(player.getName()).intValue()) > 0) {
            String warning = ChatColor.YELLOW + "\u00bb You have " + playerWarnings + "/" + this.maxWarnings + " warnings for inappropriate behavior.";
            player.sendMessage(warning);
        }
    }

    public void onDisable() {
        this.saveWarnings();
        this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "Maybe In a New Life plugin disabled.");
    }

    private void saveWarnings() {
        File warningsFile = new File(this.getDataFolder(), "warnings.yml");
        YamlConfiguration warningsConfig = new YamlConfiguration();
        this.warnings.forEach((player, count) -> warningsConfig.set(player, count));
        try {
            warningsConfig.save(warningsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save warnings: " + e.getMessage());
        }
    }

    private void reloadConfiguration() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.setupCache();
    }

    private void showStats(CommandSender sender) {
        sender.sendMessage(ChatColor.GREEN + "Plugin Statistics:");
        sender.sendMessage(ChatColor.YELLOW + "Players with warnings: " + this.warnings.size());
        sender.sendMessage(ChatColor.YELLOW + "Cache size: " + this.contentCache.size());
    }
}

