/*
 * Decompiled with CFR 0.152.
 */
package com.avery.maybeinanewlife.lib.google.common.cache;

import com.avery.maybeinanewlife.lib.google.common.annotations.GwtCompatible;
import com.avery.maybeinanewlife.lib.google.common.base.Preconditions;
import com.avery.maybeinanewlife.lib.google.common.cache.ElementTypesAreNonnullByDefault;
import com.avery.maybeinanewlife.lib.google.common.cache.RemovalCause;
import java.util.AbstractMap;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class RemovalNotification<K, V>
extends AbstractMap.SimpleImmutableEntry<K, V> {
    private final RemovalCause cause;
    private static final long serialVersionUID = 0L;

    public static <K, V> RemovalNotification<K, V> create(@CheckForNull K key, @CheckForNull V value, RemovalCause cause) {
        return new RemovalNotification<K, V>(key, value, cause);
    }

    private RemovalNotification(@CheckForNull K key, @CheckForNull V value, RemovalCause cause) {
        super(key, value);
        this.cause = Preconditions.checkNotNull(cause);
    }

    public RemovalCause getCause() {
        return this.cause;
    }

    public boolean wasEvicted() {
        return this.cause.wasEvicted();
    }
}

