/*
 * Decompiled with CFR 0.152.
 */
package com.avery.maybeinanewlife.lib.google.common.util.concurrent;

import com.avery.maybeinanewlife.lib.google.common.annotations.GwtCompatible;
import com.avery.maybeinanewlife.lib.google.common.base.Preconditions;
import com.avery.maybeinanewlife.lib.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class Platform {
    static boolean isInstanceOfThrowableClass(@CheckForNull Throwable t, Class<? extends Throwable> expectedClass) {
        return expectedClass.isInstance(t);
    }

    static void restoreInterruptIfIsInterruptedException(Throwable t) {
        Preconditions.checkNotNull(t);
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private Platform() {
    }
}

