/*
 * Decompiled with CFR 0.152.
 */
package de.duckyruby55.flyplugin;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class FlyPlugin
extends JavaPlugin {
    private Map<String, YamlConfiguration> langConfigs = new HashMap<String, YamlConfiguration>();
    private String defaultLanguage;
    private Map<UUID, Boolean> flightStatus = new HashMap<UUID, Boolean>();
    private FileConfiguration config;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.defaultLanguage = this.config.getString("settings.default-language", "en_US");
        this.loadLanguageFiles();
        this.getCommand("fly").setExecutor((CommandExecutor)this);
        this.getLogger().info(this.getMessage(this.defaultLanguage, "plugin-enabled"));
    }

    private void loadLanguageFiles() {
        String[] languages = new String[]{"de_DE", "en_US"};
        File langFolder = new File(this.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        for (String lang : languages) {
            File langFile = new File(langFolder, lang + ".lang");
            if (!langFile.exists()) {
                this.saveResource("lang/" + lang + ".lang", false);
            }
            try (InputStream stream = this.getResource("lang/" + lang + ".lang");){
                if (stream == null) continue;
                this.langConfigs.put(lang, YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)));
            }
            catch (Exception e) {
                this.getLogger().warning("Error loading language: " + lang);
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("flyplugin.use")) {
            this.sendMessage(sender, "no-permission", new String[0]);
            return true;
        }
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                this.sendMessage(sender, "console-no-self", new String[0]);
                return true;
            }
            this.toggleFlight((Player)sender, sender);
            return true;
        }
        if (args.length == 1) {
            if (!sender.hasPermission("flyplugin.others")) {
                this.sendMessage(sender, "no-permission-others", new String[0]);
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                this.sendMessage(sender, "player-not-found", args[0]);
                return true;
            }
            this.toggleFlight(target, sender);
            return true;
        }
        this.sendMessage(sender, "usage", new String[0]);
        return true;
    }

    public void toggleFlight(Player target, CommandSender feedbackSender) {
        boolean newState = !target.getAllowFlight();
        target.setAllowFlight(newState);
        if (newState) {
            target.setFlying(true);
        }
        this.flightStatus.put(target.getUniqueId(), newState);
        this.sendMessage((CommandSender)target, newState ? "fly-enabled" : "fly-disabled", new String[0]);
        if (!target.equals((Object)feedbackSender)) {
            String statusKey = newState ? "status-enabled" : "status-disabled";
            this.sendMessage(feedbackSender, "fly-other-toggled", target.getName(), this.getMessage(this.getPlayerLocale(target), statusKey));
        }
    }

    private void sendMessage(CommandSender sender, String key, String ... replacements) {
        String locale = sender instanceof Player ? this.getPlayerLocale((Player)sender) : this.defaultLanguage;
        String message = this.getMessage(locale, key);
        for (int i = 0; i < replacements.length; ++i) {
            message = message.replace("%" + (i + 1), replacements[i]);
        }
        String prefix = this.config.getString("messages.prefix", "\u00a78[\u00a7bFly\u00a78] \u00a77");
        sender.sendMessage(prefix + message);
    }

    public String getMessage(String locale, String key) {
        YamlConfiguration langConfig = this.langConfigs.getOrDefault(locale, this.langConfigs.get(this.defaultLanguage));
        return langConfig.getString(key, "\u00a7cMissing translation: " + key);
    }

    private String getPlayerLocale(Player player) {
        try {
            String locale = player.getLocale();
            return locale.substring(0, 2).toLowerCase() + "_" + locale.substring(3, 5).toUpperCase();
        }
        catch (Exception e) {
            return this.defaultLanguage;
        }
    }

    public void reloadPluginConfig() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.loadLanguageFiles();
    }

    public void onDisable() {
        this.getLogger().info(this.getMessage(this.defaultLanguage, "plugin-disabled"));
    }
}

