/*
 * Decompiled with CFR 0.152.
 */
package de.duckyruby55.flyplugin;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Messages {
    private final JavaPlugin plugin;
    private final Map<String, YamlConfiguration> languages = new HashMap<String, YamlConfiguration>();
    private String defaultLanguage = "en_US";

    public Messages(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadLanguages();
    }

    private void loadLanguages() {
        File langFolder = new File(this.plugin.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
            this.plugin.saveResource("lang/en_US.lang", false);
            this.plugin.saveResource("lang/de_DE.lang", false);
        }
        this.loadLanguage("en_US");
        this.loadLanguage("de_DE");
    }

    private void loadLanguage(String lang) {
        File langFile = new File(this.plugin.getDataFolder(), "lang/" + lang + ".lang");
        if (!langFile.exists()) {
            this.plugin.saveResource("lang/" + lang + ".lang", false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.plugin.getResource("lang/" + lang + ".lang"), StandardCharsets.UTF_8));
        this.languages.put(lang, config);
    }

    public String get(String key, String lang) {
        YamlConfiguration config = this.languages.getOrDefault(lang, this.languages.get(this.defaultLanguage));
        return config.getString(key, "\u00a7cMessage not found: " + key);
    }
}

