/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.waxedicons.gui;

import com.fanya.waxedicons.config.WaxedIconsConfig;
import com.fanya.waxedicons.config.WaxedIconsConfigManager;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class WaxedIconsConfigScreen
extends class_437 {
    private final class_437 parent;
    private final WaxedIconsConfig config;
    private StylePreviewWidget defaultPreview;
    private StylePreviewWidget alternativePreview;
    private StylePreviewWidget honeycombPreview;
    private final class_1799 previewItem = new class_1799((class_1935)class_1802.field_27071);
    private static final class_2960 DEFAULT_ICON = class_2960.method_60655((String)"waxedicons", (String)"textures/gui/waxed_icon_default.png");
    private static final class_2960 ALTERNATIVE_ICON = class_2960.method_60655((String)"waxedicons", (String)"textures/gui/waxed_icon_alternative.png");
    private static final class_2960 HONEYCOMB_ICON = class_2960.method_60655((String)"waxedicons", (String)"textures/gui/waxed_icon_honeycomb.png");
    private static final int PANEL_COLOR = -14013910;
    private static final int SELECTED_COLOR = -11908534;
    private static final int HOVER_COLOR = -12961222;
    private static final int ACCENT_COLOR = -10496;
    private static final int TEXT_COLOR = -1;
    private static final int SUBTITLE_COLOR = -3355444;
    private static final int BORDER_COLOR = -11184811;

    public WaxedIconsConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"title.waxedicons.config"));
        this.parent = parent;
        this.config = WaxedIconsConfigManager.getConfig();
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int contentWidth = Math.min(400, this.field_22789 - 40);
        int startX = centerX - contentWidth / 2;
        int currentY = 40;
        currentY += 40;
        int previewSize = Math.min(64, contentWidth / 5);
        int previewSpacing = (contentWidth - previewSize * 3) / 4;
        int previewY = currentY += 20;
        this.defaultPreview = new StylePreviewWidget(startX + previewSpacing, previewY, previewSize, previewSize, DEFAULT_ICON, "default", this.config.iconStyle.equals("default"));
        this.alternativePreview = new StylePreviewWidget(startX + previewSpacing * 2 + previewSize, previewY, previewSize, previewSize, ALTERNATIVE_ICON, "alternative", this.config.iconStyle.equals("alternative"));
        this.honeycombPreview = new StylePreviewWidget(startX + previewSpacing * 3 + previewSize * 2, previewY, previewSize, previewSize, HONEYCOMB_ICON, "honeycomb", this.config.iconStyle.equals("honeycomb"));
        this.method_37063((class_364)this.defaultPreview);
        this.method_37063((class_364)this.alternativePreview);
        this.method_37063((class_364)this.honeycombPreview);
        int sliderWidth = Math.min(300, contentWidth);
        ModernSliderWidget opacitySlider = new ModernSliderWidget(centerX - sliderWidth / 2, currentY += previewSize + 40, sliderWidth, 20, (class_2561)class_2561.method_43469((String)"option.waxedicons.opacity", (Object[])new Object[]{this.config.iconOpacity + "%"}), (double)this.config.iconOpacity / 100.0);
        this.method_37063((class_364)opacitySlider);
        int buttonY = this.field_22790 - 35;
        int buttonWidth = 80;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> this.saveAndClose()).method_46434(centerX - buttonWidth - 5, buttonY, buttonWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507(this.parent);
        }).method_46434(centerX + 5, buttonY, buttonWidth, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_57728(context, delta);
        context.method_25296(0, 0, this.field_22789, this.field_22790, 0x66101010, 0x66202020);
        int centerX = this.field_22789 / 2;
        context.method_27534(this.field_22793, this.field_22785, centerX, 20, -10496);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"option.waxedicons.icon_style"), centerX, 80, -3355444);
        this.drawStyleLabels(context);
        super.method_25394(context, mouseX, mouseY, delta);
        this.drawTooltips(context, mouseX, mouseY);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void drawStyleLabels(class_332 context) {
        int labelY = this.defaultPreview.method_46427() + this.defaultPreview.method_25364() + 8;
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"style.waxedicons.default"), this.defaultPreview.method_46426() + this.defaultPreview.method_25368() / 2, labelY, -1);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"style.waxedicons.alternative"), this.alternativePreview.method_46426() + this.alternativePreview.method_25368() / 2, labelY, -1);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"style.waxedicons.honeycomb"), this.honeycombPreview.method_46426() + this.honeycombPreview.method_25368() / 2, labelY, -1);
    }

    private void drawTooltips(class_332 context, int mouseX, int mouseY) {
        if (this.defaultPreview.method_25405(mouseX, mouseY)) {
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"style.waxedicons.default"), mouseX, mouseY);
        } else if (this.alternativePreview.method_25405(mouseX, mouseY)) {
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"style.waxedicons.alternative"), mouseX, mouseY);
        } else if (this.honeycombPreview.method_25405(mouseX, mouseY)) {
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"style.waxedicons.honeycomb"), mouseX, mouseY);
        }
    }

    private void selectStyle(String style) {
        this.config.iconStyle = style;
        this.defaultPreview.setSelected(style.equals("default"));
        this.alternativePreview.setSelected(style.equals("alternative"));
        this.honeycombPreview.setSelected(style.equals("honeycomb"));
    }

    private void updatePreviewOpacity() {
        this.defaultPreview.updateOpacity((float)this.config.iconOpacity / 100.0f);
        this.alternativePreview.updateOpacity((float)this.config.iconOpacity / 100.0f);
        this.honeycombPreview.updateOpacity((float)this.config.iconOpacity / 100.0f);
    }

    private void saveAndClose() {
        WaxedIconsConfigManager.saveConfig();
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    public class StylePreviewWidget
    extends class_4185 {
        private final class_2960 iconTexture;
        private boolean selected;
        private float opacity;

        public StylePreviewWidget(int x, int y, int width, int height, class_2960 iconTexture, String style, boolean selected) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), button -> WaxedIconsConfigScreen.this.selectStyle(style), field_40754);
            this.iconTexture = iconTexture;
            this.selected = selected;
            this.opacity = (float)WaxedIconsConfigScreen.this.config.iconOpacity / 100.0f;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public void updateOpacity(float opacity) {
            this.opacity = opacity;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            int borderColor;
            int backgroundColor;
            int n = backgroundColor = this.selected ? -11908534 : -14013910;
            if (this.method_49606()) {
                backgroundColor = this.selected ? -11908534 : -12961222;
            }
            context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, backgroundColor);
            int n2 = borderColor = this.selected ? -10496 : -11184811;
            if (this.method_49606() && !this.selected) {
                borderColor = -8947849;
            }
            context.method_49601(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, borderColor);
            if (this.selected) {
                context.method_49601(this.method_46426() - 1, this.method_46427() - 1, this.field_22758 + 2, this.field_22759 + 2, -10496);
            }
            int slotSize = Math.min(32, this.field_22758 - 16);
            int slotX = this.method_46426() + (this.field_22758 - slotSize) / 2;
            int slotY = this.method_46427() + (this.field_22759 - slotSize) / 2;
            context.method_25294(slotX - 1, slotY - 1, slotX + slotSize + 1, slotY + slotSize + 1, -13421773);
            context.method_25294(slotX, slotY, slotX + slotSize, slotY + slotSize, -7631989);
            if (slotSize >= 16) {
                context.method_51448().method_22903();
                float scale = (float)slotSize / 16.0f;
                context.method_51448().method_22905(scale, scale, 1.0f);
                context.method_51427(WaxedIconsConfigScreen.this.previewItem, (int)((float)slotX / scale), (int)((float)slotY / scale));
                context.method_51448().method_22909();
            }
            if (this.iconTexture != null) {
                context.method_51448().method_22903();
                context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
                context.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
                int iconSize = Math.max(8, slotSize / 3);
                int iconX = slotX + slotSize - iconSize;
                context.method_25293(this.iconTexture, iconX, slotY, iconSize, iconSize, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                context.method_51448().method_22909();
            }
        }
    }

    public class ModernSliderWidget
    extends class_357 {
        public ModernSliderWidget(int x, int y, int width, int height, class_2561 message, double value) {
            super(x, y, width, height, message, value);
        }

        protected void method_25346() {
            int opacity = (int)Math.round(this.field_22753 * 100.0);
            this.method_25355((class_2561)class_2561.method_43469((String)"option.waxedicons.opacity", (Object[])new Object[]{opacity + "%"}));
        }

        protected void method_25344() {
            WaxedIconsConfigScreen.this.config.iconOpacity = (int)Math.round(this.field_22753 * 100.0);
            WaxedIconsConfigScreen.this.updatePreviewOpacity();
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            boolean result = super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
            this.method_25346();
            this.method_25344();
            return result;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            boolean result = super.method_25402(mouseX, mouseY, button);
            if (result) {
                this.method_25346();
                this.method_25344();
            }
            return result;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            int trackHeight = 4;
            int trackY = this.method_46427() + (this.field_22759 - trackHeight) / 2;
            context.method_25294(this.method_46426(), trackY, this.method_46426() + this.field_22758, trackY + trackHeight, -14013910);
            context.method_49601(this.method_46426(), trackY, this.field_22758, trackHeight, -11184811);
            int fillWidth = (int)(this.field_22753 * (double)this.field_22758);
            if (fillWidth > 0) {
                context.method_25294(this.method_46426(), trackY, this.method_46426() + fillWidth, trackY + trackHeight, -10496);
            }
            int handleWidth = 12;
            int handleHeight = this.field_22759;
            int handleX = this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - handleWidth));
            int handleColor = this.method_49606() ? -1 : -10496;
            context.method_25294(handleX, this.method_46427(), handleX + handleWidth, this.method_46427() + handleHeight, handleColor);
            context.method_49601(handleX, this.method_46427(), handleWidth, handleHeight, -11184811);
            context.method_27534(WaxedIconsConfigScreen.this.field_22793, this.method_25369(), this.method_46426() + this.field_22758 / 2, this.method_46427() - 12, -1);
        }
    }
}

