/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.waxedicons.config;

import com.fanya.waxedicons.WaxediconsClient;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_2960;

public class WaxedIconsConfig {
    public String iconStyle = "default";
    public int iconOpacity = 80;
    public static final String[] AVAILABLE_STYLES = new String[]{"default", "alternative", "honeycomb"};
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_FILE = Paths.get("config", "waxedicons.json");

    public class_2960 getIconTexture() {
        return class_2960.method_60655((String)"waxedicons", (String)("textures/gui/waxed_icon_" + this.iconStyle + ".png"));
    }

    public class_2960 getValidIconTexture() {
        return this.getIconTexture();
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(CONFIG_FILE.toFile());){
                GSON.toJson((Object)this, (Appendable)writer);
            }
            WaxediconsClient.LOGGER.info("Config saved to: {}", (Object)CONFIG_FILE);
        }
        catch (IOException e) {
            WaxediconsClient.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WaxedIconsConfig load() {
        if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
            try (FileReader reader = new FileReader(CONFIG_FILE.toFile());){
                WaxedIconsConfig config = (WaxedIconsConfig)GSON.fromJson((Reader)reader, WaxedIconsConfig.class);
                if (config != null) {
                    WaxediconsClient.LOGGER.info("Config loaded from: {}", (Object)CONFIG_FILE);
                    WaxedIconsConfig waxedIconsConfig = config;
                    return waxedIconsConfig;
                }
            }
            catch (Exception e) {
                WaxediconsClient.LOGGER.error("Failed to load config, using defaults", (Throwable)e);
            }
        }
        WaxedIconsConfig defaultConfig = new WaxedIconsConfig();
        defaultConfig.save();
        return defaultConfig;
    }
}

