/*
 * Decompiled with CFR 0.152.
 */
package de.mcmdev.staffprofiles;

import com.google.inject.Inject;
import com.velocitypowered.api.event.AwaitingEventExecutor;
import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.EventTask;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PreLoginEvent;
import com.velocitypowered.api.event.player.GameProfileRequestEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.util.GameProfile;
import de.mcmdev.staffprofiles.LoginRequest;
import de.mcmdev.staffprofiles.LoginResponse;
import de.mcmdev.staffprofiles.Staffprofiles;
import de.mcmdev.staffprofiles.permission.LuckPermsPermissionProvider;
import java.nio.file.Path;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(id="staffprofiles", name="staffprofiles", authors={"MCMDEV"}, dependencies={@Dependency(id="luckperms")}, description="Assigns staff members a different game profile if\nthey are joining using a specific hostname.", url="https://github.com/MCMDEV/staffprofiles", version="1.0.0")
public class StaffprofilesVelocity {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaffprofilesVelocity.class);
    private final ProxyServer proxyServer;
    private final Path dataDirectory;
    private Staffprofiles staffprofiles;

    @Inject
    public StaffprofilesVelocity(ProxyServer proxyServer, @DataDirectory Path dataDirectory) {
        this.proxyServer = proxyServer;
        this.dataDirectory = dataDirectory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        try {
            this.staffprofiles = Staffprofiles.create(this.dataDirectory, new LuckPermsPermissionProvider());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while enabling staffprofiles plugin", (Throwable)e);
            return;
        }
        this.proxyServer.getEventManager().register((Object)this, PreLoginEvent.class, (EventHandler)((AwaitingEventExecutor)this::onLogin));
        this.proxyServer.getEventManager().register((Object)this, GameProfileRequestEvent.class, (EventHandler)((AwaitingEventExecutor)this::onGameProfileRequest));
    }

    @Nullable
    private EventTask onLogin(PreLoginEvent event) {
        Optional rawVirtualHost = event.getConnection().getRawVirtualHost();
        if (rawVirtualHost.isEmpty()) {
            return null;
        }
        String hostname = (String)rawVirtualHost.get();
        return EventTask.async(() -> {
            if (event.getUniqueId() == null) {
                return;
            }
            LoginRequest loginRequest = new LoginRequest(hostname, event.getUsername(), event.getUniqueId());
            LoginResponse loginResponse = this.staffprofiles.login(loginRequest);
            if (loginResponse.type() != LoginResponse.Type.DENY) {
                return;
            }
            event.setResult(PreLoginEvent.PreLoginComponentResult.denied((Component)Component.text((String)loginResponse.reason())));
        });
    }

    @Nullable
    private EventTask onGameProfileRequest(GameProfileRequestEvent event) {
        Optional rawVirtualHost = event.getConnection().getRawVirtualHost();
        if (rawVirtualHost.isEmpty()) {
            return null;
        }
        String hostname = (String)rawVirtualHost.get();
        return EventTask.async(() -> {
            LoginRequest loginRequest = new LoginRequest(hostname, event.getOriginalProfile().getName(), event.getOriginalProfile().getId());
            LoginResponse loginResponse = this.staffprofiles.login(loginRequest);
            if (loginResponse.type() != LoginResponse.Type.ALLOW) {
                return;
            }
            event.setGameProfile(new GameProfile(loginResponse.uuid(), loginResponse.username(), event.getOriginalProfile().getProperties()));
        });
    }
}

