/*
 * Decompiled with CFR 0.152.
 */
package de.mcmdev.staffprofiles;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

final class StringTransformer {
    private final Pattern pattern;
    private final String replacement;

    private StringTransformer(String matching, String replacement) throws PatternSyntaxException {
        this.pattern = Pattern.compile(matching);
        this.replacement = replacement;
    }

    public static StringTransformer parse(String string) {
        String[] split = string.split("/", 2);
        return new StringTransformer(split[0], split[1]);
    }

    public String transform(String input) {
        return this.pattern.matcher(input).replaceAll(this.replacement);
    }

    static class Adapter
    implements JsonDeserializer<StringTransformer> {
        Adapter() {
        }

        public StringTransformer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return StringTransformer.parse(json.getAsString());
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }
}

