/*
 * Decompiled with CFR 0.152.
 */
package de.mcmdev.staffprofiles;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.mcmdev.staffprofiles.ConfigurationData;
import de.mcmdev.staffprofiles.PatternDeserializer;
import de.mcmdev.staffprofiles.StringTransformer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;

final class ConfigurationLoader {
    private static final String CONFIG_RESOURCE_NAME = "config.json";

    ConfigurationLoader() {
    }

    ConfigurationData load(Path dataDirectory) throws IOException {
        Path configPath = dataDirectory.resolve(CONFIG_RESOURCE_NAME);
        this.ensureConfigExists(configPath);
        try (BufferedReader reader = Files.newBufferedReader(configPath, StandardCharsets.UTF_8);){
            ConfigurationData configurationData = (ConfigurationData)this.getGson().fromJson((Reader)reader, ConfigurationData.class);
            return configurationData;
        }
    }

    private void ensureConfigExists(Path path) throws IOException {
        this.ensureParentDirectoryExists(path.getParent());
        if (!Files.exists(path, new LinkOption[0])) {
            this.copyDefaultConfiguration(path);
        }
    }

    private void ensureParentDirectoryExists(Path parentPath) throws IOException, IllegalStateException {
        if (Files.exists(parentPath, new LinkOption[0])) {
            if (!Files.isDirectory(parentPath, new LinkOption[0])) {
                throw new IllegalStateException(String.valueOf(parentPath) + " is not a directory");
            }
            return;
        }
        Files.createDirectories(parentPath, new FileAttribute[0]);
    }

    private void copyDefaultConfiguration(Path path) throws IOException {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(CONFIG_RESOURCE_NAME);){
            if (inputStream == null) {
                throw new IllegalStateException("Default configuration file not found");
            }
            Files.copy(inputStream, path, new CopyOption[0]);
        }
    }

    private Gson getGson() {
        return new GsonBuilder().setLenient().registerTypeAdapter(Pattern.class, (Object)new PatternDeserializer()).registerTypeAdapter(StringTransformer.class, (Object)new StringTransformer.Adapter()).setPrettyPrinting().create();
    }
}

