/*
 * Decompiled with CFR 0.152.
 */
package de.mcmdev.staffprofiles;

import com.destroystokyo.paper.profile.PlayerProfile;
import de.mcmdev.staffprofiles.LoginRequest;
import de.mcmdev.staffprofiles.LoginResponse;
import de.mcmdev.staffprofiles.Staffprofiles;
import java.util.Collection;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LoginListener
implements Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginListener.class);
    private final Staffprofiles staffprofiles;

    LoginListener(Staffprofiles staffprofiles) {
        this.staffprofiles = staffprofiles;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private void onAsyncPreLogin(AsyncPlayerPreLoginEvent event) {
        PlayerProfile playerProfile = event.getPlayerProfile();
        if (playerProfile.getId() == null || playerProfile.getName() == null) {
            LOGGER.warn("Invalid profile detected during login, ignoring");
            return;
        }
        LoginRequest loginRequest = new LoginRequest(event.getHostname(), playerProfile.getName(), playerProfile.getId());
        LoginResponse loginResponse = this.staffprofiles.login(loginRequest);
        switch (loginResponse.type()) {
            case IGNORE: {
                break;
            }
            case DENY: {
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, (Component)Component.text((String)loginResponse.reason()));
                break;
            }
            case ALLOW: {
                playerProfile.complete();
                PlayerProfile newProfile = Bukkit.createProfile((UUID)loginResponse.uuid(), (String)loginResponse.username());
                newProfile.setProperties((Collection)playerProfile.getProperties());
                event.setPlayerProfile(newProfile);
            }
        }
    }
}

