/*
 * Decompiled with CFR 0.152.
 */
package de.mcmdev.staffprofiles;

import java.util.UUID;
import org.jetbrains.annotations.Nullable;

final class LoginResponse {
    private static final String DENY_REASON = "You are not allowed to join using this hostname.";
    private static final String FAIL_REASON = "An error occurred during login. Please contact the server administrator.";
    private final Type type;
    @Nullable
    private final UUID uuid;
    @Nullable
    private final String username;
    @Nullable
    private final String reason;

    private LoginResponse(Type type, @Nullable UUID uuid, @Nullable String username, @Nullable String reason) {
        this.type = type;
        this.uuid = uuid;
        this.username = username;
        this.reason = reason;
    }

    static LoginResponse ignore() {
        return new LoginResponse(Type.IGNORE, null, null, null);
    }

    static LoginResponse allow(UUID newUUID, String newUsername) {
        return new LoginResponse(Type.ALLOW, newUUID, newUsername, null);
    }

    static LoginResponse deny() {
        return new LoginResponse(Type.DENY, null, null, DENY_REASON);
    }

    static LoginResponse fail() {
        return new LoginResponse(Type.DENY, null, null, FAIL_REASON);
    }

    public Type type() {
        return this.type;
    }

    @Nullable
    public UUID uuid() {
        return this.uuid;
    }

    @Nullable
    public String username() {
        return this.username;
    }

    @Nullable
    public String reason() {
        return this.reason;
    }

    public static enum Type {
        IGNORE,
        ALLOW,
        DENY;

    }
}

