/*
 * Decompiled with CFR 0.152.
 */
package de.mcmdev.staffprofiles;

import de.mcmdev.staffprofiles.ConfigurationData;
import de.mcmdev.staffprofiles.ConfigurationLoader;
import de.mcmdev.staffprofiles.LoginRequest;
import de.mcmdev.staffprofiles.LoginResponse;
import de.mcmdev.staffprofiles.permission.PermissionProvider;
import java.nio.file.Path;
import java.util.UUID;
import org.jetbrains.annotations.Blocking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Staffprofiles {
    private static final Logger LOGGER = LoggerFactory.getLogger(Staffprofiles.class);
    private final ConfigurationData configurationData;
    private final PermissionProvider permissionProvider;

    private Staffprofiles(ConfigurationData configurationData, PermissionProvider permissionProvider) {
        this.configurationData = configurationData;
        this.permissionProvider = permissionProvider;
    }

    public static Staffprofiles create(Path dataDirectory, PermissionProvider permissionProvider) throws Exception {
        ConfigurationData configurationData = new ConfigurationLoader().load(dataDirectory);
        return new Staffprofiles(configurationData, permissionProvider);
    }

    @Blocking
    LoginResponse login(LoginRequest loginRequest) {
        try {
            if (!this.matchesHostname(loginRequest.hostname())) {
                return LoginResponse.ignore();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load login response from staffprofiles.", (Throwable)e);
            return LoginResponse.ignore();
        }
        try {
            if (!this.hasPermission(loginRequest.uuid())) {
                return LoginResponse.deny();
            }
            UUID newUUID = this.transformUUID(loginRequest.uuid());
            String newUsername = this.transformUsername(loginRequest.username());
            LOGGER.info("User {} ({}) has logged in as {} ({})", new Object[]{loginRequest.username(), loginRequest.uuid(), newUsername, newUUID});
            return LoginResponse.allow(newUUID, newUsername);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load login response from staffprofiles.", (Throwable)e);
            return LoginResponse.fail();
        }
    }

    private boolean matchesHostname(String hostname) {
        return this.configurationData.hostRegex().matcher(hostname).matches();
    }

    private UUID transformUUID(UUID uuid) throws IllegalArgumentException {
        return UUID.fromString(this.configurationData.uuidTransformer().transform(uuid.toString()));
    }

    private String transformUsername(String username) {
        return this.configurationData.usernameTransformer().transform(username);
    }

    @Blocking
    private boolean hasPermission(UUID uuid) {
        return this.permissionProvider.hasPermission(uuid, this.configurationData.permission());
    }
}

