/*
 * Decompiled with CFR 0.152.
 */
package com.glythex.safe_harvest;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.slf4j.Logger;

@Mod(value="safe_harvest")
public final class SafeHarvestMod {
    public static final String MOD_ID = "safe_harvest";
    private static final Logger LOGGER = LogUtils.getLogger();
    static volatile boolean safeHarvestMode = false;
    static volatile boolean showMessages = true;

    public static boolean isSafeHarvestMode() {
        return safeHarvestMode;
    }

    @EventBusSubscriber(modid="safe_harvest", value={Dist.CLIENT})
    public static final class ClientEvents {
        private static KeyMapping TOGGLE_MODE;
        private static KeyMapping TOGGLE_MSGS;

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }

        @SubscribeEvent
        public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            TOGGLE_MODE = new KeyMapping("key.safe_harvest.toggle", InputConstants.Type.KEYSYM, 72, "key.categories.safe_harvest");
            TOGGLE_MSGS = new KeyMapping("key.safe_harvest.toggle_messages", InputConstants.Type.KEYSYM, 77, "key.categories.safe_harvest");
            event.register(TOGGLE_MODE);
            event.register(TOGGLE_MSGS);
        }

        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            String msgKey;
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            if (TOGGLE_MODE != null && mc.player.isShiftKeyDown()) {
                while (TOGGLE_MODE.consumeClick()) {
                    safeHarvestMode = !safeHarvestMode;
                    msgKey = safeHarvestMode ? "message.safe_harvest.enabled" : "message.safe_harvest.disabled";
                    mc.player.displayClientMessage((Component)Component.translatable((String)msgKey), true);
                }
            } else if (TOGGLE_MODE != null) {
                while (TOGGLE_MODE.consumeClick()) {
                }
            }
            if (TOGGLE_MSGS != null) {
                while (TOGGLE_MSGS.consumeClick()) {
                    showMessages = !showMessages;
                    msgKey = showMessages ? "message.safe_harvest.messages_enabled" : "message.safe_harvest.messages_disabled";
                    mc.player.displayClientMessage((Component)Component.translatable((String)msgKey), true);
                }
            }
        }
    }

    @EventBusSubscriber(modid="safe_harvest")
    public static final class CommonEvents {
        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
        }

        @SubscribeEvent
        public static void onAddCreative(BuildCreativeModeTabContentsEvent event) {
        }
    }
}

