/*
 * Decompiled with CFR 0.152.
 */
package com.glythex.safe_harvest;

import com.glythex.safe_harvest.SafeHarvestMod;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="safe_harvest")
public final class SafeHarvestHandler {
    private SafeHarvestHandler() {
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!SafeHarvestMod.isSafeHarvestMode()) {
            return;
        }
        BlockState state = event.getState();
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            if (!crop.isMaxAge(state)) {
                event.setCanceled(true);
                if (SafeHarvestMod.showMessages) {
                    player2.displayClientMessage((Component)Component.translatable((String)"message.safe_harvest.not_ready"), true);
                }
            }
            return;
        }
        if (block instanceof SaplingBlock) {
            event.setCanceled(true);
            if (SafeHarvestMod.showMessages) {
                player2.displayClientMessage((Component)Component.translatable((String)"message.safe_harvest.sapling_protected"), true);
            }
            return;
        }
        if (block instanceof SugarCaneBlock) {
            boolean isBaseSegment;
            BlockPos pos = event.getPos();
            Level level = (Level)event.getLevel();
            BlockPos belowPos = pos.below();
            BlockState belowState = level.getBlockState(belowPos);
            boolean bl = isBaseSegment = !level.isEmptyBlock(belowPos) && !(belowState.getBlock() instanceof SugarCaneBlock);
            if (isBaseSegment) {
                event.setCanceled(true);
                if (SafeHarvestMod.showMessages) {
                    player2.displayClientMessage((Component)Component.translatable((String)"message.safe_harvest.sugar_cane_protected"), true);
                }
            }
        }
    }
}

