/*
 * Decompiled with CFR 0.152.
 */
package dev.mja00.villagerLobotomizer;

import dev.mja00.villagerLobotomizer.VillagerLobotomizer;
import dev.mja00.villagerLobotomizer.utils.StringUtils;
import dev.mja00.villagerLobotomizer.utils.VillagerUtils;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class LobotomizeStorage {
    private static final EnumSet<Material> IMPASSABLE_REGULAR = EnumSet.of(Material.LAVA);
    private static final EnumSet<Material> IMPASSABLE_FLOOR = EnumSet.noneOf(Material.class);
    private static final EnumSet<Material> IMPASSABLE_TALL = EnumSet.noneOf(Material.class);
    private static final EnumSet<Material> IMPASSABLE_ALL;
    private static final EnumSet<Material> IMPASSABLE_REGULAR_FLOOR;
    private static final EnumSet<Material> IMPASSABLE_REGULAR_TALL;
    private static final EnumSet<Material> PROFESSION_BLOCKS;
    private static final EnumSet<Material> DOOR_BLOCKS;
    private final VillagerLobotomizer plugin;
    private final NamespacedKey key;
    private final Set<Villager> activeVillagers = Collections.newSetFromMap(new ConcurrentHashMap(128));
    private final Set<Villager> inactiveVillagers = Collections.newSetFromMap(new ConcurrentHashMap(128));
    private final Map<Chunk, Long> changedChunks = new ConcurrentHashMap<Chunk, Long>();
    private final Map<UUID, ScheduledTask> villagerTasks = new ConcurrentHashMap<UUID, ScheduledTask>();
    private final Set<String> exemptNames;
    private final long checkInterval;
    private final long inactiveCheckInterval;
    private final long restockInterval;
    private final long restockRandomRange;
    private final boolean onlyProfessions;
    private final boolean lobotomizePassengers;
    private final boolean checkRoof;
    private final boolean silentLobotomizedVillagers;
    private Sound restockSound;
    private Sound levelUpSound;
    private final Logger logger;
    private final Random random = new Random();
    private volatile boolean shuttingDown = false;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public LobotomizeStorage(VillagerLobotomizer plugin) {
        NamespacedKey key;
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.checkInterval = plugin.getConfig().getLong("check-interval");
        this.inactiveCheckInterval = plugin.getConfig().getLong("inactive-check-interval", this.checkInterval);
        this.restockInterval = plugin.getConfig().getLong("restock-interval");
        this.restockRandomRange = plugin.getConfig().getLong("restock-random-range");
        this.onlyProfessions = plugin.getConfig().getBoolean("only-lobotomize-villagers-with-professions");
        this.lobotomizePassengers = plugin.getConfig().getBoolean("always-lobotomize-villagers-in-vehicles");
        this.checkRoof = plugin.getConfig().getBoolean("check-roof");
        this.silentLobotomizedVillagers = plugin.getConfig().getBoolean("silent-lobotomized-villagers");
        String soundName = plugin.getConfig().getString("restock-sound");
        String levelUpSoundName = plugin.getConfig().getString("level-up-sound");
        soundName = this.convertLegacySoundName(soundName, "restock-sound");
        levelUpSoundName = this.convertLegacySoundName(levelUpSoundName, "level-up-sound");
        if (soundName.startsWith("minecraft:")) {
            soundName = soundName.replace("minecraft:", "");
        }
        if (levelUpSoundName.startsWith("minecraft:")) {
            levelUpSoundName = levelUpSoundName.replace("minecraft:", "");
        }
        List configNames = plugin.getConfig().getStringList("always-active-names");
        this.exemptNames = new HashSet<String>();
        this.exemptNames.addAll(configNames);
        if (!plugin.getConfig().getBoolean("ignore-villagers-stuck-in-doors")) {
            DOOR_BLOCKS.clear();
        }
        @NotNull Registry soundRegistry = RegistryAccess.registryAccess().getRegistry(RegistryKey.SOUND_EVENT);
        try {
            if (!soundName.isEmpty()) {
                key = new NamespacedKey("minecraft", soundName);
                this.restockSound = (Sound)soundRegistry.getOrThrow(key);
            } else {
                this.restockSound = null;
            }
        }
        catch (IllegalArgumentException | NoSuchElementException var4) {
            plugin.getLogger().warning("Unknown sound name \"" + soundName + "\"");
        }
        catch (Exception badError) {
            plugin.getLogger().warning("Unknown error while trying to get sound name \"" + soundName + "\". Villagers won't have any sounds.");
            plugin.getLogger().warning(badError.toString());
        }
        try {
            if (!levelUpSoundName.isEmpty()) {
                key = new NamespacedKey("minecraft", levelUpSoundName);
                this.levelUpSound = (Sound)soundRegistry.getOrThrow(key);
            } else {
                this.levelUpSound = null;
            }
        }
        catch (IllegalArgumentException | NoSuchElementException var5) {
            plugin.getLogger().warning("Unknown sound name \"" + levelUpSoundName + "\"");
        }
        catch (Exception badError) {
            plugin.getLogger().warning("Unknown error while trying to get sound name \"" + levelUpSoundName + "\". Villagers won't have any sounds.");
            plugin.getLogger().warning(badError.toString());
        }
        this.key = new NamespacedKey((Plugin)plugin, "lastRestock");
        Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)plugin, task -> this.processChunks(), 5L, 5L);
    }

    @NotNull
    public Set<Villager> getLobotomized() {
        return this.inactiveVillagers;
    }

    @NotNull
    public Set<Villager> getActive() {
        return this.activeVillagers;
    }

    public final void addVillager(@NotNull Villager villager) {
        if (this.shuttingDown || !this.plugin.isEnabled()) {
            return;
        }
        this.activeVillagers.add(villager);
        try {
            ScheduledTask task = villager.getScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> this.processVillagerSafely(villager), null, this.checkInterval, this.checkInterval);
            this.villagerTasks.put(villager.getUniqueId(), task);
        }
        catch (IllegalPluginAccessException e) {
            this.activeVillagers.remove(villager);
        }
        if (this.plugin.isDebugging()) {
            this.logger.info("[Debug] Tracked villager " + String.valueOf(villager) + " (" + String.valueOf(villager.getUniqueId()) + ") with per-entity scheduler");
        }
    }

    public final void removeVillager(@NotNull Villager villager) {
        boolean removed = false;
        boolean active = false;
        ScheduledTask task = this.villagerTasks.remove(villager.getUniqueId());
        if (task != null && !task.isCancelled()) {
            task.cancel();
        }
        if (this.activeVillagers.remove(villager)) {
            removed = true;
            active = true;
        }
        if (this.inactiveVillagers.remove(villager)) {
            removed = true;
            villager.getScheduler().run((Plugin)this.plugin, scheduledTask -> {
                villager.setAware(true);
                if (this.silentLobotomizedVillagers) {
                    villager.setSilent(false);
                }
            }, null);
        }
        if (this.plugin.isDebugging()) {
            if (removed) {
                this.logger.info("[Debug] Untracked villager " + String.valueOf(villager) + " (" + String.valueOf(villager.getUniqueId()) + "), marked as active = " + active + ", cancelled scheduler");
            } else {
                this.logger.info("[Debug] Attempted to untrack villager " + String.valueOf(villager) + " (" + String.valueOf(villager.getUniqueId()) + "), but it was not tracked");
            }
        }
    }

    public final void flush() {
        this.shuttingDown = true;
        for (ScheduledTask task2 : this.villagerTasks.values()) {
            if (task2 == null || task2.isCancelled()) continue;
            task2.cancel();
        }
        this.villagerTasks.clear();
        ArrayList<Villager> toFlush = new ArrayList<Villager>(this.inactiveVillagers);
        this.inactiveVillagers.clear();
        for (Villager villager : toFlush) {
            if (this.plugin.isDebugging()) {
                this.logger.info("Un-lobotomizing Villager " + String.valueOf(villager.getUniqueId()));
            }
            if (this.plugin.isFolia()) {
                this.logger.info("Some Villagers may remain lobotomized after shutdown. If you remove the plugin they will be lobotomized forever.");
            }
            try {
                villager.setAware(true);
                if (!this.silentLobotomizedVillagers) continue;
                villager.setSilent(false);
            }
            catch (IllegalStateException e) {
                try {
                    villager.getScheduler().run((Plugin)this.plugin, task -> {
                        villager.setAware(true);
                        if (this.silentLobotomizedVillagers) {
                            villager.setSilent(false);
                        }
                    }, null);
                }
                catch (Exception schedulerException) {
                    this.logger.warning("Failed to un-lobotomize villager " + String.valueOf(villager.getUniqueId()) + " during shutdown: " + e.getMessage());
                }
            }
            catch (Exception e) {
                this.logger.warning("Failed to un-lobotomize villager " + String.valueOf(villager.getUniqueId()) + " during shutdown: " + e.getMessage());
            }
        }
    }

    private void processVillagerSafely(@NotNull Villager villager) {
        boolean isActive = this.activeVillagers.contains(villager);
        boolean isInactive = this.inactiveVillagers.contains(villager);
        if (!isActive && !isInactive) {
            ScheduledTask task = this.villagerTasks.remove(villager.getUniqueId());
            if (task != null && !task.isCancelled()) {
                task.cancel();
            }
            return;
        }
        if (isActive) {
            boolean shouldRemove = this.processVillager(villager, true);
            if (shouldRemove) {
                this.activeVillagers.remove(villager);
            }
        } else {
            boolean shouldRemove = this.processVillager(villager, false);
            if (shouldRemove) {
                this.inactiveVillagers.remove(villager);
            }
        }
    }

    private boolean processVillager(@NotNull Villager villager, boolean active) {
        if (!villager.isValid() || villager.isDead()) {
            return true;
        }
        Location villagerLocation = villager.getLocation().add(0.0, 0.51, 0.0);
        if (!villager.getWorld().isChunkLoaded(villagerLocation.getBlockX() >> 4, villagerLocation.getBlockZ() >> 4)) {
            return false;
        }
        boolean shouldBeActive = this.shouldBeActive(villager);
        if (shouldBeActive) {
            if (!active) {
                villager.setAware(true);
                if (this.silentLobotomizedVillagers) {
                    villager.setSilent(false);
                }
                this.activeVillagers.add(villager);
                if (this.plugin.isDebugging()) {
                    this.logger.info("[Debug] Villager " + String.valueOf(villager) + " (" + String.valueOf(villager.getUniqueId()) + ") is now active");
                }
                return true;
            }
            if (this.plugin.isDebugging() && !this.plugin.isFolia() && this.plugin.getActiveVillagersTeam() != null) {
                this.plugin.getActiveVillagersTeam().addEntity((Entity)villager);
                villager.setGlowing(true);
            }
        } else {
            this.refreshTrades(villager);
            if (active) {
                villager.setAware(false);
                if (this.silentLobotomizedVillagers) {
                    villager.setSilent(true);
                }
                this.inactiveVillagers.add(villager);
                if (this.plugin.isDebugging()) {
                    this.logger.info("[Debug] Villager " + String.valueOf(villager) + " (" + String.valueOf(villager.getUniqueId()) + ") is now inactive");
                }
                return true;
            }
            if (this.plugin.isDebugging() && !this.plugin.isFolia() && this.plugin.getInactiveVillagersTeam() != null) {
                this.plugin.getInactiveVillagersTeam().addEntity((Entity)villager);
                villager.setGlowing(true);
            }
        }
        return false;
    }

    private boolean shouldRestock(@NotNull Villager villager) {
        return VillagerUtils.shouldRestock(villager, new NamespacedKey((Plugin)this.plugin, "lastRestockGameTime"), new NamespacedKey((Plugin)this.plugin, "lastRestockCheckDayTime"));
    }

    private void refreshTrades(@NotNull Villager villager) {
        int currentLevel;
        if (!villager.getWorld().isDayTime()) {
            return;
        }
        if (!VillagerUtils.isJobSiteNearby(villager)) {
            return;
        }
        PersistentDataContainer pdc = villager.getPersistentDataContainer();
        long lastRestock = (Long)pdc.getOrDefault(this.key, PersistentDataType.LONG, (Object)0L);
        long now = System.currentTimeMillis();
        if (now - lastRestock > this.restockInterval - (this.restockRandomRange > 0L ? this.random.nextLong(this.restockRandomRange) : 0L) && this.shouldRestock(villager)) {
            lastRestock = now;
            pdc.set(this.key, PersistentDataType.LONG, (Object)lastRestock);
            ArrayList recipes = new ArrayList(villager.getRecipes());
            for (MerchantRecipe recipe : recipes) {
                recipe.setUses(0);
            }
            villager.setRecipes(recipes);
            villager.setRestocksToday(villager.getRestocksToday() + 1);
            villager.updateDemand();
            if (this.restockSound != null) {
                villager.getWorld().playSound(villager.getLocation(), this.restockSound, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            } else {
                villager.getWorld().playSound(villager.getLocation(), VillagerUtils.PROFESSION_TO_SOUND.get(villager.getProfession()), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        }
        if ((currentLevel = villager.getVillagerLevel()) == 5) {
            return;
        }
        int expectedLevel = VillagerUtils.getVillagerLevel(villager);
        if (currentLevel < expectedLevel) {
            int increaseAmount = Math.max(0, expectedLevel - currentLevel);
            villager.increaseLevel(increaseAmount);
            if (this.levelUpSound != null) {
                villager.getWorld().playSound(villager.getLocation(), this.levelUpSound, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
            PotionEffect regenEffect = new PotionEffect(PotionEffectType.REGENERATION, 200, 0, false);
            villager.addPotionEffect(regenEffect);
            if (this.plugin.isDebugging()) {
                this.plugin.getLogger().info("Villager " + String.valueOf(villager.getUniqueId()) + " was leveled up to level " + expectedLevel + " from level " + currentLevel);
            }
        }
    }

    private boolean canMoveThrough(World w, int x, int y, int z, boolean roof) {
        boolean isChunkLoaded = w.isChunkLoaded(x >> 4, z >> 4);
        if (!isChunkLoaded) {
            return false;
        }
        Block blockAtHead = w.getBlockAt(x, y + 1, z);
        Block blockAtFeet = w.getBlockAt(x, y, z);
        Block blockUnderFeet = w.getBlockAt(x, y - 1, z);
        boolean isHeadImpassable = this.testImpassable(IMPASSABLE_REGULAR_FLOOR, blockAtHead, false);
        boolean isFeetImpassable = this.testImpassable(IMPASSABLE_REGULAR, blockAtFeet, false);
        boolean isUnderFeetImpassable = this.testImpassable(IMPASSABLE_TALL, blockUnderFeet, true);
        return !isHeadImpassable && !isFeetImpassable && (!roof || !isUnderFeetImpassable);
    }

    private boolean testImpassable(@NotNull EnumSet<Material> set, @NotNull Block b, boolean onlyTallBlocks) {
        Material type = b.getType();
        if (set.contains(type)) {
            return true;
        }
        if (onlyTallBlocks) {
            return false;
        }
        boolean isCarpet = type.name().contains("_CARPET");
        boolean isBed = type.name().contains("_BED");
        boolean isWater = type == Material.WATER;
        BlockData blockData = b.getBlockData();
        boolean isCrop = blockData instanceof Ageable;
        boolean isABypassBlock = isCrop || isBed || isCarpet || DOOR_BLOCKS.contains(type);
        boolean isNonSolid = !type.isSolid() && this.plugin.getConfig().getBoolean("ignore-non-solid-blocks") && !PROFESSION_BLOCKS.contains(type);
        return !isWater && !b.isPassable() && !isABypassBlock && !isNonSolid || set.contains(type);
    }

    private boolean canMoveCardinally(World w, int x, int y, int z, boolean roof) {
        Boolean xPlusOne = this.canMoveThrough(w, x + 1, y, z, roof);
        Boolean xMinusOne = this.canMoveThrough(w, x - 1, y, z, roof);
        Boolean zPlusOne = this.canMoveThrough(w, x, y, z + 1, roof);
        Boolean zMinusOne = this.canMoveThrough(w, x, y, z - 1, roof);
        return xPlusOne != false || xMinusOne != false || zPlusOne != false || zMinusOne != false;
    }

    public void handleBlockChange(Block block) {
        Chunk neighbor;
        if (this.plugin.isDisableChunkVillagerUpdate()) {
            return;
        }
        ArrayList<Chunk> chunksToProcess = new ArrayList<Chunk>();
        Chunk chunk = block.getChunk();
        chunksToProcess.add(chunk);
        int blockInChunkX = block.getX() & 0xF;
        int blockInChunkZ = block.getZ() & 0xF;
        World world = block.getWorld();
        if (blockInChunkX <= 1) {
            neighbor = world.getChunkAt(chunk.getX() - 1, chunk.getZ());
            chunksToProcess.add(neighbor);
        } else if (blockInChunkX >= 14) {
            neighbor = world.getChunkAt(chunk.getX() + 1, chunk.getZ());
            chunksToProcess.add(neighbor);
        }
        if (blockInChunkZ <= 1) {
            neighbor = world.getChunkAt(chunk.getX(), chunk.getZ() - 1);
            chunksToProcess.add(neighbor);
        } else if (blockInChunkZ >= 14) {
            neighbor = world.getChunkAt(chunk.getX(), chunk.getZ() + 1);
            chunksToProcess.add(neighbor);
        }
        for (Chunk c : chunksToProcess) {
            this.changedChunks.put(c, System.currentTimeMillis());
        }
    }

    private void processChunks() {
        long now = System.currentTimeMillis();
        this.changedChunks.entrySet().removeIf(entry -> {
            Chunk chunk = (Chunk)entry.getKey();
            long lastChange = (Long)entry.getValue();
            if (now - lastChange > 3000L) {
                return true;
            }
            if (!chunk.isLoaded()) {
                return true;
            }
            if (this.plugin.isChunkDebugging()) {
                this.logger.info("[Debug] Processing chunk " + chunk.getX() + ", " + chunk.getZ() + " for villagers");
            }
            if (chunk.isLoaded()) {
                this.scheduleChunkVillagerProcessing(chunk);
            }
            return false;
        });
    }

    private void scheduleChunkVillagerProcessing(Chunk chunk) {
        Entity[] entities;
        if (!chunk.isLoaded()) {
            return;
        }
        for (Entity entity : entities = chunk.getEntities()) {
            Villager villager;
            if (!(entity instanceof Villager) || !this.inactiveVillagers.contains(villager = (Villager)entity) && !this.activeVillagers.contains(villager)) continue;
            try {
                villager.getScheduler().run((Plugin)this.plugin, scheduledTask -> {
                    boolean isActive = this.activeVillagers.contains(villager);
                    if (this.processVillager(villager, isActive) && this.plugin.isDebugging()) {
                        this.logger.info("[Debug] Processed villager " + String.valueOf(villager) + " (" + String.valueOf(villager.getUniqueId()) + ") in chunk " + chunk.getX() + ", " + chunk.getZ());
                    }
                }, null);
            }
            catch (IllegalPluginAccessException illegalPluginAccessException) {
                // empty catch block
            }
        }
    }

    private boolean shouldBeActive(Villager villager) {
        String villagerName;
        Location villagerLoc = villager.getLocation().add(0.0, 0.51, 0.0);
        Component customName = villager.customName();
        String string = villagerName = customName == null ? "" : PlainTextComponentSerializer.plainText().serialize(customName).toLowerCase();
        if (villagerName.contains("nobrain")) {
            return false;
        }
        if (this.exemptNames.contains(villagerName)) {
            return true;
        }
        if (villager.isSwimming()) {
            return true;
        }
        Block feetBlock = villager.getWorld().getBlockAt(villagerLoc.getBlockX(), villagerLoc.getBlockY(), villagerLoc.getBlockZ());
        Block headBlock = villager.getWorld().getBlockAt(villagerLoc.getBlockX(), villagerLoc.getBlockY() + 1, villagerLoc.getBlockZ());
        if (feetBlock.getType() == Material.WATER || headBlock.getType() == Material.WATER) {
            return true;
        }
        if (villager.isSleeping()) {
            return true;
        }
        if (this.lobotomizePassengers && villager.getVehicle() instanceof Vehicle) {
            return false;
        }
        if (this.onlyProfessions && villager.getProfession() == Villager.Profession.NONE) {
            return true;
        }
        Material floorBlockMaterial = villager.getWorld().getBlockAt(villagerLoc.getBlockX(), villagerLoc.getBlockY() - 1, villagerLoc.getBlockZ()).getType();
        Block villagerRoof = villager.getWorld().getBlockAt(villagerLoc.getBlockX(), villagerLoc.getBlockY() + 2, villagerLoc.getBlockZ());
        if (this.checkRoof && villagerRoof.getType() == Material.AIR) {
            return true;
        }
        boolean hasRoof = floorBlockMaterial == Material.HONEY_BLOCK || this.testImpassable(IMPASSABLE_ALL, villagerRoof, false);
        return this.canMoveCardinally(villager.getWorld(), villagerLoc.getBlockX(), villagerLoc.getBlockY(), villagerLoc.getBlockZ(), hasRoof);
    }

    private String convertLegacySoundName(String soundName, String configKey) {
        String converted = StringUtils.convertLegacySoundNameFormat(soundName);
        if (!converted.equals(soundName)) {
            this.logger.info("Found legacy sound name in config, converting to new format and saving config.");
            this.plugin.getConfig().set(configKey, (Object)converted);
            this.plugin.saveConfig();
        }
        return converted;
    }

    static {
        DOOR_BLOCKS = EnumSet.noneOf(Material.class);
        for (Material m : Registry.MATERIAL) {
            if (m.isOccluding()) {
                IMPASSABLE_REGULAR.add(m);
            }
            if (m.name().contains("_CARPET")) {
                IMPASSABLE_FLOOR.add(m);
            }
            if (m.name().contains("_WALL") || m.name().contains("_FENCE")) {
                IMPASSABLE_TALL.add(m);
            }
            if (!m.name().contains("_DOOR")) continue;
            DOOR_BLOCKS.add(m);
        }
        IMPASSABLE_ALL = EnumSet.copyOf(IMPASSABLE_REGULAR);
        IMPASSABLE_REGULAR_FLOOR = EnumSet.copyOf(IMPASSABLE_REGULAR);
        IMPASSABLE_REGULAR_TALL = EnumSet.copyOf(IMPASSABLE_REGULAR);
        IMPASSABLE_ALL.addAll(IMPASSABLE_FLOOR);
        IMPASSABLE_ALL.addAll(IMPASSABLE_TALL);
        IMPASSABLE_REGULAR_FLOOR.addAll(IMPASSABLE_FLOOR);
        IMPASSABLE_REGULAR_TALL.addAll(IMPASSABLE_TALL);
        PROFESSION_BLOCKS = EnumSet.noneOf(Material.class);
        PROFESSION_BLOCKS.add(Material.BLAST_FURNACE);
        PROFESSION_BLOCKS.add(Material.SMOKER);
        PROFESSION_BLOCKS.add(Material.CARTOGRAPHY_TABLE);
        PROFESSION_BLOCKS.add(Material.BREWING_STAND);
        PROFESSION_BLOCKS.add(Material.COMPOSTER);
        PROFESSION_BLOCKS.add(Material.BARREL);
        PROFESSION_BLOCKS.add(Material.FLETCHING_TABLE);
        PROFESSION_BLOCKS.add(Material.CAULDRON);
        PROFESSION_BLOCKS.add(Material.LECTERN);
        PROFESSION_BLOCKS.add(Material.STONECUTTER);
        PROFESSION_BLOCKS.add(Material.LOOM);
        PROFESSION_BLOCKS.add(Material.SMITHING_TABLE);
        PROFESSION_BLOCKS.add(Material.GRINDSTONE);
    }
}

