/*
 * Decompiled with CFR 0.152.
 */
package dev.mja00.villagerLobotomizer.utils;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class StringUtils {
    public static int compareSemVer(@NotNull String version1, @NotNull String version2) {
        if (!version1.matches("\\d+\\.\\d+\\.\\d+") || !version2.matches("\\d+\\.\\d+\\.\\d+")) {
            return 0;
        }
        String[] v1Parts = version1.split("\\.");
        String[] v2Parts = version2.split("\\.");
        int length = Math.max(v1Parts.length, v2Parts.length);
        for (int i = 0; i < length; ++i) {
            int v2;
            int v1 = i < v1Parts.length ? Integer.parseInt(v1Parts[i]) : 0;
            int n = v2 = i < v2Parts.length ? Integer.parseInt(v2Parts[i]) : 0;
            if (v1 < v2) {
                return -1;
            }
            if (v1 <= v2) continue;
            return 1;
        }
        return 0;
    }

    public static String convertLegacySoundNameFormat(String soundName) {
        if (soundName != null && soundName.equals(soundName.toUpperCase(Locale.ROOT))) {
            return soundName.toLowerCase(Locale.ROOT).replace('_', '.');
        }
        return soundName;
    }
}

