/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.scaleme.client.mixin;

import com.github.kd_gaming1.scaleme.client.util.HypixelNpcUtil;
import com.github.kd_gaming1.scaleme.client.util.PlayerEntityRenderStateAccessor;
import com.github.kd_gaming1.scaleme.client.util.ScaleManager;
import com.github.kd_gaming1.scaleme.client.util.ScaleTransformer;
import com.github.kd_gaming1.scaleme.config.ScaleMeConfig;
import java.util.UUID;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_11890;
import net.minecraft.class_4587;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1007.class})
public class PlayerEntityRendererMixin {
    @Inject(method={"method_62604(Lnet/minecraft/class_11890;Lnet/minecraft/class_10055;F)V"}, at={@At(value="TAIL")})
    private void storePlayerData(class_11890 player, class_10055 renderState, float tickDelta, CallbackInfo ci) {
        if (player == null || renderState == null) {
            return;
        }
        if (!(player instanceof class_742)) {
            return;
        }
        class_742 clientPlayer = (class_742)player;
        PlayerEntityRenderStateAccessor accessor = (PlayerEntityRenderStateAccessor)renderState;
        accessor.scaleme$setPlayerUUID(clientPlayer.method_5667());
        accessor.scaleme$setPlayerEntity(clientPlayer);
    }

    @Inject(method={"method_4217(Lnet/minecraft/class_10055;Lnet/minecraft/class_4587;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void applyCustomScaling(class_10055 renderState, class_4587 matrices, CallbackInfo ci) {
        if (renderState == null || matrices == null) {
            return;
        }
        PlayerEntityRenderStateAccessor accessor = (PlayerEntityRenderStateAccessor)renderState;
        class_742 player = accessor.scaleme$getPlayerEntity();
        UUID playerUUID = accessor.scaleme$getPlayerUUID();
        if (player != null && HypixelNpcUtil.isHypixelNpc(player)) {
            if (ScaleMeConfig.enableNpcScaling) {
                float npcScale = ScaleManager.getNpcScale();
                ScaleTransformer.applyScale(matrices, npcScale);
                ci.cancel();
            }
            return;
        }
        if (this.scaleme$tryApplyPlayerScaling(playerUUID, matrices)) {
            ci.cancel();
        }
    }

    @Unique
    private boolean scaleme$tryApplyPlayerScaling(UUID playerUUID, class_4587 matrices) {
        if (playerUUID == null) {
            return false;
        }
        float scale = ScaleManager.getCurrentScale(playerUUID);
        ScaleTransformer.applyScale(matrices, scale);
        return true;
    }
}

