/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.scaleme.client.util;

import com.github.kd_gaming1.scaleme.client.data.PlayerPreset;
import com.github.kd_gaming1.scaleme.client.util.HypixelDetector;
import com.github.kd_gaming1.scaleme.client.util.ScaleConstants;
import com.github.kd_gaming1.scaleme.config.ScaleMeConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_640;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerPresetManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayerPresetManager.class);
    private static final String PRESET_FILE_NAME = "scaleme_player_presets.json";
    private static final float SMOOTH_INTERPOLATION_SPEED = 0.15f;
    private static final float SMOOTH_THRESHOLD = 0.001f;
    private static final List<PlayerPreset> presets = new CopyOnWriteArrayList<PlayerPreset>();
    private static final ConcurrentHashMap<UUID, Float> currentScales = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Float> targetScales = new ConcurrentHashMap();
    private static final File presetFile;
    private static final Gson gson;

    public static void init() {
        PlayerPresetManager.loadPresets();
        PlayerPresetManager.refreshAllScales();
    }

    public static float getCurrentScale(UUID playerUUID) {
        if (HypixelDetector.isSafeGameMode() || playerUUID == null) {
            return 1.0f;
        }
        Float cachedScale = currentScales.get(playerUUID);
        if (cachedScale != null) {
            return cachedScale.floatValue();
        }
        float scale = PlayerPresetManager.determineScale(playerUUID);
        currentScales.put(playerUUID, Float.valueOf(scale));
        targetScales.put(playerUUID, Float.valueOf(scale));
        return scale;
    }

    public static void tick() {
        PlayerPresetManager.refreshConfigBasedScales();
        if (ScaleMeConfig.smoothScaling) {
            PlayerPresetManager.applySmoothScaling();
        } else {
            PlayerPresetManager.applyInstantScaling();
        }
    }

    public static void addOrUpdatePreset(PlayerPreset preset) {
        if (!PlayerPresetManager.isValidPreset(preset)) {
            LOGGER.warn("Attempted to add invalid preset: {}", (Object)preset);
            return;
        }
        PlayerPresetManager.removePresetQuiet(preset.identifier);
        presets.add(preset);
        PlayerPresetManager.savePresets();
        PlayerPresetManager.refreshAllScales();
    }

    public static boolean removePreset(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return false;
        }
        boolean removed = presets.removeIf(p -> p.identifier.equalsIgnoreCase(identifier));
        if (removed) {
            PlayerPresetManager.savePresets();
            PlayerPresetManager.refreshAllScales();
        }
        return removed;
    }

    public static PlayerPreset getPreset(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return null;
        }
        return presets.stream().filter(p -> p.identifier.equalsIgnoreCase(identifier)).findFirst().orElse(null);
    }

    public static List<PlayerPreset> getAllPresets() {
        return new ArrayList<PlayerPreset>(presets);
    }

    public static boolean setPresetEnabled(String identifier, boolean enabled) {
        PlayerPreset preset = PlayerPresetManager.getPreset(identifier);
        if (preset == null) {
            return false;
        }
        preset.enabled = enabled;
        PlayerPresetManager.savePresets();
        PlayerPresetManager.refreshAllScales();
        return true;
    }

    public static void loadPresets() {
        presets.clear();
        if (!presetFile.exists()) {
            LOGGER.info("No preset file found, creating empty file");
            PlayerPresetManager.savePresets();
            return;
        }
        try (FileReader reader = new FileReader(presetFile);){
            Type listType = new TypeToken<List<PlayerPreset>>(){}.getType();
            List loaded = (List)gson.fromJson((Reader)reader, listType);
            if (loaded != null) {
                presets.addAll(loaded);
                LOGGER.info("Loaded {} preset(s) from disk", (Object)presets.size());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load presets: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void savePresets() {
        try {
            File parentDir = presetFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            try (FileWriter writer = new FileWriter(presetFile);){
                gson.toJson(presets, (Appendable)writer);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to save presets: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static float determineScale(UUID playerUUID) {
        class_310 client = class_310.method_1551();
        String playerName = PlayerPresetManager.getPlayerName(playerUUID, client);
        for (PlayerPreset preset : presets) {
            if (!preset.matchesPlayer(playerUUID, playerName)) continue;
            return ScaleConstants.clampScale(preset.scale);
        }
        if (PlayerPresetManager.isOwnPlayer(playerUUID, client)) {
            return ScaleConstants.clampScale(ScaleMeConfig.ownPlayerScale);
        }
        if (ScaleMeConfig.enableOtherPlayersScaling) {
            return ScaleConstants.clampScale(ScaleMeConfig.otherPlayersScale);
        }
        return 1.0f;
    }

    private static void applySmoothScaling() {
        for (Map.Entry<UUID, Float> entry : targetScales.entrySet()) {
            UUID uuid = entry.getKey();
            float target = entry.getValue().floatValue();
            float current = currentScales.getOrDefault(uuid, Float.valueOf(target)).floatValue();
            float smoothed = PlayerPresetManager.interpolateScale(current, target);
            currentScales.put(uuid, Float.valueOf(smoothed));
        }
    }

    private static void applyInstantScaling() {
        currentScales.putAll(targetScales);
    }

    private static float interpolateScale(float current, float target) {
        float difference = target - current;
        if (Math.abs(difference) <= 0.001f) {
            return target;
        }
        return current + difference * 0.15f;
    }

    private static void refreshAllScales() {
        PlayerPresetManager.refreshConfigBasedScales();
        PlayerPresetManager.refreshPresetBasedScales();
        PlayerPresetManager.cleanupStaleScales();
    }

    private static void refreshConfigBasedScales() {
        UUID ownUUID;
        class_310 client = class_310.method_1551();
        UUID uUID = ownUUID = client.field_1724 != null ? client.field_1724.method_5667() : null;
        if (ownUUID != null) {
            targetScales.put(ownUUID, Float.valueOf(ScaleMeConfig.ownPlayerScale));
        }
        if (ScaleMeConfig.enableOtherPlayersScaling) {
            PlayerPresetManager.updateOtherPlayersScale(ownUUID);
        } else {
            PlayerPresetManager.removeNonPresetPlayerScales(ownUUID);
        }
    }

    private static void refreshPresetBasedScales() {
        for (PlayerPreset preset : presets) {
            UUID resolvedUUID;
            if (!preset.enabled || (resolvedUUID = preset.resolveToUUID()) == null) continue;
            targetScales.put(resolvedUUID, Float.valueOf(preset.scale));
        }
    }

    private static void updateOtherPlayersScale(UUID ownUUID) {
        float defaultScale = ScaleMeConfig.otherPlayersScale;
        for (UUID uuid : targetScales.keySet()) {
            if (uuid.equals(ownUUID) || PlayerPresetManager.hasEnabledPreset(uuid)) continue;
            targetScales.put(uuid, Float.valueOf(defaultScale));
        }
    }

    private static void removeNonPresetPlayerScales(UUID ownUUID) {
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (UUID uuid : targetScales.keySet()) {
            if (uuid.equals(ownUUID) || PlayerPresetManager.hasEnabledPreset(uuid)) continue;
            toRemove.add(uuid);
        }
        for (UUID uuid : toRemove) {
            targetScales.remove(uuid);
            currentScales.remove(uuid);
        }
    }

    private static void cleanupStaleScales() {
        ((ConcurrentHashMap.CollectionView)((Object)currentScales.keySet())).retainAll(targetScales.keySet());
    }

    private static boolean hasEnabledPreset(UUID uuid) {
        String uuidString = uuid.toString();
        return presets.stream().anyMatch(p -> p.enabled && p.isUUID() && p.identifier.equalsIgnoreCase(uuidString));
    }

    private static String getPlayerName(UUID playerUUID, class_310 client) {
        class_640 entry;
        if (client.method_1562() != null && (entry = client.method_1562().method_2871(playerUUID)) != null) {
            return entry.method_2966().name();
        }
        return null;
    }

    private static boolean isOwnPlayer(UUID playerUUID, class_310 client) {
        return client.field_1724 != null && playerUUID.equals(client.field_1724.method_5667());
    }

    private static boolean isValidPreset(PlayerPreset preset) {
        return preset != null && preset.identifier != null && !preset.identifier.isEmpty() && ScaleConstants.isValidScale(preset.scale);
    }

    private static void removePresetQuiet(String identifier) {
        presets.removeIf(p -> p.identifier.equalsIgnoreCase(identifier));
    }

    static {
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        presetFile = new File(configDir, PRESET_FILE_NAME);
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

