/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.scaleme.client.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerUUIDResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayerUUIDResolver.class);
    private static final String MOJANG_API_URL = "https://api.mojang.com/users/profiles/minecraft/";
    private static final int HTTP_NOT_FOUND = 204;
    private static final String UUID_INSERTION_PATTERN = "(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})";
    private static final String UUID_FORMAT = "$1-$2-$3-$4-$5";
    private static final ConcurrentHashMap<String, UUID> uuidCache = new ConcurrentHashMap();

    public static UUID resolvePlayerUUID(String playerName) {
        if (PlayerUUIDResolver.isInvalidInput(playerName)) {
            return null;
        }
        String normalizedName = PlayerUUIDResolver.normalizeName(playerName);
        return uuidCache.computeIfAbsent(normalizedName, PlayerUUIDResolver::resolveUUIDInternal);
    }

    public static void clearCache() {
        uuidCache.clear();
        LOGGER.debug("UUID cache cleared");
    }

    public static int getCacheSize() {
        return uuidCache.size();
    }

    private static UUID resolveUUIDInternal(String normalizedName) {
        class_310 client = class_310.method_1551();
        UUID ownPlayerUUID = PlayerUUIDResolver.checkCurrentPlayer(normalizedName, client);
        if (ownPlayerUUID != null) {
            return ownPlayerUUID;
        }
        UUID playerListUUID = PlayerUUIDResolver.checkPlayerList(normalizedName, client);
        if (playerListUUID != null) {
            return playerListUUID;
        }
        UUID parsedUUID = PlayerUUIDResolver.tryParseUUID(normalizedName);
        if (parsedUUID != null) {
            return parsedUUID;
        }
        return PlayerUUIDResolver.queryMojangAPI(normalizedName);
    }

    private static UUID checkCurrentPlayer(String normalizedName, class_310 client) {
        if (client.field_1724 == null) {
            return null;
        }
        String playerName = client.field_1724.method_5477().getString().toLowerCase();
        if (normalizedName.equals(playerName)) {
            return client.field_1724.method_5667();
        }
        return null;
    }

    private static UUID checkPlayerList(String normalizedName, class_310 client) {
        if (client.method_1562() == null) {
            return null;
        }
        return client.method_1562().method_2880().stream().filter(entry -> entry.method_2966().name().equalsIgnoreCase(normalizedName)).map(entry -> entry.method_2966().id()).findFirst().orElse(null);
    }

    private static UUID tryParseUUID(String input) {
        try {
            return UUID.fromString(input);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static UUID queryMojangAPI(String playerName) {
        try {
            String apiUrl = MOJANG_API_URL + playerName;
            HttpURLConnection connection = PlayerUUIDResolver.createConnection(apiUrl);
            if (connection.getResponseCode() == 204) {
                LOGGER.info("Player '{}' not found in Mojang database", (Object)playerName);
                return null;
            }
            String responseJson = PlayerUUIDResolver.readResponse(connection);
            return PlayerUUIDResolver.parseUUIDFromJson(responseJson, playerName);
        }
        catch (Exception e) {
            LOGGER.error("Failed to resolve UUID for '{}': {}", (Object)playerName, (Object)e.getMessage());
            return null;
        }
    }

    private static HttpURLConnection createConnection(String url) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)URI.create(url).toURL().openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        return connection;
    }

    private static String readResponse(HttpURLConnection connection) throws Exception {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            String string = response.toString();
            return string;
        }
    }

    private static UUID parseUUIDFromJson(String jsonResponse, String playerName) {
        try {
            JsonObject json = JsonParser.parseString((String)jsonResponse).getAsJsonObject();
            String uuidWithoutHyphens = json.get("id").getAsString();
            String formattedUUID = PlayerUUIDResolver.formatUUID(uuidWithoutHyphens);
            return UUID.fromString(formattedUUID);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse UUID from Mojang response for '{}': {}", (Object)playerName, (Object)e.getMessage());
            return null;
        }
    }

    private static String formatUUID(String uuidWithoutHyphens) {
        return uuidWithoutHyphens.replaceFirst(UUID_INSERTION_PATTERN, UUID_FORMAT);
    }

    private static boolean isInvalidInput(String input) {
        return input == null || input.isBlank();
    }

    private static String normalizeName(String playerName) {
        return playerName.trim().toLowerCase();
    }
}

