/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.scaleme.client.data;

import com.github.kd_gaming1.scaleme.client.util.PlayerUUIDResolver;
import com.github.kd_gaming1.scaleme.client.util.ScaleConstants;
import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import java.util.UUID;

public class PlayerPreset {
    @SerializedName(value="identifier")
    public String identifier;
    @SerializedName(value="friendlyName")
    public String friendlyName;
    @SerializedName(value="scale")
    public float scale;
    @SerializedName(value="enabled")
    public boolean enabled;

    public PlayerPreset(String identifier, String friendlyName, float scale) {
        this.validateIdentifier(identifier);
        this.validateScale(scale);
        this.identifier = identifier.trim();
        this.friendlyName = friendlyName != null && !friendlyName.trim().isEmpty() ? friendlyName.trim() : null;
        this.scale = ScaleConstants.clampScale(scale);
        this.enabled = true;
    }

    public void setScaleValidated(float scale) {
        this.validateScale(scale);
        this.scale = ScaleConstants.clampScale(scale);
    }

    public void setIdentifierValidated(String identifier) {
        this.validateIdentifier(identifier);
        this.identifier = identifier.trim();
    }

    public PlayerPreset copy() {
        PlayerPreset copy = new PlayerPreset(this.identifier, this.friendlyName, this.scale);
        copy.enabled = this.enabled;
        return copy;
    }

    public String getEffectiveDisplayName() {
        return this.friendlyName != null && !this.friendlyName.isEmpty() ? this.friendlyName : this.identifier;
    }

    public boolean matches(String id) {
        return this.enabled && this.identifier.equalsIgnoreCase(id);
    }

    public boolean matchesPlayer(UUID playerUUID, String playerName) {
        if (!this.enabled || playerUUID == null) {
            return false;
        }
        if (this.isUUID()) {
            try {
                return UUID.fromString(this.identifier).equals(playerUUID);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return playerName != null && this.identifier.equalsIgnoreCase(playerName);
    }

    public UUID resolveToUUID() {
        return PlayerUUIDResolver.resolvePlayerUUID(this.identifier);
    }

    public boolean isUUID() {
        return this.identifier != null && this.identifier.matches("^[0-9a-fA-F\\-]{36}$");
    }

    public boolean isUsername() {
        return this.identifier != null && this.identifier.matches("^[a-zA-Z0-9_]{3,16}$");
    }

    private void validateIdentifier(String identifier) {
        if (identifier == null || identifier.trim().isEmpty()) {
            throw new IllegalArgumentException("Identifier cannot be null or empty");
        }
    }

    private void validateScale(float scale) {
        if (!ScaleConstants.isValidScale(scale)) {
            throw new IllegalArgumentException(String.format("Scale must be between %.2f and %.2f", Float.valueOf(0.1f), Float.valueOf(3.0f)));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerPreset that = (PlayerPreset)o;
        return Float.compare(that.scale, this.scale) == 0 && this.enabled == that.enabled && Objects.equals(this.identifier, that.identifier) && Objects.equals(this.friendlyName, that.friendlyName);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.friendlyName, Float.valueOf(this.scale), this.enabled);
    }

    public String toString() {
        return String.format("PlayerPreset{identifier='%s', friendlyName='%s', scale=%.2f, enabled=%s}", this.identifier, this.friendlyName, Float.valueOf(this.scale), this.enabled);
    }
}

