/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.scaleme.client.gui;

import com.github.kd_gaming1.scaleme.client.data.PlayerPreset;
import com.github.kd_gaming1.scaleme.client.gui.components.PresetEditorComponent;
import com.github.kd_gaming1.scaleme.client.gui.components.PresetListEntryComponent;
import com.github.kd_gaming1.scaleme.client.util.PlayerPresetManager;
import eu.midnightdust.lib.config.MidnightConfig;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class ScaleMeManagerScreen
extends BaseOwoScreen<FlowLayout> {
    private FlowLayout presetList;
    private ScrollContainer<FlowLayout> scrollContainer;
    private PresetEditorComponent editorComponent;
    private final List<PresetListEntryComponent> entryComponents = new ArrayList<PresetListEntryComponent>();

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.horizontalAlignment(HorizontalAlignment.CENTER);
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT);
        FlowLayout titleSection = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.of((int)10));
        titleSection.child((Component)Components.label((class_2561)class_2561.method_30163((String)"ScaleMe Manager")).horizontalTextAlignment(HorizontalAlignment.CENTER).color(Color.WHITE).shadow(true));
        titleSection.child((Component)Components.label((class_2561)class_2561.method_30163((String)"Player-Specific Scaling")).horizontalTextAlignment(HorizontalAlignment.CENTER).color(Color.ofRgb((int)0xAAFFAA)).shadow(false).margins(Insets.top((int)2)));
        titleSection.child((Component)Components.label((class_2561)class_2561.method_30163((String)"Use 'Config' for personal and global scaling settings")).horizontalTextAlignment(HorizontalAlignment.CENTER).color(Color.ofRgb((int)0x888888)).shadow(false).margins(Insets.top((int)2)));
        rootComponent.child((Component)titleSection);
        FlowLayout splitRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)65)).gap(12).margins(Insets.horizontal((int)10)).horizontalAlignment(HorizontalAlignment.CENTER);
        FlowLayout leftColumn = Containers.verticalFlow((Sizing)Sizing.fill((int)49), (Sizing)Sizing.fill((int)100));
        FlowLayout rightColumn = Containers.verticalFlow((Sizing)Sizing.fill((int)49), (Sizing)Sizing.fill((int)100));
        splitRow.child((Component)leftColumn);
        splitRow.child((Component)rightColumn);
        rootComponent.child((Component)splitRow);
        this.buildLeftColumn(leftColumn);
        this.buildRightColumn(rightColumn);
        FlowLayout buttonRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)90), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.of((int)15));
        buttonRow.child((Component)Components.button((class_2561)class_2561.method_43470((String)"New Preset"), button -> this.editorComponent.createNewPreset()));
        buttonRow.child((Component)Components.button((class_2561)class_2561.method_43470((String)"Config"), button -> {
            if (this.field_22787.field_1724 != null) {
                this.field_22787.method_1507(MidnightConfig.getScreen((class_437)this.field_22787.field_1755, (String)"scaleme"));
            }
        }));
        buttonRow.child((Component)Components.button((class_2561)class_2561.method_43470((String)"Refresh"), button -> this.refreshPresetList()));
        buttonRow.child((Component)Components.button((class_2561)class_2561.method_43470((String)"Done"), button -> this.method_25419()));
        rootComponent.child((Component)buttonRow);
    }

    private void buildLeftColumn(FlowLayout leftColumn) {
        leftColumn.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Presets")).color(Color.WHITE).shadow(true).horizontalTextAlignment(HorizontalAlignment.CENTER).margins(Insets.of((int)2, (int)8, (int)2, (int)2)));
        this.presetList = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).padding(Insets.of((int)2));
        this.scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100), (Component)this.presetList);
        leftColumn.child(this.scrollContainer);
        this.refreshPresetList();
    }

    private void buildRightColumn(FlowLayout rightColumn) {
        rightColumn.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Editor")).color(Color.WHITE).shadow(true).horizontalTextAlignment(HorizontalAlignment.CENTER).margins(Insets.of((int)2, (int)8, (int)2, (int)2)));
        this.editorComponent = new PresetEditorComponent(this::onPresetUpdated, this::onPresetDeleted);
        rightColumn.child((Component)this.editorComponent);
    }

    private void refreshPresetList() {
        this.presetList.clearChildren();
        this.entryComponents.clear();
        for (PlayerPreset preset : PlayerPresetManager.getAllPresets()) {
            PresetListEntryComponent entry = new PresetListEntryComponent(preset);
            entry.mouseDown().subscribe((mouseX, mouseY, button) -> {
                if (button == 0) {
                    this.selectPreset(preset, entry);
                    return true;
                }
                return false;
            });
            this.entryComponents.add(entry);
            this.presetList.child((Component)entry);
        }
    }

    private void selectPreset(PlayerPreset preset, PresetListEntryComponent entryComponent) {
        this.editorComponent.editPreset(preset);
    }

    private void onPresetUpdated(PlayerPreset preset) {
        this.refreshPresetList();
    }

    private void onPresetDeleted(PlayerPreset preset) {
        this.refreshPresetList();
    }
}

