/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.scaleme.client.gui.components;

import com.github.kd_gaming1.scaleme.client.data.PlayerPreset;
import com.mojang.authlib.GameProfile;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1068;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_8685;

public class PresetListEntryComponent
extends FlowLayout {
    private static final int HEAD_SIZE = 24;
    private static final ConcurrentHashMap<UUID, class_8685> skinCache = new ConcurrentHashMap();
    private final PlayerPreset preset;
    private boolean isHovered = false;

    public PresetListEntryComponent(PlayerPreset preset) {
        super(Sizing.fill((int)100), Sizing.fixed((int)36), FlowLayout.Algorithm.HORIZONTAL);
        this.preset = preset;
        this.surface(this.getSurfaceForState(preset.enabled, false)).padding(Insets.of((int)6)).verticalAlignment(VerticalAlignment.CENTER).margins(Insets.vertical((int)2));
        this.mouseEnter().subscribe(() -> {
            this.isHovered = true;
            this.surface(this.getSurfaceForState(preset.enabled, true));
        });
        this.mouseLeave().subscribe(() -> {
            this.isHovered = false;
            this.surface(this.getSurfaceForState(preset.enabled, false));
        });
        this.buildLayout();
    }

    private void buildLayout() {
        FlowLayout headSection = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(0).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout headContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fixed((int)28), (Sizing)Sizing.fixed((int)28)).surface(Surface.flat((int)0x44000000)).padding(Insets.of((int)2)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        headContainer.child((Component)this.createPlayerHead(this.preset));
        headSection.child((Component)headContainer);
        this.child((Component)headSection);
        FlowLayout contentSection = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.expand(), (Sizing)Sizing.content()).gap(2).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout nameRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6).verticalAlignment(VerticalAlignment.CENTER);
        nameRow.child(Components.label((class_2561)class_2561.method_43470((String)this.preset.getEffectiveDisplayName())).color(this.getNameColor(this.preset.enabled)).shadow(false).sizing(Sizing.expand(), Sizing.content()));
        nameRow.child(Components.label((class_2561)class_2561.method_43470((String)(this.preset.enabled ? "\u25cf" : "\u25cb"))).color(this.preset.enabled ? Color.ofRgb((int)5025616) : Color.ofRgb((int)0x757575)).sizing(Sizing.content(), Sizing.content()));
        contentSection.child((Component)nameRow);
        FlowLayout scaleRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6).verticalAlignment(VerticalAlignment.CENTER);
        scaleRow.child(Components.label((class_2561)class_2561.method_43470((String)("Scale: " + String.format("%.2f", Float.valueOf(this.preset.scale))))).color(this.getScaleColor(this.preset)).shadow(false).sizing(Sizing.content(), Sizing.content()));
        if (this.preset.enabled) {
            scaleRow.child((Component)this.createScaleBar(this.preset.scale));
        }
        contentSection.child((Component)scaleRow);
        this.child((Component)contentSection);
        FlowLayout actionSection = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(2).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER);
        actionSection.child(Components.label((class_2561)class_2561.method_43470((String)(this.preset.enabled ? "ACTIVE" : "DISABLED"))).color(this.preset.enabled ? Color.ofRgb((int)5025616) : Color.ofRgb((int)16750592)).shadow(false).sizing(Sizing.content(), Sizing.content()));
        this.child((Component)actionSection);
    }

    private FlowLayout createScaleBar(float scale) {
        int barWidth = 40;
        int barHeight = 3;
        float normalizedScale = Math.max(0.0f, Math.min(1.0f, (scale - 0.1f) / 2.9f));
        int fillWidth = (int)((float)barWidth * normalizedScale);
        FlowLayout scaleBar = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fixed((int)barWidth), (Sizing)Sizing.fixed((int)barHeight)).surface(Surface.flat((int)0x33FFFFFF));
        if (fillWidth > 0) {
            scaleBar.child((Component)Components.box((Sizing)Sizing.fixed((int)fillWidth), (Sizing)Sizing.fixed((int)barHeight)).color(this.getScaleBarColor(scale)));
        }
        return scaleBar;
    }

    private Color getScaleBarColor(float scale) {
        if (scale < 0.8f) {
            return Color.ofRgb((int)2201331);
        }
        if (scale > 1.5f) {
            return Color.ofRgb((int)16733986);
        }
        return Color.ofRgb((int)5025616);
    }

    private Surface getSurfaceForState(boolean enabled, boolean hovered) {
        if (hovered) {
            return enabled ? Surface.flat((int)0x44424242).and(Surface.outline((int)-11751600)) : Surface.flat((int)0x44424242).and(Surface.outline((int)-9079435));
        }
        return enabled ? Surface.flat((int)0x33424242) : Surface.flat((int)0x22424242);
    }

    private Color getNameColor(boolean enabled) {
        return enabled ? Color.WHITE : Color.ofRgb((int)0xBBBBBB);
    }

    private Color getScaleColor(PlayerPreset preset) {
        if (!preset.enabled) {
            return Color.ofRgb((int)0x888888);
        }
        if (preset.scale < 0.8f) {
            return Color.ofRgb((int)8508666);
        }
        if (preset.scale > 1.5f) {
            return Color.ofRgb((int)16755601);
        }
        return Color.ofRgb((int)10868391);
    }

    private TextureComponent createPlayerHead(PlayerPreset preset) {
        class_8685 skinTextures = this.getSkinTextures(preset);
        class_2960 skinTexture = skinTextures.comp_1626();
        return (TextureComponent)Components.texture((class_2960)skinTexture, (int)8, (int)8, (int)8, (int)8, (int)64, (int)64).sizing(Sizing.fixed((int)24), Sizing.fixed((int)24));
    }

    private class_8685 getSkinTextures(PlayerPreset preset) {
        try {
            if (preset.isUUID()) {
                class_640 playerListEntry;
                UUID playerUUID = UUID.fromString(preset.identifier);
                class_8685 cached = skinCache.get(playerUUID);
                if (cached != null) {
                    return cached;
                }
                class_310 client = class_310.method_1551();
                if (client.method_1562() != null && (playerListEntry = client.method_1562().method_2871(playerUUID)) != null) {
                    class_8685 textures = playerListEntry.method_52810();
                    skinCache.put(playerUUID, textures);
                    return textures;
                }
                class_8685 defaultTextures = class_1068.method_4648((UUID)playerUUID);
                skinCache.put(playerUUID, defaultTextures);
                this.fetchSkinAsync(playerUUID, preset.getEffectiveDisplayName());
                return defaultTextures;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return class_1068.method_4648((UUID)UUID.randomUUID());
    }

    private void fetchSkinAsync(UUID playerUUID, String playerName) {
        class_156.method_18349().execute(() -> {
            try {
                class_310 client = class_310.method_1551();
                GameProfile profile = new GameProfile(playerUUID, playerName);
                GameProfile completeProfile = client.method_1495().fetchProfile(playerUUID, false).profile();
                if (completeProfile != null) {
                    client.method_1582().method_52863(completeProfile).thenAccept(optionalTextures -> optionalTextures.ifPresent(textures -> skinCache.put(playerUUID, (class_8685)textures)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

