/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.scaleme.client.util;

import java.util.Collection;
import java.util.regex.Pattern;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_8646;
import net.minecraft.class_9011;

public class HypixelDetector {
    private static final String HYPIXEL_BRAND = "hypixel";
    private static final String[] UNSAFE_MODE_PREFIXES = new String[]{"SKYBLOCK", "LOBBY", "LIMBO", "HOUSING", "PROTOTYPE", "HYPIXEL"};
    private static final String DUNGEON_MARKER_PREFIX = "CLEARED:";
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("\u00a7.");
    private static final char NBSP = '\u00a0';

    public static boolean isSafeGameMode() {
        class_310 client = class_310.method_1551();
        if (!HypixelDetector.isConnectedToServer(client)) {
            return false;
        }
        if (!HypixelDetector.isHypixelServer(client)) {
            return false;
        }
        String gameMode = HypixelDetector.getCurrentGameMode(client);
        if (gameMode == null) {
            return false;
        }
        return !HypixelDetector.isUnsafeGameMode(gameMode);
    }

    public static boolean isSafeForNPCScaling() {
        return !HypixelDetector.isSafeGameMode() && HypixelDetector.isInDungeon();
    }

    public static boolean isInDungeon() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return false;
        }
        class_269 scoreboard = client.field_1687.method_8428();
        class_266 objective = scoreboard.method_1189(class_8646.field_45157);
        if (objective == null) {
            return false;
        }
        Collection entries = scoreboard.method_1184(objective);
        for (class_9011 entry : entries) {
            String line = HypixelDetector.buildScoreboardLine(entry, scoreboard);
            String normalized = HypixelDetector.normalizeScoreboardLine(line);
            if (!HypixelDetector.isDungeonLine(normalized)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConnectedToServer(class_310 client) {
        return client.method_1562() != null;
    }

    private static boolean isHypixelServer(class_310 client) {
        String brand = client.method_1562().method_52790();
        return brand != null && brand.toLowerCase().contains(HYPIXEL_BRAND);
    }

    private static String getCurrentGameMode(class_310 client) {
        if (client.field_1687 == null) {
            return null;
        }
        class_269 scoreboard = client.field_1687.method_8428();
        class_266 objective = scoreboard.method_1189(class_8646.field_45157);
        if (objective == null) {
            return null;
        }
        String title = objective.method_1114().getString();
        return HypixelDetector.stripColors(title).toUpperCase();
    }

    private static boolean isUnsafeGameMode(String gameMode) {
        for (String unsafePrefix : UNSAFE_MODE_PREFIXES) {
            if (!gameMode.startsWith(unsafePrefix)) continue;
            return true;
        }
        return false;
    }

    private static String buildScoreboardLine(class_9011 entry, class_269 scoreboard) {
        String owner = entry.comp_2127();
        class_268 team = scoreboard.method_1164(owner);
        StringBuilder lineBuilder = new StringBuilder();
        if (team != null) {
            lineBuilder.append(team.method_1144().getString());
        }
        lineBuilder.append(owner);
        if (team != null) {
            lineBuilder.append(team.method_1136().getString());
        }
        return lineBuilder.toString();
    }

    private static String normalizeScoreboardLine(String line) {
        try {
            String noColors = HypixelDetector.stripColors(line);
            return noColors.replace('\u00a0', ' ').replaceAll("\\s+", " ").trim().toUpperCase();
        }
        catch (Exception e) {
            return line.toUpperCase().trim();
        }
    }

    private static boolean isDungeonLine(String normalizedLine) {
        return normalizedLine.startsWith(DUNGEON_MARKER_PREFIX) || normalizedLine.contains(DUNGEON_MARKER_PREFIX);
    }

    private static String stripColors(String text) {
        if (text == null) {
            return "";
        }
        return COLOR_CODE_PATTERN.matcher(text).replaceAll("");
    }
}

