/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.scaleme.client.util;

import com.github.kd_gaming1.scaleme.client.util.ScaleConstants;
import com.github.kd_gaming1.scaleme.config.ScaleMeConfig;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

public final class ScaleTransformer {
    private ScaleTransformer() {
        throw new AssertionError((Object)"Utility class should not be instantiated");
    }

    public static void applyScale(class_4587 matrices, float scale) {
        if (matrices == null) {
            return;
        }
        if (!ScaleConstants.isDefaultScale(scale)) {
            float clampedScale = ScaleConstants.clampScale(scale);
            matrices.method_22905(clampedScale, clampedScale, clampedScale);
        }
    }

    public static void applyRotations(class_4587 matrices, float pitch, float yaw, float roll) {
        if (matrices == null) {
            return;
        }
        if (pitch != 0.0f) {
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(pitch));
        }
        if (yaw != 0.0f) {
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(yaw));
        }
        if (roll != 0.0f) {
            matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(roll));
        }
    }

    public static void applyTranslation(class_4587 matrices, float x, float y, float z, float scale) {
        if (matrices == null) {
            return;
        }
        if (x == 0.0f && y == 0.0f && z == 0.0f) {
            return;
        }
        float safeScale = Math.max(0.01f, scale);
        matrices.method_46416(x / safeScale, y / safeScale, z / safeScale);
    }

    public static void applyItemTransform(class_4587 matrices, ItemTransformConfig config) {
        if (matrices == null || config == null) {
            return;
        }
        ScaleTransformer.applyRotations(matrices, config.pitch, config.yaw, config.roll);
        ScaleTransformer.applyScale(matrices, config.scale);
        ScaleTransformer.applyTranslation(matrices, config.xPos, config.yPos, config.zPos, config.scale);
    }

    public static class ItemTransformConfig {
        public final float pitch;
        public final float yaw;
        public final float roll;
        public final float scale;
        public final float xPos;
        public final float yPos;
        public final float zPos;

        public ItemTransformConfig(float pitch, float yaw, float roll, float scale, float xPos, float yPos, float zPos) {
            this.pitch = pitch;
            this.yaw = yaw;
            this.roll = roll;
            this.scale = ScaleConstants.clampScale(scale);
            this.xPos = xPos;
            this.yPos = yPos;
            this.zPos = zPos;
        }

        public static ItemTransformConfig fromConfig() {
            return new ItemTransformConfig(ScaleMeConfig.heldItemPitchRotation, ScaleMeConfig.heldItemYawRotation, ScaleMeConfig.heldItemRollRotation, ScaleMeConfig.itemScale, ScaleMeConfig.heldItemXPosition, ScaleMeConfig.heldItemYPosition, ScaleMeConfig.heldItemZPosition);
        }

        public boolean hasTransformations() {
            return this.pitch != 0.0f || this.yaw != 0.0f || this.roll != 0.0f || !ScaleConstants.isDefaultScale(this.scale) || this.xPos != 0.0f || this.yPos != 0.0f || this.zPos != 0.0f;
        }
    }
}

