/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.scaleme.client.command;

import com.github.kd_gaming1.scaleme.Scaleme;
import com.github.kd_gaming1.scaleme.client.data.PlayerPreset;
import com.github.kd_gaming1.scaleme.client.gui.ScaleMeManagerScreen;
import com.github.kd_gaming1.scaleme.client.util.PlayerPresetManager;
import com.github.kd_gaming1.scaleme.client.util.PlayerUUIDResolver;
import com.github.kd_gaming1.scaleme.client.util.ScaleConstants;
import com.github.kd_gaming1.scaleme.config.ScaleMeConfig;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class PresetCommand {
    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"scaleme").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)3.0f)).executes(PresetCommand::executeAdd))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(PresetCommand::executeRemove)))).then(ClientCommandManager.literal((String)"list").executes(PresetCommand::executeList))).then(ClientCommandManager.literal((String)"enable").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(PresetCommand::executeEnable)))).then(ClientCommandManager.literal((String)"disable").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(PresetCommand::executeDisable)))).then(ClientCommandManager.literal((String)"reload").executes(PresetCommand::executeReload))).then(ClientCommandManager.literal((String)"info").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(PresetCommand::executeInfo)))).then(ClientCommandManager.literal((String)"setdefault").then(ClientCommandManager.argument((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)3.0f)).executes(PresetCommand::executeSetDefault)))).then(ClientCommandManager.literal((String)"setown").then(ClientCommandManager.argument((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)3.0f)).executes(PresetCommand::executeSetOwn)))).then(ClientCommandManager.literal((String)"config").executes(PresetCommand::executeOpenConfig))).then(ClientCommandManager.literal((String)"manager").executes(PresetCommand::executeOpenManager))).then(ClientCommandManager.literal((String)"gui").executes(PresetCommand::executeOpenManager))));
    }

    private static int executeAdd(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        float scale = FloatArgumentType.getFloat(ctx, (String)"scale");
        if (!ScaleConstants.isValidScale(scale)) {
            PresetCommand.sendError(ctx, String.format("Scale must be between %.1f and %.1f", Float.valueOf(0.1f), Float.valueOf(3.0f)));
            return 0;
        }
        UUID playerUUID = PresetCommand.resolvePlayerUUID(playerName);
        if (playerUUID == null) {
            PresetCommand.sendError(ctx, "Player '" + playerName + "' not found or never joined this server.");
            return 0;
        }
        String uuidString = playerUUID.toString();
        PlayerPreset existing = PlayerPresetManager.getPreset(uuidString);
        if (existing != null) {
            PresetCommand.sendError(ctx, "Preset for player '" + playerName + "' already exists. Use remove first to overwrite.");
            return 0;
        }
        PlayerPreset preset = new PlayerPreset(uuidString, playerName, scale);
        PlayerPresetManager.addOrUpdatePreset(preset);
        PresetCommand.sendSuccess(ctx, String.format("Added preset for '%s' with scale %.2f", playerName, Float.valueOf(scale)));
        return 1;
    }

    private static int executeRemove(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        UUID playerUUID = PresetCommand.resolvePlayerUUID(playerName);
        if (playerUUID == null) {
            PresetCommand.sendError(ctx, "Player '" + playerName + "' not found.");
            return 0;
        }
        String uuidString = playerUUID.toString();
        boolean removed = PlayerPresetManager.removePreset(uuidString);
        if (removed) {
            PresetCommand.sendSuccess(ctx, "Removed preset for '" + playerName + "'.");
            return 1;
        }
        PresetCommand.sendError(ctx, "No preset found for '" + playerName + "'.");
        return 0;
    }

    private static int executeList(CommandContext<FabricClientCommandSource> ctx) {
        List<PlayerPreset> presets = PlayerPresetManager.getAllPresets();
        if (presets.isEmpty()) {
            PresetCommand.sendInfo(ctx, "No presets found.");
            return 1;
        }
        PresetCommand.sendInfo(ctx, "Player Scaling Presets:");
        for (PlayerPreset preset : presets) {
            String status = preset.enabled ? "\u00a7a\u2713" : "\u00a7c\u2717";
            String name = preset.getEffectiveDisplayName();
            String scaleColor = PresetCommand.getScaleColor(preset.scale);
            PresetCommand.sendInfo(ctx, String.format("  %s \u00a7f%s\u00a7r: %s%.2f\u00a7r", status, name, scaleColor, Float.valueOf(preset.scale)));
        }
        return 1;
    }

    private static int executeEnable(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        UUID playerUUID = PresetCommand.resolvePlayerUUID(playerName);
        if (playerUUID == null) {
            PresetCommand.sendError(ctx, "Player '" + playerName + "' not found.");
            return 0;
        }
        String uuidString = playerUUID.toString();
        boolean success = PlayerPresetManager.setPresetEnabled(uuidString, true);
        if (success) {
            PresetCommand.sendSuccess(ctx, "Enabled preset for '" + playerName + "'.");
            return 1;
        }
        PresetCommand.sendError(ctx, "No preset found for '" + playerName + "'.");
        return 0;
    }

    private static int executeDisable(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        UUID playerUUID = PresetCommand.resolvePlayerUUID(playerName);
        if (playerUUID == null) {
            PresetCommand.sendError(ctx, "Player '" + playerName + "' not found.");
            return 0;
        }
        String uuidString = playerUUID.toString();
        boolean success = PlayerPresetManager.setPresetEnabled(uuidString, false);
        if (success) {
            PresetCommand.sendSuccess(ctx, "Disabled preset for '" + playerName + "'.");
            return 1;
        }
        PresetCommand.sendError(ctx, "No preset found for '" + playerName + "'.");
        return 0;
    }

    private static int executeReload(CommandContext<FabricClientCommandSource> ctx) {
        PlayerPresetManager.loadPresets();
        PresetCommand.sendSuccess(ctx, "Reloaded all presets from disk.");
        return 1;
    }

    private static int executeInfo(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        UUID playerUUID = PresetCommand.resolvePlayerUUID(playerName);
        if (playerUUID == null) {
            PresetCommand.sendError(ctx, "Player '" + playerName + "' not found.");
            return 0;
        }
        String uuidString = playerUUID.toString();
        PlayerPreset preset = PlayerPresetManager.getPreset(uuidString);
        if (preset == null) {
            PresetCommand.sendError(ctx, "No preset found for '" + playerName + "'.");
            return 0;
        }
        PresetCommand.sendInfo(ctx, "Preset Information for '" + playerName + "':");
        PresetCommand.sendInfo(ctx, "  UUID: " + preset.identifier);
        PresetCommand.sendInfo(ctx, "  Display Name: " + preset.getEffectiveDisplayName());
        PresetCommand.sendInfo(ctx, "  Scale: " + preset.scale);
        PresetCommand.sendInfo(ctx, "  Status: " + (preset.enabled ? "\u00a7aEnabled\u00a7r" : "\u00a7cDisabled\u00a7r"));
        return 1;
    }

    private static int executeSetDefault(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        float scale = FloatArgumentType.getFloat(ctx, (String)"scale");
        if (!ScaleConstants.isValidScale(scale)) {
            PresetCommand.sendError(ctx, String.format("Scale must be between %.1f and %.1f", Float.valueOf(0.1f), Float.valueOf(3.0f)));
            return 0;
        }
        ScaleMeConfig.otherPlayersScale = ScaleConstants.clampScale(scale);
        PresetCommand.sendSuccess(ctx, String.format("Set default scale for other players to %.2f", Float.valueOf(scale)));
        return 1;
    }

    private static int executeSetOwn(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        float scale = FloatArgumentType.getFloat(ctx, (String)"scale");
        if (!ScaleConstants.isValidScale(scale)) {
            PresetCommand.sendError(ctx, String.format("Scale must be between %.1f and %.1f", Float.valueOf(0.1f), Float.valueOf(3.0f)));
            return 0;
        }
        ScaleMeConfig.ownPlayerScale = ScaleConstants.clampScale(scale);
        PresetCommand.sendSuccess(ctx, String.format("Set your own player scale to %.2f", Float.valueOf(scale)));
        return 1;
    }

    private static int executeOpenConfig(CommandContext<FabricClientCommandSource> ctx) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            PresetCommand.sendError(ctx, "You must be in-game to open the config menu.");
            return 0;
        }
        client.method_63588(() -> {
            try {
                client.method_1507(MidnightConfig.getScreen((class_437)client.field_1755, (String)"scaleme"));
            }
            catch (Exception e) {
                Scaleme.LOGGER.error("Failed to open config menu", (Throwable)e);
            }
        });
        PresetCommand.sendSuccess(ctx, "Opening configuration menu...");
        return 1;
    }

    private static int executeOpenManager(CommandContext<FabricClientCommandSource> ctx) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            PresetCommand.sendError(ctx, "You must be in-game to open the preset manager.");
            return 0;
        }
        client.method_63588(() -> {
            try {
                client.method_1507((class_437)new ScaleMeManagerScreen());
            }
            catch (Exception e) {
                Scaleme.LOGGER.error("Failed to open preset manager", (Throwable)e);
            }
        });
        PresetCommand.sendSuccess(ctx, "Opening preset manager...");
        return 1;
    }

    private static UUID resolvePlayerUUID(String playerName) {
        return PlayerUUIDResolver.resolvePlayerUUID(playerName);
    }

    private static String getScaleColor(float scale) {
        if (ScaleConstants.isTinyScale(scale)) {
            return "\u00a79";
        }
        if (ScaleConstants.isLargeScale(scale)) {
            return "\u00a7c";
        }
        return "\u00a7a";
    }

    private static void sendSuccess(CommandContext<FabricClientCommandSource> ctx, String message) {
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7a[ScaleMe] " + message)));
    }

    private static void sendError(CommandContext<FabricClientCommandSource> ctx, String message) {
        ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)("\u00a7c[ScaleMe] " + message)));
    }

    private static void sendInfo(CommandContext<FabricClientCommandSource> ctx, String message) {
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7b[ScaleMe] " + message)));
    }
}

