/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.scaleme.client.gui.components;

import com.github.kd_gaming1.scaleme.client.data.PlayerPreset;
import com.github.kd_gaming1.scaleme.client.util.PlayerPresetManager;
import com.github.kd_gaming1.scaleme.client.util.PlayerUUIDResolver;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.SlimSliderComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class PresetEditorComponent
extends FlowLayout {
    private static final float MIN_SCALE = 0.1f;
    private static final float MAX_SCALE = 3.0f;
    private PlayerPreset currentPreset;
    private Consumer<PlayerPreset> onPresetUpdated;
    private Consumer<PlayerPreset> onPresetDeleted;
    private boolean isNewPreset = false;
    private TextBoxComponent identifierField;
    private TextBoxComponent friendlyNameField;
    private SlimSliderComponent scaleSlider;
    private LabelComponent scaleValueLabel;
    private ButtonComponent saveButton;
    private ButtonComponent deleteButton;
    private ButtonComponent enableToggleButton;
    private ButtonComponent cancelButton;
    private LabelComponent titleLabel;
    private LabelComponent statusLabel;
    private LabelComponent identifierInfoLabel;
    private FlowLayout emptyStateContainer;
    private ScrollContainer<FlowLayout> editorContainer;
    private FlowLayout helpContainer;
    private boolean isShowingEmptyState = true;
    private boolean isIdentifierValid = true;
    private boolean hasUnsavedChanges = false;
    private String originalIdentifier = null;

    public PresetEditorComponent(Consumer<PlayerPreset> onPresetUpdated, Consumer<PlayerPreset> onPresetDeleted) {
        super(Sizing.fill((int)100), Sizing.fill((int)100), FlowLayout.Algorithm.VERTICAL);
        this.onPresetUpdated = onPresetUpdated;
        this.onPresetDeleted = onPresetDeleted;
        this.surface(Surface.flat((int)0x33424242)).padding(Insets.of((int)8));
        this.buildLayout();
        this.showEmptyState();
    }

    private void buildLayout() {
        this.titleLabel = Components.label((class_2561)class_2561.method_43470((String)"Select a Preset")).color(Color.WHITE).shadow(true).horizontalTextAlignment(HorizontalAlignment.CENTER);
        this.child((Component)this.titleLabel);
        this.statusLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43473()).color(Color.ofRgb((int)0xCCCCCC)).horizontalTextAlignment(HorizontalAlignment.CENTER).margins(Insets.bottom((int)8));
        this.child((Component)this.statusLabel);
        this.buildEmptyState();
        this.buildEditorContainer();
    }

    private void buildEmptyState() {
        this.emptyStateContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).gap(12).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        this.emptyStateContainer.child(Components.label((class_2561)class_2561.method_43470((String)"\ud83d\udccb")).color(Color.ofRgb((int)0x888888)).horizontalTextAlignment(HorizontalAlignment.CENTER).sizing(Sizing.content(), Sizing.content()));
        this.emptyStateContainer.child(Components.label((class_2561)class_2561.method_43470((String)"Select a preset to edit")).color(Color.ofRgb((int)0xCCCCCC)).horizontalTextAlignment(HorizontalAlignment.CENTER).sizing(Sizing.content(), Sizing.content()));
        this.emptyStateContainer.child(Components.label((class_2561)class_2561.method_43470((String)"or create a new one")).color(Color.ofRgb((int)0x888888)).horizontalTextAlignment(HorizontalAlignment.CENTER).sizing(Sizing.content(), Sizing.content()));
        this.child((Component)this.emptyStateContainer);
    }

    private void buildEditorContainer() {
        FlowLayout mainContent = Containers.verticalFlow((Sizing)Sizing.fill((int)95), (Sizing)Sizing.content()).gap(8);
        this.buildHelpContainer();
        FlowLayout formContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8);
        formContainer.child((Component)this.createFieldSection("Player Identifier: *", "Username (will be resolved automatically)", "Enter the exact username of the player you want to scale", identifier -> {
            this.identifierField = identifier;
            identifier.onChanged().subscribe(this::onIdentifierChanged);
        }));
        formContainer.child((Component)this.createFieldSection("Display Name:", "Custom name (optional)", "Leave empty to use the player identifier as display name", friendlyName -> {
            this.friendlyNameField = friendlyName;
            friendlyName.onChanged().subscribe(this::onFriendlyNameChanged);
        }));
        formContainer.child((Component)this.createScaleSliderSection());
        this.identifierInfoLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43473()).color(Color.ofRgb((int)0x888888)).shadow(false).sizing(Sizing.fill((int)100), Sizing.content());
        formContainer.child((Component)this.identifierInfoLabel);
        mainContent.child((Component)formContainer);
        this.buildButtonSection(mainContent);
        this.editorContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)mainContent);
    }

    private FlowLayout createScaleSliderSection() {
        FlowLayout section = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).surface(Surface.flat((int)0x22000000)).padding(Insets.of((int)8));
        FlowLayout labelRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).verticalAlignment(VerticalAlignment.CENTER);
        labelRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Scale: *")).color(Color.ofRgb((int)16755601)).shadow(false));
        this.scaleValueLabel = Components.label((class_2561)class_2561.method_43470((String)"1.00")).color(Color.ofRgb((int)5025616)).shadow(false);
        labelRow.child((Component)this.scaleValueLabel);
        section.child((Component)labelRow);
        this.scaleSlider = Components.slimSlider((SlimSliderComponent.Axis)SlimSliderComponent.Axis.HORIZONTAL);
        this.scaleSlider.sizing(Sizing.fill((int)100), Sizing.content());
        this.scaleSlider.min(0.0);
        this.scaleSlider.max(1.0);
        this.scaleSlider.stepSize(0.01);
        this.scaleSlider.tooltipSupplier(value -> class_2561.method_43470((String)String.format("%.2f", Float.valueOf(this.mapSliderToScale((double)value)))));
        this.scaleSlider.onChanged().subscribe(this::onScaleSliderChanged);
        section.child((Component)this.scaleSlider);
        FlowLayout indicatorRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.top((int)4));
        indicatorRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Size multiplier for the player:")).color(Color.ofRgb((int)0x888888)));
        indicatorRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Tiny")).color(Color.ofRgb((int)0x888888)));
        indicatorRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)"(0.1)")).color(Color.ofRgb((int)0x666666)));
        indicatorRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Normal")).color(Color.ofRgb((int)5025616)));
        indicatorRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)"(1.0)")).color(Color.ofRgb((int)5025616)));
        indicatorRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Large")).color(Color.ofRgb((int)16733986)));
        indicatorRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)"(3.0)")).color(Color.ofRgb((int)16733986)));
        section.child((Component)indicatorRow);
        return section;
    }

    private double mapScaleToSlider(float scale) {
        return (scale - 0.1f) / 2.9f;
    }

    private float mapSliderToScale(double sliderValue) {
        float scale = (float)((double)0.1f + sliderValue * (double)2.9f);
        return (float)Math.round(scale * 100.0f) / 100.0f;
    }

    private void buildHelpContainer() {
        this.helpContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).surface(Surface.flat((int)570442888)).padding(Insets.of((int)8)).margins(Insets.bottom((int)8));
        FlowLayout headerRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6).verticalAlignment(VerticalAlignment.CENTER);
        headerRow.child(Components.label((class_2561)class_2561.method_43470((String)"\u2139")).color(Color.ofRgb((int)6600182)).sizing(Sizing.content(), Sizing.content()));
        headerRow.child(Components.label((class_2561)class_2561.method_43470((String)"Creating New Preset")).color(Color.ofRgb((int)6600182)).shadow(false).sizing(Sizing.content(), Sizing.content()));
        this.helpContainer.child((Component)headerRow);
        this.helpContainer.child(Components.label((class_2561)class_2561.method_43470((String)"\u2022 Enter a username (will be resolved to UUID automatically)")).color(Color.ofRgb((int)14938877)).shadow(false).sizing(Sizing.content(), Sizing.content()));
        this.helpContainer.child(Components.label((class_2561)class_2561.method_43470((String)"\u2022 Friendly name will auto-fill if left empty")).color(Color.ofRgb((int)14938877)).shadow(false).sizing(Sizing.content(), Sizing.content()));
        this.helpContainer.child(Components.label((class_2561)class_2561.method_43470((String)"\u2022 Use the slider to set the desired scale")).color(Color.ofRgb((int)14938877)).shadow(false).sizing(Sizing.content(), Sizing.content()));
    }

    private void buildButtonSection(FlowLayout contentContainer) {
        FlowLayout buttonSection = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).surface(Surface.flat((int)0x22000000)).padding(Insets.of((int)8));
        FlowLayout buttonRow = Containers.ltrTextFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6);
        this.saveButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Save"), button -> this.saveCurrentPreset()).horizontalSizing(Sizing.fixed((int)120));
        buttonRow.child((Component)this.saveButton);
        this.cancelButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Cancel"), button -> this.cancelEditing()).horizontalSizing(Sizing.fixed((int)80));
        buttonRow.child((Component)this.cancelButton);
        this.enableToggleButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Enable"), button -> this.togglePresetEnabled()).horizontalSizing(Sizing.fixed((int)80));
        buttonRow.child((Component)this.enableToggleButton);
        this.deleteButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Delete"), button -> this.deleteCurrentPreset()).horizontalSizing(Sizing.fixed((int)80));
        buttonRow.child((Component)this.deleteButton);
        buttonSection.child((Component)buttonRow);
        contentContainer.child((Component)buttonSection);
    }

    private FlowLayout createFieldSection(String labelText, String placeholder, String helpText, Consumer<TextBoxComponent> fieldConsumer) {
        FlowLayout section = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).surface(Surface.flat((int)0x22000000)).padding(Insets.of((int)8));
        FlowLayout labelRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).verticalAlignment(VerticalAlignment.CENTER);
        labelRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)labelText)).color(labelText.contains("*") ? Color.ofRgb((int)16755601) : Color.WHITE).shadow(false));
        section.child((Component)labelRow);
        TextBoxComponent textField = Components.textBox((Sizing)Sizing.fill((int)100));
        if (placeholder != null && !placeholder.isEmpty()) {
            textField.method_1887(placeholder);
            textField.onChanged().subscribe(text -> textField.method_1887(text.isEmpty() ? placeholder : ""));
        }
        fieldConsumer.accept(textField);
        section.child((Component)textField);
        if (helpText != null && !helpText.isEmpty()) {
            section.child(Components.label((class_2561)class_2561.method_43470((String)helpText)).color(Color.ofRgb((int)0x888888)).shadow(false).sizing(Sizing.fill((int)100), Sizing.content()));
        }
        return section;
    }

    public void editPreset(PlayerPreset preset) {
        if (preset == null) {
            this.showEmptyState();
            return;
        }
        this.currentPreset = preset.copy();
        this.hasUnsavedChanges = false;
        this.isNewPreset = false;
        this.originalIdentifier = preset.identifier;
        if (this.identifierField != null) {
            this.identifierField.field_22763 = false;
            this.identifierField.method_1888(false);
        }
        this.populateFields(this.currentPreset);
        this.updateButtonStates();
        this.updateTitle();
        this.updateStatusLabel();
        this.showEditorState();
    }

    public void createNewPreset() {
        PlayerPreset newPreset = new PlayerPreset("", "", 1.0f);
        newPreset.enabled = true;
        this.isNewPreset = true;
        this.currentPreset = newPreset;
        this.hasUnsavedChanges = false;
        this.originalIdentifier = null;
        if (this.identifierField != null) {
            this.identifierField.field_22763 = true;
            this.identifierField.method_1888(true);
            this.identifierField.method_1868(-1);
        }
        this.populateFields(newPreset);
        this.updateButtonStates();
        this.updateTitle();
        this.updateStatusLabel();
        this.showEditorState();
    }

    private void cancelEditing() {
        this.currentPreset = null;
        this.isNewPreset = false;
        this.hasUnsavedChanges = false;
        this.originalIdentifier = null;
        this.showEmptyState();
    }

    private void updateTitle() {
        if (this.currentPreset == null) {
            this.titleLabel.text((class_2561)class_2561.method_43470((String)"Select a Preset"));
        } else if (this.isNewPreset) {
            this.titleLabel.text((class_2561)class_2561.method_43470((String)"Creating New Preset").method_27692(class_124.field_1060));
        } else {
            this.titleLabel.text((class_2561)class_2561.method_43470((String)("Editing: " + this.currentPreset.getEffectiveDisplayName())));
        }
    }

    private void updateStatusLabel() {
        if (this.currentPreset == null) {
            this.statusLabel.text((class_2561)class_2561.method_43473());
        } else if (this.isNewPreset) {
            this.statusLabel.text((class_2561)class_2561.method_43470((String)"Fill in the required fields to create a new preset").method_27692(class_124.field_1054));
        } else {
            String status = this.currentPreset.enabled ? "Active" : "Disabled";
            this.statusLabel.text((class_2561)class_2561.method_43470((String)("Status: " + status)));
        }
    }

    private void populateFields(PlayerPreset preset) {
        this.identifierField.text(preset.identifier != null ? preset.identifier : "");
        this.friendlyNameField.text(preset.friendlyName != null ? preset.friendlyName : "");
        double sliderValue = this.mapScaleToSlider(preset.scale);
        this.scaleSlider.value(sliderValue);
        this.updateScaleValueLabel(preset.scale);
        this.validateIdentifierFormat(preset.identifier);
    }

    private void showEmptyState() {
        if (!this.isShowingEmptyState) {
            this.removeChild((Component)this.editorContainer);
            this.child((Component)this.emptyStateContainer);
            this.isShowingEmptyState = true;
        }
        this.updateTitle();
        this.updateStatusLabel();
    }

    private void showEditorState() {
        if (this.isShowingEmptyState) {
            this.removeChild((Component)this.emptyStateContainer);
            this.child((Component)this.editorContainer);
            this.isShowingEmptyState = false;
        }
        FlowLayout mainContent = (FlowLayout)this.editorContainer.child();
        if (this.isNewPreset && !mainContent.children().contains(this.helpContainer)) {
            mainContent.child(0, (Component)this.helpContainer);
        } else if (!this.isNewPreset && mainContent.children().contains(this.helpContainer)) {
            mainContent.removeChild((Component)this.helpContainer);
        }
        if (this.identifierField != null) {
            this.identifierField.field_22763 = true;
            if (this.isNewPreset) {
                this.identifierField.method_1868(-1);
            }
        }
        if (this.friendlyNameField != null) {
            this.friendlyNameField.field_22763 = true;
        }
        if (this.isNewPreset) {
            this.identifierInfoLabel.text((class_2561)class_2561.method_43470((String)"Enter a username (player must be online for UUID resolution).").method_27692(class_124.field_1054));
        } else {
            this.identifierInfoLabel.text((class_2561)class_2561.method_43470((String)"Identifier is read-only when editing a preset.").method_27692(class_124.field_1080));
        }
    }

    private void validateField(TextBoxComponent field, boolean isValid, int validColor, int invalidColor) {
        if (field != null) {
            field.method_1868(isValid ? validColor : invalidColor);
        }
    }

    private void validateIdentifierFormat(String identifier) {
        if (identifier == null || identifier.trim().isEmpty()) {
            this.isIdentifierValid = false;
            if (this.isNewPreset) {
                this.validateField(this.identifierField, false, -1, -1368778);
                this.statusLabel.text((class_2561)class_2561.method_43470((String)"Player identifier is required").method_27692(class_124.field_1061));
            }
            return;
        }
        String trimmed = identifier.trim();
        boolean isUUIDFormat = this.isValidUUID(trimmed);
        boolean isUsernameFormat = trimmed.matches("^[a-zA-Z0-9_]{3,16}$");
        if (this.isNewPreset) {
            this.isIdentifierValid = isUsernameFormat;
            this.statusLabel.text((class_2561)class_2561.method_43470((String)(isUsernameFormat ? "Username format - will resolve when saved" : "Only usernames (3-16 chars) are allowed when creating a new preset.")).method_27692(isUsernameFormat ? class_124.field_1054 : class_124.field_1061));
            this.validateField(this.identifierField, this.isIdentifierValid, -1, -1368778);
        } else {
            this.isIdentifierValid = isUUIDFormat || isUsernameFormat;
            this.statusLabel.text((class_2561)class_2561.method_43470((String)(isUUIDFormat ? "Valid UUID format" : "Username format")).method_27692(class_124.field_1060));
        }
    }

    private boolean isValidUUID(String input) {
        try {
            UUID.fromString(input);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private void updateScaleValueLabel(float scale) {
        String scaleText = String.format("%.2f", Float.valueOf(scale));
        Color scaleColor = scale < 0.8f ? Color.ofRgb((int)8508666) : (scale > 1.5f ? Color.ofRgb((int)16755601) : Color.ofRgb((int)10868391));
        this.scaleValueLabel.text((class_2561)class_2561.method_43470((String)scaleText)).color(scaleColor);
    }

    private void onIdentifierChanged(String newValue) {
        if (!this.isNewPreset) {
            return;
        }
        this.validateIdentifierFormat(newValue);
        this.hasUnsavedChanges = true;
        this.updateButtonStates();
    }

    private void onFriendlyNameChanged(String newValue) {
        if (this.currentPreset == null) {
            return;
        }
        if (!newValue.equals(this.currentPreset.friendlyName)) {
            this.hasUnsavedChanges = true;
            this.currentPreset.friendlyName = newValue.isEmpty() ? null : newValue;
        }
        this.updateButtonStates();
    }

    private void onScaleSliderChanged(double sliderValue) {
        if (this.currentPreset == null) {
            return;
        }
        float newScale = this.mapSliderToScale(sliderValue);
        if (Math.abs(newScale - this.currentPreset.scale) > 0.001f) {
            this.hasUnsavedChanges = true;
            this.currentPreset.scale = newScale;
            this.updateScaleValueLabel(newScale);
        }
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        boolean canSave;
        boolean hasValidPreset = this.currentPreset != null;
        this.saveButton.field_22763 = canSave = hasValidPreset && this.isIdentifierValid && !this.identifierField.method_1882().trim().isEmpty();
        this.cancelButton.field_22763 = true;
        this.enableToggleButton.field_22763 = !this.isNewPreset && hasValidPreset;
        boolean bl = this.deleteButton.field_22763 = !this.isNewPreset && hasValidPreset;
        if (!this.isNewPreset && hasValidPreset) {
            this.enableToggleButton.method_25355((class_2561)class_2561.method_43470((String)(this.currentPreset.enabled ? "Disable" : "Enable")));
        }
        if (this.isNewPreset) {
            this.saveButton.method_25355((class_2561)class_2561.method_43470((String)"Create Preset"));
        } else if (this.hasUnsavedChanges) {
            this.saveButton.method_25355((class_2561)class_2561.method_43470((String)"Save Changes"));
        } else {
            this.saveButton.method_25355((class_2561)class_2561.method_43470((String)"Save"));
        }
    }

    private void saveCurrentPreset() {
        if (this.currentPreset == null || !this.isIdentifierValid) {
            return;
        }
        if (this.isNewPreset) {
            String inputIdentifier = this.identifierField.method_1882().trim();
            UUID resolvedUUID = PlayerUUIDResolver.resolvePlayerUUID(inputIdentifier);
            if (resolvedUUID == null) {
                this.showErrorMessage("Failed to resolve player: " + inputIdentifier + ". Please check the username.");
                return;
            }
            this.currentPreset.identifier = resolvedUUID.toString();
            if (this.currentPreset.friendlyName == null || this.currentPreset.friendlyName.trim().isEmpty()) {
                this.currentPreset.friendlyName = inputIdentifier;
                this.friendlyNameField.text(inputIdentifier);
            }
        }
        PlayerPresetManager.addOrUpdatePreset(this.currentPreset);
        if (this.isNewPreset) {
            this.isNewPreset = false;
            this.identifierField.field_22763 = false;
            this.identifierField.method_1888(false);
            this.identifierField.text(this.currentPreset.identifier);
        }
        this.hasUnsavedChanges = false;
        this.originalIdentifier = this.currentPreset.identifier;
        this.updateButtonStates();
        this.updateTitle();
        this.updateStatusLabel();
        this.showEditorState();
        if (this.onPresetUpdated != null) {
            this.onPresetUpdated.accept(this.currentPreset);
        }
        this.showSuccessMessage("Preset saved successfully!");
    }

    private void togglePresetEnabled() {
        if (this.currentPreset == null || this.isNewPreset) {
            return;
        }
        this.currentPreset.enabled = !this.currentPreset.enabled;
        PlayerPresetManager.setPresetEnabled(this.currentPreset.identifier, this.currentPreset.enabled);
        this.updateButtonStates();
        this.updateStatusLabel();
        if (this.onPresetUpdated != null) {
            this.onPresetUpdated.accept(this.currentPreset);
        }
        this.showSuccessMessage("Preset " + (this.currentPreset.enabled ? "enabled" : "disabled") + "!");
    }

    private void deleteCurrentPreset() {
        if (this.currentPreset == null || this.isNewPreset) {
            return;
        }
        String presetName = this.currentPreset.getEffectiveDisplayName();
        this.showConfirmationDialog("Delete Preset", "Are you sure you want to delete the preset '" + presetName + "'?\nThis action cannot be undone.", () -> {
            PlayerPresetManager.removePreset(this.currentPreset.identifier);
            if (this.onPresetDeleted != null) {
                this.onPresetDeleted.accept(this.currentPreset);
            }
            this.currentPreset = null;
            this.showEmptyState();
            this.showSuccessMessage("Preset deleted!");
        }, null);
    }

    private void showConfirmationDialog(String title, String message, Runnable onConfirm, Runnable onCancel) {
        FlowLayout overlay = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100)).surface(Surface.flat((int)-2013265920)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout dialog = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fixed((int)320), (Sizing)Sizing.content()).surface(Surface.flat((int)-12434878).and(Surface.outline((int)-10066330))).padding(Insets.of((int)16)).horizontalAlignment(HorizontalAlignment.CENTER);
        dialog.child((Component)Components.label((class_2561)class_2561.method_43470((String)title)).color(Color.WHITE).shadow(true).horizontalTextAlignment(HorizontalAlignment.CENTER).margins(Insets.bottom((int)4)));
        String[] messageLines = message.split("\n");
        FlowLayout messageContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(2).horizontalAlignment(HorizontalAlignment.CENTER);
        for (String line : messageLines) {
            messageContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)line)).color(Color.ofRgb((int)0xCCCCCC)).horizontalTextAlignment(HorizontalAlignment.CENTER));
        }
        dialog.child((Component)messageContainer);
        FlowLayout buttonRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.top((int)8));
        buttonRow.child(Components.button((class_2561)class_2561.method_43470((String)"Cancel"), button -> {
            this.removeChild((Component)overlay);
            if (onCancel != null) {
                onCancel.run();
            }
        }).horizontalSizing(Sizing.fixed((int)80)));
        buttonRow.child(Components.button((class_2561)class_2561.method_43470((String)"Confirm"), button -> {
            this.removeChild((Component)overlay);
            if (onConfirm != null) {
                onConfirm.run();
            }
        }).horizontalSizing(Sizing.fixed((int)80)));
        dialog.child((Component)buttonRow);
        overlay.child((Component)dialog);
        this.child((Component)overlay);
    }

    private void showErrorMessage(String message) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c" + message)), false);
        }
        this.statusLabel.text((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1061));
    }

    private void showSuccessMessage(String message) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a" + message)), false);
        }
    }
}

