/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.scaleme.client.util;

public final class ScaleConstants {
    public static final float MIN_SCALE = 0.1f;
    public static final float MAX_SCALE = 3.0f;
    public static final float DEFAULT_SCALE = 1.0f;
    public static final float SMALL_SCALE_THRESHOLD = 0.8f;
    public static final float LARGE_SCALE_THRESHOLD = 1.5f;
    public static final int DEFAULT_SWING_DURATION = 6;
    public static final int MIN_SWING_DURATION = 1;
    public static final int MAX_SWING_DURATION = 60;
    public static final float SWING_BOBBING_DISABLED_VALUE = 1.0f;
    public static final int PLAYER_HEAD_SIZE = 24;
    public static final int PLAYER_HEAD_CONTAINER_PADDING = 4;
    public static final int SCALE_BAR_WIDTH = 40;
    public static final int SCALE_BAR_HEIGHT = 3;
    public static final String UUID_REGEX = "^[0-9a-fA-F\\-]{36}$";
    public static final String USERNAME_REGEX = "^[a-zA-Z0-9_]{3,16}$";
    public static final String ERROR_INVALID_SCALE = "Scale must be between %.2f and %.2f";
    public static final String ERROR_NULL_IDENTIFIER = "Identifier cannot be null or empty";
    public static final String ERROR_INVALID_USERNAME = "Username must be 3-16 characters (alphanumeric and underscores only)";

    private ScaleConstants() {
        throw new AssertionError((Object)"Constants class should not be instantiated");
    }

    public static boolean isValidScale(float scale) {
        return scale >= 0.1f && scale <= 3.0f && !Float.isNaN(scale) && !Float.isInfinite(scale);
    }

    public static float clampScale(float scale) {
        if (Float.isNaN(scale) || Float.isInfinite(scale)) {
            return 1.0f;
        }
        return Math.max(0.1f, Math.min(3.0f, scale));
    }

    public static boolean isTinyScale(float scale) {
        return scale < 0.8f;
    }

    public static boolean isLargeScale(float scale) {
        return scale > 1.5f;
    }

    public static boolean isDefaultScale(float scale) {
        return Math.abs(scale - 1.0f) < 0.001f;
    }
}

