/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.epbop.datagen.recipe;

import biomesoplenty.api.item.BOPItems;
import biomesoplenty.init.ModTags;
import me.jddev0.ep.recipe.CrusherRecipe;
import me.jddev0.ep.recipe.CrystalGrowthChamberRecipe;
import me.jddev0.ep.recipe.IngredientWithCount;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import me.jddev0.ep.recipe.PlantGrowthChamberRecipe;
import me.jddev0.ep.recipe.SawmillRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NeoForgeConditions;

public class ModRecipeGenerator
extends RecipeProvider {
    private static final String BIOMES_O_PLENTY_MOD_ID = "biomesoplenty";
    private static final String PATH_PREFIX = "compat/biomesoplenty/";

    public ModRecipeGenerator(HolderLookup.Provider registries, RecipeOutput recipeOutput) {
        super(registries, recipeOutput);
    }

    protected void buildRecipes() {
        this.buildCrusherRecipes(this.output);
        this.buildSawmillRecipes(this.output);
        this.buildPlantGrowthChamberRecipes(this.output);
        this.buildCrystalGrowthChamberRecipes(this.output);
    }

    private void buildCrusherRecipes(RecipeOutput output) {
        this.addCrusherRecipe(output, this.ingredientOf((ItemLike)BOPItems.WHITE_SANDSTONE), new ItemStack((ItemLike)BOPItems.WHITE_SAND), "white_sandstone");
        this.addCrusherRecipe(output, this.ingredientOf(new ItemLike[]{BOPItems.SMOOTH_WHITE_SANDSTONE, BOPItems.CUT_WHITE_SANDSTONE, BOPItems.CHISELED_WHITE_SANDSTONE}), new ItemStack((ItemLike)BOPItems.WHITE_SAND), "white_sandstone_variants");
        this.addCrusherRecipe(output, this.ingredientOf((ItemLike)BOPItems.ORANGE_SANDSTONE), new ItemStack((ItemLike)BOPItems.ORANGE_SAND), "orange_sandstone");
        this.addCrusherRecipe(output, this.ingredientOf(new ItemLike[]{BOPItems.SMOOTH_ORANGE_SANDSTONE, BOPItems.CUT_ORANGE_SANDSTONE, BOPItems.CHISELED_ORANGE_SANDSTONE}), new ItemStack((ItemLike)BOPItems.ORANGE_SAND), "orange_sandstone_variants");
        this.addCrusherRecipe(output, this.ingredientOf((ItemLike)BOPItems.BLACK_SANDSTONE), new ItemStack((ItemLike)BOPItems.BLACK_SAND), "black_sandstone");
        this.addCrusherRecipe(output, this.ingredientOf(new ItemLike[]{BOPItems.SMOOTH_BLACK_SANDSTONE, BOPItems.CUT_BLACK_SANDSTONE, BOPItems.CHISELED_BLACK_SANDSTONE}), new ItemStack((ItemLike)BOPItems.BLACK_SAND), "black_sandstone_variants");
        this.addCrusherRecipe(output, this.ingredientOf(new ItemLike[]{BOPItems.BRIMSTONE_BRICKS, BOPItems.CHISELED_BRIMSTONE_BRICKS}), new ItemStack((ItemLike)BOPItems.BRIMSTONE), "brimstone_variants");
    }

    private void buildSawmillRecipes(RecipeOutput output) {
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)BOPItems.ORIGIN_OAK_PLANKS), this.ingredientOf((TagKey<Item>)ModTags.Items.ORIGIN_OAK_LOGS), this.ingredientOf((ItemLike)BOPItems.ORIGIN_OAK_FENCE), this.ingredientOf((ItemLike)BOPItems.ORIGIN_OAK_FENCE_GATE), this.ingredientOf((ItemLike)BOPItems.ORIGIN_OAK_DOOR), this.ingredientOf((ItemLike)BOPItems.ORIGIN_OAK_TRAPDOOR), this.ingredientOf((ItemLike)BOPItems.ORIGIN_OAK_PRESSURE_PLATE), this.ingredientOf((ItemLike)BOPItems.ORIGIN_OAK_SIGN), this.ingredientOf((ItemLike)BOPItems.ORIGIN_OAK_SHELF), this.ingredientOf((ItemLike)BOPItems.ORIGIN_OAK_BOAT), this.ingredientOf((ItemLike)BOPItems.ORIGIN_OAK_CHEST_BOAT), false, "origin_oak");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)BOPItems.FIR_PLANKS), this.ingredientOf((TagKey<Item>)ModTags.Items.FIR_LOGS), this.ingredientOf((ItemLike)BOPItems.FIR_FENCE), this.ingredientOf((ItemLike)BOPItems.FIR_FENCE_GATE), this.ingredientOf((ItemLike)BOPItems.FIR_DOOR), this.ingredientOf((ItemLike)BOPItems.FIR_TRAPDOOR), this.ingredientOf((ItemLike)BOPItems.FIR_PRESSURE_PLATE), this.ingredientOf((ItemLike)BOPItems.FIR_SIGN), this.ingredientOf((ItemLike)BOPItems.FIR_SHELF), this.ingredientOf((ItemLike)BOPItems.FIR_BOAT), this.ingredientOf((ItemLike)BOPItems.FIR_CHEST_BOAT), false, "fir");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)BOPItems.PINE_PLANKS), this.ingredientOf((TagKey<Item>)ModTags.Items.PINE_LOGS), this.ingredientOf((ItemLike)BOPItems.PINE_FENCE), this.ingredientOf((ItemLike)BOPItems.PINE_FENCE_GATE), this.ingredientOf((ItemLike)BOPItems.PINE_DOOR), this.ingredientOf((ItemLike)BOPItems.PINE_TRAPDOOR), this.ingredientOf((ItemLike)BOPItems.PINE_PRESSURE_PLATE), this.ingredientOf((ItemLike)BOPItems.PINE_SIGN), this.ingredientOf((ItemLike)BOPItems.PINE_SHELF), this.ingredientOf((ItemLike)BOPItems.PINE_BOAT), this.ingredientOf((ItemLike)BOPItems.PINE_CHEST_BOAT), false, "pine");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)BOPItems.MAPLE_PLANKS), this.ingredientOf((TagKey<Item>)ModTags.Items.MAPLE_LOGS), this.ingredientOf((ItemLike)BOPItems.MAPLE_FENCE), this.ingredientOf((ItemLike)BOPItems.MAPLE_FENCE_GATE), this.ingredientOf((ItemLike)BOPItems.MAPLE_DOOR), this.ingredientOf((ItemLike)BOPItems.MAPLE_TRAPDOOR), this.ingredientOf((ItemLike)BOPItems.MAPLE_PRESSURE_PLATE), this.ingredientOf((ItemLike)BOPItems.MAPLE_SIGN), this.ingredientOf((ItemLike)BOPItems.MAPLE_SHELF), this.ingredientOf((ItemLike)BOPItems.MAPLE_BOAT), this.ingredientOf((ItemLike)BOPItems.MAPLE_CHEST_BOAT), false, "maple");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)BOPItems.REDWOOD_PLANKS), this.ingredientOf((TagKey<Item>)ModTags.Items.REDWOOD_LOGS), this.ingredientOf((ItemLike)BOPItems.REDWOOD_FENCE), this.ingredientOf((ItemLike)BOPItems.REDWOOD_FENCE_GATE), this.ingredientOf((ItemLike)BOPItems.REDWOOD_DOOR), this.ingredientOf((ItemLike)BOPItems.REDWOOD_TRAPDOOR), this.ingredientOf((ItemLike)BOPItems.REDWOOD_PRESSURE_PLATE), this.ingredientOf((ItemLike)BOPItems.REDWOOD_SIGN), this.ingredientOf((ItemLike)BOPItems.REDWOOD_SHELF), this.ingredientOf((ItemLike)BOPItems.REDWOOD_BOAT), this.ingredientOf((ItemLike)BOPItems.REDWOOD_CHEST_BOAT), false, "redwood");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)BOPItems.MAHOGANY_PLANKS), this.ingredientOf((TagKey<Item>)ModTags.Items.MAHOGANY_LOGS), this.ingredientOf((ItemLike)BOPItems.MAHOGANY_FENCE), this.ingredientOf((ItemLike)BOPItems.MAHOGANY_FENCE_GATE), this.ingredientOf((ItemLike)BOPItems.MAHOGANY_DOOR), this.ingredientOf((ItemLike)BOPItems.MAHOGANY_TRAPDOOR), this.ingredientOf((ItemLike)BOPItems.MAHOGANY_PRESSURE_PLATE), this.ingredientOf((ItemLike)BOPItems.MAHOGANY_SIGN), this.ingredientOf((ItemLike)BOPItems.MAHOGANY_SHELF), this.ingredientOf((ItemLike)BOPItems.MAHOGANY_BOAT), this.ingredientOf((ItemLike)BOPItems.MAHOGANY_CHEST_BOAT), false, "mahogany");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)BOPItems.JACARANDA_PLANKS), this.ingredientOf((TagKey<Item>)ModTags.Items.JACARANDA_LOGS), this.ingredientOf((ItemLike)BOPItems.JACARANDA_FENCE), this.ingredientOf((ItemLike)BOPItems.JACARANDA_FENCE_GATE), this.ingredientOf((ItemLike)BOPItems.JACARANDA_DOOR), this.ingredientOf((ItemLike)BOPItems.JACARANDA_TRAPDOOR), this.ingredientOf((ItemLike)BOPItems.JACARANDA_PRESSURE_PLATE), this.ingredientOf((ItemLike)BOPItems.JACARANDA_SIGN), this.ingredientOf((ItemLike)BOPItems.JACARANDA_SHELF), this.ingredientOf((ItemLike)BOPItems.JACARANDA_BOAT), this.ingredientOf((ItemLike)BOPItems.JACARANDA_CHEST_BOAT), false, "jacaranda");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)BOPItems.PALM_PLANKS), this.ingredientOf((TagKey<Item>)ModTags.Items.PALM_LOGS), this.ingredientOf((ItemLike)BOPItems.PALM_FENCE), this.ingredientOf((ItemLike)BOPItems.PALM_FENCE_GATE), this.ingredientOf((ItemLike)BOPItems.PALM_DOOR), this.ingredientOf((ItemLike)BOPItems.PALM_TRAPDOOR), this.ingredientOf((ItemLike)BOPItems.PALM_PRESSURE_PLATE), this.ingredientOf((ItemLike)BOPItems.PALM_SIGN), this.ingredientOf((ItemLike)BOPItems.PALM_SHELF), this.ingredientOf((ItemLike)BOPItems.PALM_BOAT), this.ingredientOf((ItemLike)BOPItems.PALM_CHEST_BOAT), false, "palm");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)BOPItems.WILLOW_PLANKS), this.ingredientOf((TagKey<Item>)ModTags.Items.WILLOW_LOGS), this.ingredientOf((ItemLike)BOPItems.WILLOW_FENCE), this.ingredientOf((ItemLike)BOPItems.WILLOW_FENCE_GATE), this.ingredientOf((ItemLike)BOPItems.WILLOW_DOOR), this.ingredientOf((ItemLike)BOPItems.WILLOW_TRAPDOOR), this.ingredientOf((ItemLike)BOPItems.WILLOW_PRESSURE_PLATE), this.ingredientOf((ItemLike)BOPItems.WILLOW_SIGN), this.ingredientOf((ItemLike)BOPItems.WILLOW_SHELF), this.ingredientOf((ItemLike)BOPItems.WILLOW_BOAT), this.ingredientOf((ItemLike)BOPItems.WILLOW_CHEST_BOAT), false, "willow");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)BOPItems.DEAD_PLANKS), this.ingredientOf((TagKey<Item>)ModTags.Items.DEAD_LOGS), this.ingredientOf((ItemLike)BOPItems.DEAD_FENCE), this.ingredientOf((ItemLike)BOPItems.DEAD_FENCE_GATE), this.ingredientOf((ItemLike)BOPItems.DEAD_DOOR), this.ingredientOf((ItemLike)BOPItems.DEAD_TRAPDOOR), this.ingredientOf((ItemLike)BOPItems.DEAD_PRESSURE_PLATE), this.ingredientOf((ItemLike)BOPItems.DEAD_SIGN), this.ingredientOf((ItemLike)BOPItems.DEAD_SHELF), this.ingredientOf((ItemLike)BOPItems.DEAD_BOAT), this.ingredientOf((ItemLike)BOPItems.DEAD_CHEST_BOAT), false, "dead");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)BOPItems.MAGIC_PLANKS), this.ingredientOf((TagKey<Item>)ModTags.Items.MAGIC_LOGS), this.ingredientOf((ItemLike)BOPItems.MAGIC_FENCE), this.ingredientOf((ItemLike)BOPItems.MAGIC_FENCE_GATE), this.ingredientOf((ItemLike)BOPItems.MAGIC_DOOR), this.ingredientOf((ItemLike)BOPItems.MAGIC_TRAPDOOR), this.ingredientOf((ItemLike)BOPItems.MAGIC_PRESSURE_PLATE), this.ingredientOf((ItemLike)BOPItems.MAGIC_SIGN), this.ingredientOf((ItemLike)BOPItems.MAGIC_SHELF), this.ingredientOf((ItemLike)BOPItems.MAGIC_BOAT), this.ingredientOf((ItemLike)BOPItems.MAGIC_CHEST_BOAT), false, "magic");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)BOPItems.UMBRAN_PLANKS), this.ingredientOf((TagKey<Item>)ModTags.Items.UMBRAN_LOGS), this.ingredientOf((ItemLike)BOPItems.UMBRAN_FENCE), this.ingredientOf((ItemLike)BOPItems.UMBRAN_FENCE_GATE), this.ingredientOf((ItemLike)BOPItems.UMBRAN_DOOR), this.ingredientOf((ItemLike)BOPItems.UMBRAN_TRAPDOOR), this.ingredientOf((ItemLike)BOPItems.UMBRAN_PRESSURE_PLATE), this.ingredientOf((ItemLike)BOPItems.UMBRAN_SIGN), this.ingredientOf((ItemLike)BOPItems.UMBRAN_SHELF), this.ingredientOf((ItemLike)BOPItems.UMBRAN_BOAT), this.ingredientOf((ItemLike)BOPItems.UMBRAN_CHEST_BOAT), false, "umbran");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)BOPItems.HELLBARK_PLANKS), this.ingredientOf((TagKey<Item>)ModTags.Items.HELLBARK_LOGS), this.ingredientOf((ItemLike)BOPItems.HELLBARK_FENCE), this.ingredientOf((ItemLike)BOPItems.HELLBARK_FENCE_GATE), this.ingredientOf((ItemLike)BOPItems.HELLBARK_DOOR), this.ingredientOf((ItemLike)BOPItems.HELLBARK_TRAPDOOR), this.ingredientOf((ItemLike)BOPItems.HELLBARK_PRESSURE_PLATE), this.ingredientOf((ItemLike)BOPItems.HELLBARK_SIGN), this.ingredientOf((ItemLike)BOPItems.HELLBARK_SHELF), this.ingredientOf((ItemLike)BOPItems.HELLBARK_BOAT), this.ingredientOf((ItemLike)BOPItems.HELLBARK_CHEST_BOAT), false, "hellbark");
        this.addBasicWoodSawmillRecipe(output, new ItemStack((ItemLike)BOPItems.EMPYREAL_PLANKS), this.ingredientOf((TagKey<Item>)ModTags.Items.EMPYREAL_LOGS), this.ingredientOf((ItemLike)BOPItems.EMPYREAL_FENCE), this.ingredientOf((ItemLike)BOPItems.EMPYREAL_FENCE_GATE), this.ingredientOf((ItemLike)BOPItems.EMPYREAL_DOOR), this.ingredientOf((ItemLike)BOPItems.EMPYREAL_TRAPDOOR), this.ingredientOf((ItemLike)BOPItems.EMPYREAL_PRESSURE_PLATE), this.ingredientOf((ItemLike)BOPItems.EMPYREAL_SIGN), this.ingredientOf((ItemLike)BOPItems.EMPYREAL_SHELF), this.ingredientOf((ItemLike)BOPItems.EMPYREAL_BOAT), this.ingredientOf((ItemLike)BOPItems.EMPYREAL_CHEST_BOAT), false, "empyreal");
    }

    private void buildPlantGrowthChamberRecipes(RecipeOutput output) {
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.MARIGOLD, "marigold");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.VIOLET, "violet");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.LAVENDER, "lavender");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.WHITE_LAVENDER, "white_lavender");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.ORANGE_COSMOS, "orange_cosmos");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.PINK_DAFFODIL, "pink_daffodil");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.PINK_HIBISCUS, "pink_hibiscus");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.ORIGIN_ROSE, "origin_rose");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.TALL_LAVENDER, "tall_lavender");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.TALL_WHITE_LAVENDER, "tall_white_lavender");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.BLUE_HYDRANGEA, "blue_hydrangea");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.GOLDENROD, "goldenrod");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.ICY_IRIS, "icy_iris");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.GLOWFLOWER, "glowflower");
        this.addBasicFlowerGrowingRecipe(output, (ItemLike)BOPItems.WILTED_LILY, "wilted_liliy");
        this.addBasicMushroomsGrowingRecipe(output, (ItemLike)BOPItems.TOADSTOOL, "toadstool");
        this.addPlantGrowthChamberRecipe(output, this.ingredientOf((ItemLike)BOPItems.PURPLE_WILDFLOWERS), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)BOPItems.PURPLE_WILDFLOWERS), new double[]{1.0, 1.0, 1.0, 0.67, 0.33, 0.33, 0.15})}, 16000, "purple_wildflower", "purple_wildflower");
        this.addPlantGrowthChamberRecipe(output, this.ingredientOf((ItemLike)BOPItems.WHITE_PETALS), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack((ItemLike)BOPItems.WHITE_PETALS), new double[]{1.0, 1.0, 1.0, 0.67, 0.33, 0.33, 0.15})}, 16000, "white_petals", "white_petals");
    }

    private void buildCrystalGrowthChamberRecipes(RecipeOutput output) {
        this.addCrystalGrowthChamberRecipe(output, this.ingredientOf((ItemLike)BOPItems.ROSE_QUARTZ_CHUNK), new OutputItemStackWithPercentages(new ItemStack((ItemLike)BOPItems.ROSE_QUARTZ_CHUNK), new double[]{1.0, 1.0, 0.67, 0.5, 0.25, 0.125}), 16000);
    }

    private void addCrusherRecipe(RecipeOutput recipeOutput, Ingredient input, ItemStack output, String recipeIngredientName) {
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"energizedpowerbop", (String)("compat/biomesoplenty/crusher/" + ModRecipeGenerator.getItemName((ItemLike)output.getItem()) + "_from_crushing_" + recipeIngredientName));
        CrusherRecipe recipe = new CrusherRecipe(output, input);
        recipeOutput.accept(ModRecipeGenerator.getKey(recipeId), (Recipe)recipe, null, new ICondition[]{NeoForgeConditions.modLoaded((String)BIOMES_O_PLENTY_MOD_ID)});
    }

    private void addBasicWoodSawmillRecipe(RecipeOutput recipeOutput, ItemStack planksItem, Ingredient logsInput, Ingredient fenceInput, Ingredient fenceGateInput, Ingredient doorInput, Ingredient trapdoorInput, Ingredient pressurePlateInput, Ingredient signInput, Ingredient shelfInput, Ingredient boatInput, Ingredient chestBoatInput, boolean isRaft, String woodName) {
        this.addSawmillRecipe(recipeOutput, logsInput, planksItem.copyWithCount(6), 1, ModRecipeGenerator.getItemName((ItemLike)planksItem.getItem()), woodName + "_logs");
        this.addBasicWoodWithoutLogsSawmillRecipe(recipeOutput, planksItem, fenceInput, fenceGateInput, doorInput, trapdoorInput, pressurePlateInput, signInput, shelfInput, boatInput, chestBoatInput, isRaft, woodName);
    }

    private void addBasicWoodWithoutLogsSawmillRecipe(RecipeOutput recipeOutput, ItemStack planksItem, Ingredient fenceInput, Ingredient fenceGateInput, Ingredient doorInput, Ingredient trapdoorInput, Ingredient pressurePlateInput, Ingredient signInput, Ingredient shelfInput, Ingredient boatInput, Ingredient chestBoatInput, boolean isRaft, String woodName) {
        this.addBasicWoodWithoutLogsAndBoatsSawmillRecipe(recipeOutput, planksItem, fenceInput, fenceGateInput, doorInput, trapdoorInput, pressurePlateInput, signInput, shelfInput, woodName);
        this.addSawmillRecipe(recipeOutput, boatInput, planksItem.copyWithCount(4), 3, ModRecipeGenerator.getItemName((ItemLike)planksItem.getItem()), woodName + (isRaft ? "_raft" : "_boat"));
        this.addSawmillRecipe(recipeOutput, chestBoatInput, planksItem.copyWithCount(5), 7, ModRecipeGenerator.getItemName((ItemLike)planksItem.getItem()), woodName + (isRaft ? "_chest_raft" : "_chest_boat"));
    }

    private void addBasicWoodWithoutLogsAndBoatsSawmillRecipe(RecipeOutput recipeOutput, ItemStack planksItem, Ingredient fenceInput, Ingredient fenceGateInput, Ingredient doorInput, Ingredient trapdoorInput, Ingredient pressurePlateInput, Ingredient signInput, Ingredient shelfInput, String woodName) {
        this.addSawmillRecipe(recipeOutput, fenceInput, planksItem, 2, ModRecipeGenerator.getItemName((ItemLike)planksItem.getItem()), woodName + "_fence");
        this.addSawmillRecipe(recipeOutput, fenceGateInput, planksItem.copyWithCount(2), 3, ModRecipeGenerator.getItemName((ItemLike)planksItem.getItem()), woodName + "_fence_gate");
        this.addSawmillRecipe(recipeOutput, doorInput, planksItem, 3, ModRecipeGenerator.getItemName((ItemLike)planksItem.getItem()), woodName + "_door");
        this.addSawmillRecipe(recipeOutput, trapdoorInput, planksItem.copyWithCount(2), 3, ModRecipeGenerator.getItemName((ItemLike)planksItem.getItem()), woodName + "_trapdoor");
        this.addSawmillRecipe(recipeOutput, pressurePlateInput, planksItem, 2, ModRecipeGenerator.getItemName((ItemLike)planksItem.getItem()), woodName + "_pressure_plate");
        this.addSawmillRecipe(recipeOutput, signInput, planksItem.copyWithCount(2), 1, ModRecipeGenerator.getItemName((ItemLike)planksItem.getItem()), woodName + "_sign");
        this.addSawmillRecipe(recipeOutput, shelfInput, planksItem.copyWithCount(3), 1, ModRecipeGenerator.getItemName((ItemLike)planksItem.getItem()), woodName + "_shelf");
    }

    private void addSawmillRecipe(RecipeOutput recipeOutput, Ingredient input, ItemStack output, int sawdustAmount, String outputName, String recipeIngredientName) {
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"energizedpowerbop", (String)("compat/biomesoplenty/sawmill/" + outputName + "_from_sawing_" + recipeIngredientName));
        SawmillRecipe recipe = new SawmillRecipe(output, input, sawdustAmount);
        recipeOutput.accept(ModRecipeGenerator.getKey(recipeId), (Recipe)recipe, null, new ICondition[]{NeoForgeConditions.modLoaded((String)BIOMES_O_PLENTY_MOD_ID)});
    }

    private void addBasicFlowerGrowingRecipe(RecipeOutput recipeOutput, ItemLike flowerItem, String outputName) {
        this.addPlantGrowthChamberRecipe(recipeOutput, this.ingredientOf(flowerItem), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack(flowerItem), new double[]{1.0, 1.0, 0.33})}, 16000, outputName, ModRecipeGenerator.getItemName((ItemLike)flowerItem));
    }

    private void addBasicMushroomsGrowingRecipe(RecipeOutput recipeOutput, ItemLike mushroomItem, String outputName) {
        this.addPlantGrowthChamberRecipe(recipeOutput, this.ingredientOf(mushroomItem), new OutputItemStackWithPercentages[]{new OutputItemStackWithPercentages(new ItemStack(mushroomItem), new double[]{1.0, 1.0, 0.5, 0.25})}, 16000, outputName, ModRecipeGenerator.getItemName((ItemLike)mushroomItem));
    }

    private void addPlantGrowthChamberRecipe(RecipeOutput recipeOutput, Ingredient input, OutputItemStackWithPercentages[] outputs, int ticks, String outputName, String recipeIngredientName) {
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"energizedpowerbop", (String)("compat/biomesoplenty/growing/" + outputName + "_from_growing_" + recipeIngredientName));
        PlantGrowthChamberRecipe recipe = new PlantGrowthChamberRecipe(outputs, input, ticks);
        recipeOutput.accept(ModRecipeGenerator.getKey(recipeId), (Recipe)recipe, null, new ICondition[]{NeoForgeConditions.modLoaded((String)BIOMES_O_PLENTY_MOD_ID)});
    }

    private void addCrystalGrowthChamberRecipe(RecipeOutput recipeOutput, Ingredient input, OutputItemStackWithPercentages output, int ticks) {
        this.addCrystalGrowthChamberRecipe(recipeOutput, new IngredientWithCount(input), output, ticks);
    }

    private void addCrystalGrowthChamberRecipe(RecipeOutput recipeOutput, IngredientWithCount input, OutputItemStackWithPercentages output, int ticks) {
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"energizedpowerbop", (String)("compat/biomesoplenty/crystal_growing/" + ModRecipeGenerator.getItemName((ItemLike)output.output().getItem())));
        CrystalGrowthChamberRecipe recipe = new CrystalGrowthChamberRecipe(output, input, ticks);
        recipeOutput.accept(ModRecipeGenerator.getKey(recipeId), (Recipe)recipe, null, new ICondition[]{NeoForgeConditions.modLoaded((String)BIOMES_O_PLENTY_MOD_ID)});
    }

    private Ingredient ingredientOf(ItemLike item) {
        return Ingredient.of((ItemLike)item);
    }

    private Ingredient ingredientOf(ItemLike ... items) {
        return Ingredient.of((ItemLike[])items);
    }

    private Ingredient ingredientOf(TagKey<Item> tagKey) {
        return Ingredient.of((HolderSet)this.registries.lookupOrThrow(Registries.ITEM).getOrThrow(tagKey));
    }

    private static ResourceKey<Recipe<?>> getKey(ResourceLocation recipeId) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)recipeId);
    }
}

