/*
 * Decompiled with CFR 0.152.
 */
package net.nxmelxss.misc;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.nxmelxss.misc.ValueInputFieldWidget;

public class ConfigManager {
    private static final Path CONFIG_FILE = Paths.get("config", "swingspeedchanger.json");
    private static int configIntValue = 6;
    private static boolean configBoolValue = true;

    public static void loadConfig() {
        if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
            ConfigManager.saveConfig(configIntValue, configBoolValue);
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_FILE);){
            JsonObject json = new JsonParser().parse((Reader)reader).getAsJsonObject();
            configIntValue = json.get("SwingSpeed").getAsInt();
            configBoolValue = json.get("toggleFeature").getAsBoolean();
            ValueInputFieldWidget.SettedValue = json.get("SwingSpeed").getAsInt();
        }
        catch (JsonParseException | IOException e) {
            System.err.println("Failed to load config! Using defaults.");
            e.printStackTrace();
        }
    }

    public static void saveConfig(int intValue, boolean boolValue) {
        configIntValue = intValue;
        configBoolValue = boolValue;
        JsonObject json = new JsonObject();
        json.addProperty("SwingSpeed", (Number)intValue);
        json.addProperty("toggleFeature", Boolean.valueOf(boolValue));
        try {
            Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]);){
                new Gson().toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save config!");
            e.printStackTrace();
        }
    }

    public static int getIntValue() {
        return configIntValue;
    }

    public static boolean getBoolValue() {
        return configBoolValue;
    }

    public static void setIntValue(int i) {
        configIntValue = i;
    }
}

