/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.client;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.alegian.thavma.impl.client.gui.toast.ResearchToast;
import me.alegian.thavma.impl.common.research.ResearchEntry;
import me.alegian.thavma.impl.common.util.LevelExtensionsKt;
import me.alegian.thavma.impl.init.registries.deferred.T7Attributes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a0\u0010\n\u001a\u0012\u0012\f\u0012\n \r*\u0004\u0018\u0001H\fH\f\u0018\u00010\u000b\"\u0004\b\u0000\u0010\f2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u000b0\u000f\u001a\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013\u001a&\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a\u00a8\u0006\u001c"}, d2={"clientPlayerHasRevealing", "", "getClientPlayerEquipmentItem", "Lnet/minecraft/world/item/Item;", "slot", "Lnet/minecraft/world/entity/EquipmentSlot;", "setScreen", "", "screen", "Lnet/minecraft/client/gui/screens/Screen;", "clientRegistry", "Lnet/minecraft/core/Registry;", "T", "kotlin.jvm.PlatformType", "key", "Lnet/minecraft/resources/ResourceKey;", "pushScreen", "researchToast", "entry", "Lme/alegian/thavma/impl/common/research/ResearchEntry;", "clientSound", "sound", "Lnet/minecraft/sounds/SoundEvent;", "source", "Lnet/minecraft/sounds/SoundSource;", "volume", "", "pitch", "thavma-neoforge"})
public final class ClientHelperKt {
    public static final boolean clientPlayerHasRevealing() {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        return Intrinsics.areEqual(localPlayer != null && (localPlayer = localPlayer.getAttribute((Holder)T7Attributes.INSTANCE.getREVEALING())) != null ? Double.valueOf(localPlayer.getValue()) : null, (double)1.0);
    }

    @Nullable
    public static final Item getClientPlayerEquipmentItem(@NotNull EquipmentSlot slot) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        return localPlayer != null && (localPlayer = localPlayer.getItemBySlot(slot)) != null ? localPlayer.getItem() : null;
    }

    public static final void setScreen(@NotNull Screen screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        Minecraft.getInstance().setScreen(screen);
    }

    @Nullable
    public static final <T> Registry<T> clientRegistry(@NotNull ResourceKey<Registry<T>> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        ClientLevel clientLevel = Minecraft.getInstance().level;
        return clientLevel != null ? LevelExtensionsKt.registry((Level)clientLevel, key) : null;
    }

    public static final void pushScreen(@NotNull Screen screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        Minecraft.getInstance().pushGuiLayer(screen);
    }

    public static final void researchToast(@NotNull ResearchEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Minecraft.getInstance().getToasts().addToast((Toast)new ResearchToast(entry));
    }

    public static final void clientSound(@NotNull SoundEvent sound, @NotNull SoundSource source, float volume, float pitch) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        ClientLevel clientLevel = Minecraft.getInstance().level;
        if (clientLevel == null) {
            return;
        }
        ClientLevel level = clientLevel;
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        level.playSound((Player)player, player.blockPosition(), sound, source, volume, pitch);
    }
}

