/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.alegian.thavma.impl.client.ClientHelperKt;
import me.alegian.thavma.impl.client.T7KeyMappings;
import me.alegian.thavma.impl.client.gui.foci.FociScreen;
import me.alegian.thavma.impl.client.gui.tooltip.AspectClientTooltipComponent;
import me.alegian.thavma.impl.client.gui.tooltip.AspectTooltipComponent;
import me.alegian.thavma.impl.client.gui.tooltip.TooltipHelperKt;
import me.alegian.thavma.impl.client.renderer.AspectRenderer;
import me.alegian.thavma.impl.client.renderer.HammerHighlightRenderer;
import me.alegian.thavma.impl.common.aspect.AspectHelper;
import me.alegian.thavma.impl.common.aspect.AspectMap;
import me.alegian.thavma.impl.common.block.AuraNodeBlock;
import me.alegian.thavma.impl.common.data.capability.AspectContainer;
import me.alegian.thavma.impl.common.item.HammerItem;
import me.alegian.thavma.impl.common.item.WandItem;
import me.alegian.thavma.impl.common.payload.FocusPayload;
import me.alegian.thavma.impl.common.scanning.ScanHelperKt;
import me.alegian.thavma.impl.init.registries.deferred.T7Blocks;
import me.alegian.thavma.impl.init.registries.deferred.T7DataComponents;
import me.alegian.thavma.impl.init.registries.deferred.T7Items;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\tH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\tH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0011H\u0002\u001a\u0006\u0010\u0012\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"allowHammerOutlineEvents", "", "renderBlockHighlight", "", "event", "Lnet/neoforged/neoforge/client/event/RenderHighlightEvent$Block;", "renderLevelAfterWeather", "Lnet/neoforged/neoforge/client/event/RenderLevelStageEvent;", "wandTooltip", "Lnet/neoforged/neoforge/client/event/RenderTooltipEvent$GatherComponents;", "jarTooltip", "aspectTooltip", "renderPlayerPre", "Lnet/neoforged/neoforge/client/event/RenderPlayerEvent$Pre;", "cooldownTicks", "", "clientTick", "Lnet/neoforged/neoforge/client/event/ClientTickEvent$Post;", "registerClientGameEvents", "thavma-neoforge"})
@SourceDebugExtension(value={"SMAP\nT7ClientGameEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 T7ClientGameEvents.kt\nme/alegian/thavma/impl/client/event/T7ClientGameEventsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Forge.kt\nthedarkcolour/kotlinforforge/neoforge/forge/ForgeKt\n*L\n1#1,163:1\n1563#2:164\n1634#2,3:165\n37#3:168\n17#3:169\n17#3:170\n17#3:171\n17#3:172\n17#3:173\n17#3:174\n17#3:175\n*S KotlinDebug\n*F\n+ 1 T7ClientGameEvents.kt\nme/alegian/thavma/impl/client/event/T7ClientGameEventsKt\n*L\n103#1:164\n103#1:165,3\n154#1:168\n156#1:169\n157#1:170\n158#1:171\n159#1:172\n160#1:173\n161#1:174\n162#1:175\n*E\n"})
public final class T7ClientGameEventsKt {
    private static boolean allowHammerOutlineEvents = true;
    private static int cooldownTicks;

    private static final void renderBlockHighlight(RenderHighlightEvent.Block event) {
        ClientLevel clientLevel = Minecraft.getInstance().level;
        if (clientLevel == null) {
            return;
        }
        ClientLevel level = clientLevel;
        BlockHitResult hitResult = event.getTarget();
        if (hitResult.getType() == HitResult.Type.MISS) {
            return;
        }
        BlockPos targetPos = hitResult.getBlockPos();
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        ItemStack itemStack = player.getMainHandItem();
        Item item = itemStack.getItem();
        if (allowHammerOutlineEvents && item instanceof HammerItem) {
            allowHammerOutlineEvents = false;
            HammerItem hammerItem = (HammerItem)item;
            Intrinsics.checkNotNull((Object)itemStack);
            Intrinsics.checkNotNull((Object)hitResult);
            HammerHighlightRenderer.INSTANCE.render(event, hammerItem, player, level, itemStack, hitResult);
            allowHammerOutlineEvents = true;
        }
        if (level.getBlockState(targetPos).getBlock() instanceof AuraNodeBlock) {
            event.setCanceled(true);
        }
    }

    private static final void renderLevelAfterWeather(RenderLevelStageEvent event) {
        block5: {
            if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_WEATHER) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            ClientLevel clientLevel = minecraft.level;
            if (clientLevel == null) {
                return;
            }
            ClientLevel level = clientLevel;
            HitResult hitResult = minecraft.hitResult;
            if (hitResult == null || hitResult.getType() != HitResult.Type.BLOCK) {
                return;
            }
            BlockPos blockPos = ((BlockHitResult)hitResult).getBlockPos();
            Level level2 = (Level)level;
            Intrinsics.checkNotNull((Object)blockPos);
            if (!AspectContainer.Companion.isAspectContainer(level2, blockPos)) {
                return;
            }
            if (!ClientHelperKt.clientPlayerHasRevealing()) {
                return;
            }
            Object object = AspectContainer.Companion.at((Level)level, blockPos);
            if (object == null || (object = object.getAspects()) == null) break block5;
            Object it = object;
            boolean bl = false;
            PoseStack poseStack = event.getPoseStack();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"getPoseStack(...)");
            Camera camera = event.getCamera();
            Intrinsics.checkNotNullExpressionValue((Object)camera, (String)"getCamera(...)");
            AspectRenderer.INSTANCE.renderAfterWeather((AspectMap)it, poseStack, camera, blockPos);
        }
    }

    private static final void wandTooltip(RenderTooltipEvent.GatherComponents event) {
        block3: {
            if (!(event.getItemStack().getItem() instanceof WandItem)) {
                return;
            }
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            if (localPlayer == null) {
                return;
            }
            LocalPlayer player = localPlayer;
            if (!ClientHelperKt.clientPlayerHasRevealing() && !player.isCreative()) {
                return;
            }
            ItemStack itemStack = event.getItemStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
            Object object = AspectContainer.Companion.from(itemStack);
            if (object == null || (object = object.getAspects()) == null) break block3;
            Object it = object;
            boolean bl = false;
            event.getTooltipElements().add(Either.left((Object)TooltipHelperKt.containedPrimalsComponent((AspectMap)it)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void jarTooltip(RenderTooltipEvent.GatherComponents event) {
        block4: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            if (!Intrinsics.areEqual((Object)event.getItemStack().getItem(), (Object)T7Blocks.INSTANCE.getSEALING_JAR().asItem()) && !Intrinsics.areEqual((Object)event.getItemStack().getItem(), (Object)T7Items.INSTANCE.getNODE_JAR().get())) {
                return;
            }
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            if (localPlayer == null) {
                return;
            }
            LocalPlayer player = localPlayer;
            if (!ClientHelperKt.clientPlayerHasRevealing() && !player.isCreative()) {
                return;
            }
            ItemStack itemStack = event.getItemStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
            Object object = AspectContainer.Companion.from(itemStack);
            if (object == null || (object = object.getAspects()) == null) break block4;
            Object it = object;
            boolean bl = false;
            Iterable iterable = TooltipHelperKt.containedAspectsComponents((AspectMap)it);
            List list = event.getTooltipElements();
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                MutableComponent mutableComponent = (MutableComponent)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(Either.left((Object)it2));
            }
            list.addAll((List)destination$iv$iv);
        }
    }

    private static final void aspectTooltip(RenderTooltipEvent.GatherComponents event) {
        if (event.getItemStack().isEmpty()) {
            return;
        }
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        ItemStack itemStack = event.getItemStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
        AspectMap aspectMap = AspectHelper.INSTANCE.getAspects(itemStack);
        if (aspectMap == null) {
            return;
        }
        AspectMap aspects = aspectMap;
        if (!player.isCreative()) {
            Player player2 = (Player)player;
            ItemStack itemStack2 = event.getItemStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemStack(...)");
            if (!ScanHelperKt.hasScanned(player2, itemStack2)) {
                event.getTooltipElements().add(Either.left((Object)Component.translatable((String)AspectClientTooltipComponent.I18n.INSTANCE.getNOT_SCANNED()).withStyle(ChatFormatting.GRAY)));
                return;
            }
        }
        if (!Screen.hasShiftDown()) {
            return;
        }
        event.getTooltipElements().add(Either.right((Object)new AspectTooltipComponent(aspects)));
    }

    private static final void renderPlayerPre(RenderPlayerEvent.Pre event) {
        PlayerModel model = (PlayerModel)event.getRenderer().getModel();
        if (Intrinsics.areEqual((Object)ClientHelperKt.getClientPlayerEquipmentItem(EquipmentSlot.CHEST), (Object)T7Items.INSTANCE.getTHAVMITE_VANGUARD_CHESTPLATE().get())) {
            model.leftSleeve.visible = false;
            model.rightSleeve.visible = false;
            model.jacket.visible = false;
        }
        if (Intrinsics.areEqual((Object)ClientHelperKt.getClientPlayerEquipmentItem(EquipmentSlot.LEGS), (Object)T7Items.INSTANCE.getTHAVMITE_VANGUARD_LEGGINGS().get())) {
            model.leftPants.visible = false;
            model.rightPants.visible = false;
        }
    }

    private static final void clientTick(ClientTickEvent.Post event) {
        ItemStack focus;
        int n = cooldownTicks;
        cooldownTicks = n + -1;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer localPlayer = mc.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        ItemStack wandStack = player.getMainHandItem();
        if (!T7KeyMappings.INSTANCE.getFOCI().isDown() || !(wandStack.getItem() instanceof WandItem)) {
            return;
        }
        Object object = (ItemContainerContents)wandStack.get((Supplier)T7DataComponents.INSTANCE.getFOCUS());
        ItemStack itemStack = object != null && (object = object.nonEmptyItems()) != null ? (ItemStack)CollectionsKt.firstOrNull((Iterable)object) : (focus = null);
        if (player.isShiftKeyDown() && focus != null && cooldownTicks <= 0) {
            PacketDistributor.sendToServer((CustomPacketPayload)new FocusPayload(null), (CustomPacketPayload[])new CustomPacketPayload[0]);
            cooldownTicks = 10;
        } else if (!player.isShiftKeyDown() && mc.screen == null && mc.getOverlay() == null) {
            mc.setScreen((Screen)new FociScreen());
        }
    }

    public static final void registerClientGameEvents() {
        boolean $i$f$getDIST = false;
        Dist dist = FMLEnvironment.dist;
        Intrinsics.checkNotNullExpressionValue((Object)dist, (String)"dist");
        if (dist != Dist.CLIENT) {
            return;
        }
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(T7ClientGameEventsKt::renderBlockHighlight);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus2 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus2, (String)"EVENT_BUS");
        iEventBus2.addListener(T7ClientGameEventsKt::renderLevelAfterWeather);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus3 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus3, (String)"EVENT_BUS");
        iEventBus3.addListener(T7ClientGameEventsKt::wandTooltip);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus4 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus4, (String)"EVENT_BUS");
        iEventBus4.addListener(T7ClientGameEventsKt::jarTooltip);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus5 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus5, (String)"EVENT_BUS");
        iEventBus5.addListener(T7ClientGameEventsKt::aspectTooltip);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus6 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus6, (String)"EVENT_BUS");
        iEventBus6.addListener(T7ClientGameEventsKt::renderPlayerPre);
        $i$f$getFORGE_BUS = false;
        IEventBus iEventBus7 = NeoForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus7, (String)"EVENT_BUS");
        iEventBus7.addListener(T7ClientGameEventsKt::clientTick);
    }
}

