/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.client.gui.book;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.alegian.thavma.impl.client.ClientHelper;
import me.alegian.thavma.impl.client.ClientHelperKt;
import me.alegian.thavma.impl.client.gui.book.BookScreen;
import me.alegian.thavma.impl.client.gui.book.EntryScreen;
import me.alegian.thavma.impl.client.gui.book.GridHelperKt;
import me.alegian.thavma.impl.client.gui.book.TabRenderable;
import me.alegian.thavma.impl.client.gui.tooltip.T7Tooltip;
import me.alegian.thavma.impl.client.texture.Texture;
import me.alegian.thavma.impl.client.util.GuiGraphicsExtensionsKt;
import me.alegian.thavma.impl.client.util.PoseStackExtensionsKt;
import me.alegian.thavma.impl.client.util.RenderSystemExtensionsKt;
import me.alegian.thavma.impl.common.entity.KnowledgeHelperKt;
import me.alegian.thavma.impl.common.payload.ResearchScrollPayload;
import me.alegian.thavma.impl.common.research.ResearchEntry;
import me.alegian.thavma.impl.common.util.Vector2iExtensionsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 32\u00020\u0001:\u00013B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J(\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(H\u0014J \u0010)\u001a\u00020\"2\u0006\u0010%\u001a\u00020*2\u0006\u0010&\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001dH\u0016J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u0010/\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u00100\u001a\u00020\"2\u0006\u00101\u001a\u000202H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001d\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lme/alegian/thavma/impl/client/gui/book/EntryWidget;", "Lnet/minecraft/client/gui/components/AbstractWidget;", "screen", "Lme/alegian/thavma/impl/client/gui/book/BookScreen;", "tab", "Lme/alegian/thavma/impl/client/gui/book/TabRenderable;", "entry", "Lnet/minecraft/core/Holder;", "Lme/alegian/thavma/impl/common/research/ResearchEntry;", "<init>", "(Lme/alegian/thavma/impl/client/gui/book/BookScreen;Lme/alegian/thavma/impl/client/gui/book/TabRenderable;Lnet/minecraft/core/Holder;)V", "getTab", "()Lme/alegian/thavma/impl/client/gui/book/TabRenderable;", "getEntry", "()Lnet/minecraft/core/Holder;", "gaveScroll", "", "knowsResearch", "getKnowsResearch", "()Z", "knowsParents", "getKnowsParents", "children", "", "getChildren", "()Ljava/util/List;", "pos", "Lorg/joml/Vector2i;", "getX", "", "getY", "getWidth", "getHeight", "renderWidget", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "mouseY", "partialTick", "", "onClick", "", "button", "updateWidgetNarration", "narrationElementOutput", "Lnet/minecraft/client/gui/narration/NarrationElementOutput;", "renderEntry", "playDownSound", "handler", "Lnet/minecraft/client/sounds/SoundManager;", "Companion", "thavma-neoforge"})
@SourceDebugExtension(value={"SMAP\nEntryWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntryWidget.kt\nme/alegian/thavma/impl/client/gui/book/EntryWidget\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1740#2,3:144\n*S KotlinDebug\n*F\n+ 1 EntryWidget.kt\nme/alegian/thavma/impl/client/gui/book/EntryWidget\n*L\n42#1:144,3\n*E\n"})
public final class EntryWidget
extends AbstractWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BookScreen screen;
    @NotNull
    private final TabRenderable tab;
    @NotNull
    private final Holder<ResearchEntry> entry;
    private boolean gaveScroll;
    private final boolean knowsResearch;
    private final boolean knowsParents;
    @NotNull
    private final List<Holder<ResearchEntry>> children;
    @NotNull
    private final Vector2i pos;
    @NotNull
    private static final Texture TEXTURE = new Texture("gui/book/node", 32, 32);

    /*
     * WARNING - void declaration
     */
    public EntryWidget(@NotNull BookScreen screen, @NotNull TabRenderable tab, @NotNull Holder<ResearchEntry> entry) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)screen), (String)"screen");
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        super(0, 0, GridHelperKt.getCELL_SIZE(), GridHelperKt.getCELL_SIZE(), ((ResearchEntry)entry.value()).getTitle());
        this.screen = screen;
        this.tab = tab;
        this.entry = entry;
        LocalPlayer localPlayer = ClientHelper.INSTANCE.player();
        this.knowsResearch = localPlayer != null ? KnowledgeHelperKt.knowsResearch((Player)localPlayer, this.entry) : false;
        EntryWidget entryWidget = this;
        LocalPlayer localPlayer2 = ClientHelper.INSTANCE.player();
        if (localPlayer2 != null) {
            boolean bl2;
            EntryWidget entryWidget2;
            block6: {
                void player;
                LocalPlayer localPlayer3 = localPlayer2;
                entryWidget2 = entryWidget;
                boolean bl3 = false;
                ResearchEntry researchEntry = (ResearchEntry)this.entry.value();
                Level level = player.level();
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
                List<Holder<ResearchEntry>> parents = researchEntry.parents(level);
                Iterable $this$all$iv = parents;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Holder it = (Holder)element$iv;
                        boolean bl4 = false;
                        if (KnowledgeHelperKt.knowsResearch((Player)player, (Holder<ResearchEntry>)it)) continue;
                        bl2 = false;
                        break block6;
                    }
                    bl2 = true;
                }
            }
            boolean bl5 = bl2;
            entryWidget = entryWidget2;
            bl = bl5;
        } else {
            bl = false;
        }
        entryWidget.knowsParents = bl;
        this.children = ((ResearchEntry)this.entry.value()).getChildren();
        Object[] objectArray = new Component[]{((ResearchEntry)this.entry.value()).getTitle()};
        List components = CollectionsKt.mutableListOf((Object[])objectArray);
        if (!this.knowsParents) {
            MutableComponent mutableComponent = Component.translatable((String)ResearchEntry.Companion.getPARENTS_UNKNOWN_TRANSLATION()).withStyle(ChatFormatting.GRAY);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            components.add(mutableComponent);
        }
        this.setTooltip(new T7Tooltip(components));
        this.pos = ((ResearchEntry)this.entry.value()).getPosition();
    }

    @NotNull
    public final TabRenderable getTab() {
        return this.tab;
    }

    @NotNull
    public final Holder<ResearchEntry> getEntry() {
        return this.entry;
    }

    public final boolean getKnowsResearch() {
        return this.knowsResearch;
    }

    public final boolean getKnowsParents() {
        return this.knowsParents;
    }

    @NotNull
    public final List<Holder<ResearchEntry>> getChildren() {
        return this.children;
    }

    public int getX() {
        return (int)(((double)(this.pos.x * GridHelperKt.getCELL_SIZE() - GridHelperKt.getCELL_SIZE() / 2) - this.tab.getScrollX()) / this.tab.zoomFactor() + (double)(this.screen.width / 2));
    }

    public int getY() {
        return (int)(((double)(this.pos.y * GridHelperKt.getCELL_SIZE() - GridHelperKt.getCELL_SIZE() / 2) - this.tab.getScrollY()) / this.tab.zoomFactor() + (double)(this.screen.height / 2));
    }

    public int getWidth() {
        return (int)((double)GridHelperKt.getCELL_SIZE() / this.tab.zoomFactor());
    }

    public int getHeight() {
        return (int)((double)GridHelperKt.getCELL_SIZE() / this.tab.zoomFactor());
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        this.isHovered = guiGraphics.containsPointInScissor(mouseX, mouseY) && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY() + this.getHeight();
        GuiGraphicsExtensionsKt.usePose(guiGraphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> EntryWidget.renderWidget$lambda$3(this, guiGraphics, arg_0)));
    }

    public void onClick(double mouseX, double mouseY, int button) {
        if (!this.knowsResearch && this.knowsParents && !this.gaveScroll) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ResearchScrollPayload(this.entry), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SoundEvent soundEvent = SoundEvents.BOOK_PAGE_TURN;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"BOOK_PAGE_TURN");
            ClientHelperKt.clientSound(soundEvent, SoundSource.AMBIENT, 1.0f, 1.0f);
            this.gaveScroll = true;
            Component[] componentArray = new Component[2];
            componentArray[0] = ((ResearchEntry)this.entry.value()).getTitle();
            Intrinsics.checkNotNullExpressionValue((Object)Component.translatable((String)ResearchEntry.Companion.getSCROLL_GIVEN_TRANSLATION()).withStyle(ChatFormatting.GRAY), (String)"withStyle(...)");
            this.setTooltip(new T7Tooltip(componentArray));
            return;
        }
        if (this.knowsResearch) {
            ClientHelperKt.pushScreen(new EntryScreen(this.entry));
        }
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        Intrinsics.checkNotNullParameter((Object)narrationElementOutput, (String)"narrationElementOutput");
    }

    private final void renderEntry(GuiGraphics guiGraphics) {
        float brightness = 1.0f;
        if (!this.knowsResearch) {
            brightness = 0.4f;
        }
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        GridHelperKt.renderGridElement(guiGraphics, 1.0f, 1.0f, TEXTURE.getLocation(), false);
        GuiGraphicsExtensionsKt.usePose(guiGraphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> EntryWidget.renderEntry$lambda$4(guiGraphics, this, arg_0)));
        RenderSystemExtensionsKt.resetRenderSystemColor();
    }

    public void playDownSound(@NotNull SoundManager handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f, (float)1.0f));
    }

    private static final Unit renderWidget$lambda$3$lambda$2(Vector2i $dv, GuiGraphics $guiGraphics, Holder $child, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        GridHelperKt.renderConnectionRecursive($this$usePose, $dv.x, $dv.y, $guiGraphics, ((ResearchEntry)$child.value()).getPreferX(), false);
        return Unit.INSTANCE;
    }

    private static final Unit renderWidget$lambda$3(EntryWidget this$0, GuiGraphics $guiGraphics, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        PoseStackExtensionsKt.translateXY($this$usePose, this$0.screen.width / 2, this$0.screen.height / 2);
        PoseStackExtensionsKt.scaleXY($this$usePose, 1.0 / this$0.tab.zoomFactor());
        PoseStackExtensionsKt.translateXY($this$usePose, -this$0.tab.getScrollX(), -this$0.tab.getScrollY());
        PoseStackExtensionsKt.scaleXY($this$usePose, GridHelperKt.getCELL_SIZE());
        PoseStackExtensionsKt.translateXY($this$usePose, this$0.pos.x, this$0.pos.y);
        this$0.renderEntry($guiGraphics);
        if (!this$0.knowsResearch) {
            return Unit.INSTANCE;
        }
        RenderSystem.disableCull();
        for (Holder<ResearchEntry> child : this$0.children) {
            Vector2i dv = Vector2iExtensionsKt.minus(((ResearchEntry)child.value()).getPosition(), this$0.pos);
            GuiGraphicsExtensionsKt.usePose($guiGraphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> EntryWidget.renderWidget$lambda$3$lambda$2(dv, $guiGraphics, child, arg_0)));
        }
        RenderSystem.enableCull();
        return Unit.INSTANCE;
    }

    private static final Unit renderEntry$lambda$4(GuiGraphics $guiGraphics, EntryWidget this$0, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        PoseStackExtensionsKt.scaleXY($this$usePose, Float.valueOf(1.0f / (float)GridHelperKt.getCELL_SIZE()));
        PoseStackExtensionsKt.scaleXY($this$usePose, 1.4);
        $guiGraphics.renderItem(((ResearchEntry)this$0.entry.value()).getIcon(), -8, -8);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/alegian/thavma/impl/client/gui/book/EntryWidget$Companion;", "", "<init>", "()V", "TEXTURE", "Lme/alegian/thavma/impl/client/texture/Texture;", "getTEXTURE", "()Lme/alegian/thavma/impl/client/texture/Texture;", "thavma-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Texture getTEXTURE() {
            return TEXTURE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

