/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.client.gui.foci;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.alegian.thavma.impl.client.T7KeyMappings;
import me.alegian.thavma.impl.client.gui.foci.FociScreenKt;
import me.alegian.thavma.impl.client.texture.Texture;
import me.alegian.thavma.impl.client.util.GuiGraphicsExtensionsKt;
import me.alegian.thavma.impl.client.util.PoseStackExtensionsKt;
import me.alegian.thavma.impl.client.util.RenderSystemExtensionsKt;
import me.alegian.thavma.impl.common.payload.FocusPayload;
import me.alegian.thavma.impl.init.registries.deferred.T7DataComponents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001cH\u0016J(\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0007\"\u0004\b\u0017\u0010\tR\u001a\u0010\u0018\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0007\"\u0004\b\u001a\u0010\t\u00a8\u0006)"}, d2={"Lme/alegian/thavma/impl/client/gui/foci/FociScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "<init>", "()V", "ticks", "", "getTicks", "()I", "setTicks", "(I)V", "selectedIndex", "getSelectedIndex", "()Ljava/lang/Integer;", "setSelectedIndex", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "foci", "", "Lnet/minecraft/world/item/ItemStack;", "getFoci", "()Ljava/util/List;", "animationProgress", "getAnimationProgress", "setAnimationProgress", "prevAnimationProgress", "getPrevAnimationProgress", "setPrevAnimationProgress", "init", "", "tick", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "mouseY", "partialTick", "", "shouldCloseOnEsc", "", "isPauseScreen", "Companion", "thavma-neoforge"})
@SourceDebugExtension(value={"SMAP\nFociScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FociScreen.kt\nme/alegian/thavma/impl/client/gui/foci/FociScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class FociScreen
extends Screen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int ticks;
    @Nullable
    private Integer selectedIndex;
    @NotNull
    private final List<ItemStack> foci = FociScreenKt.getFociFromLocalInventory();
    private int animationProgress;
    private int prevAnimationProgress;
    @NotNull
    private static final String TITLE_ID = "screen.thavma.title";
    @NotNull
    private static final Texture BACKGROUND = new Texture("gui/foci/circle", 236, 236);
    private static final float SCALE = 0.5f;
    private static final float DEGREES_PER_TICK = 0.5f;
    private static final float MAX_RADIUS = 0.5f * (float)BACKGROUND.getWidth() / (float)2;
    private static final int ANIMATION_DURATION = 5;

    public FociScreen() {
        super((Component)Component.translatable((String)TITLE_ID));
    }

    public final int getTicks() {
        return this.ticks;
    }

    public final void setTicks(int n) {
        this.ticks = n;
    }

    @Nullable
    public final Integer getSelectedIndex() {
        return this.selectedIndex;
    }

    public final void setSelectedIndex(@Nullable Integer n) {
        this.selectedIndex = n;
    }

    @NotNull
    public final List<ItemStack> getFoci() {
        return this.foci;
    }

    public final int getAnimationProgress() {
        return this.animationProgress;
    }

    public final void setAnimationProgress(int n) {
        this.animationProgress = n;
    }

    public final int getPrevAnimationProgress() {
        return this.prevAnimationProgress;
    }

    public final void setPrevAnimationProgress(int n) {
        this.prevAnimationProgress = n;
    }

    protected void init() {
        T7KeyMappings.INSTANCE.getFOCI().setDown(true);
    }

    public void tick() {
        int n = this.ticks;
        this.ticks = n + 1;
        this.prevAnimationProgress = this.animationProgress;
        int n2 = this.animationProgress = T7KeyMappings.INSTANCE.getFOCI().isDown() ? Math.min(this.animationProgress + 1, ANIMATION_DURATION) : Math.max(0, this.animationProgress - 1);
        if (this.animationProgress == 0) {
            this.onClose();
            Integer n3 = this.selectedIndex;
            if (n3 == null) {
                return;
            }
            int selectedIndex = n3;
            if (!((Collection)this.foci).isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FocusPayload(this.foci.get(selectedIndex)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        float partialProgress = Mth.lerp((float)partialTick, (float)this.prevAnimationProgress, (float)this.animationProgress);
        float animatedRadius = Mth.lerp((float)(partialProgress / (float)ANIMATION_DURATION), (float)0.0f, (float)MAX_RADIUS);
        float deadRadius = animatedRadius / (float)2;
        double centeredMouseX = (double)mouseX - (double)this.width / 2.0;
        double centeredMouseY = (double)mouseY - (double)this.height / 2.0;
        double mouseRadius = Math.hypot(centeredMouseX, centeredMouseY);
        double anglePerItem = Math.PI * 2 / (double)this.foci.size();
        double mouseAngle = Math.atan2(centeredMouseY, centeredMouseX) + anglePerItem / (double)2;
        if (mouseAngle < 0.0) {
            mouseAngle += Math.PI * 2;
        }
        if (T7KeyMappings.INSTANCE.getFOCI().isDown()) {
            this.selectedIndex = (int)Math.floor(mouseAngle / anglePerItem);
            if (mouseRadius <= (double)deadRadius) {
                this.selectedIndex = null;
            }
        }
        ItemStack equippedFocus = (object = Minecraft.getInstance().player) != null && (object = object.getMainHandItem()) != null && (object = (ItemContainerContents)object.get((Supplier)T7DataComponents.INSTANCE.getFOCUS())) != null && (object = object.nonEmptyItems()) != null ? (ItemStack)CollectionsKt.firstOrNull((Iterable)object) : null;
        ItemStack tooltipFocus = null;
        tooltipFocus = equippedFocus;
        GuiGraphicsExtensionsKt.usePose(guiGraphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> FociScreen.render$lambda$2(this, partialTick, guiGraphics, equippedFocus, animatedRadius, anglePerItem, arg_0)));
        if (!((Collection)this.foci).isEmpty()) {
            Integer n = this.selectedIndex;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                tooltipFocus = this.foci.get(it);
            }
        }
        if (tooltipFocus != null) {
            guiGraphics.renderTooltip(this.font, tooltipFocus, -8, 16);
        }
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static final Unit render$lambda$2$lambda$0(float $animatedRadius, float $renderTicks, GuiGraphics $guiGraphics, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        PoseStackExtensionsKt.scaleXY($this$usePose, Float.valueOf(0.5f * $animatedRadius / MAX_RADIUS));
        PoseStackExtensionsKt.rotateZ($this$usePose, Float.valueOf($renderTicks * 0.5f % (float)360));
        RenderSystemExtensionsKt.setRenderSystemColor(-3211009);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        GuiGraphicsExtensionsKt.blitCentered($guiGraphics, BACKGROUND);
        RenderSystemExtensionsKt.resetRenderSystemColor();
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$2$lambda$1(double $anglePerItem, int $i, float $animatedRadius, FociScreen this$0, GuiGraphics $guiGraphics, ItemStack $stack, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        PoseStackExtensionsKt.translateXY($this$usePose, Math.cos($anglePerItem * (double)$i) * (double)$animatedRadius, Math.sin($anglePerItem * (double)$i) * (double)$animatedRadius);
        PoseStackExtensionsKt.scale($this$usePose, 2.0f);
        Integer n = this$0.selectedIndex;
        if (n != null && $i == n) {
            PoseStackExtensionsKt.scaleXY($this$usePose, Float.valueOf(1.5f));
        }
        PoseStackExtensionsKt.translateXY($this$usePose, -8, -8);
        $guiGraphics.renderItem($stack, 0, 0);
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$2(FociScreen this$0, float $partialTick, GuiGraphics $guiGraphics, ItemStack $equippedFocus, float $animatedRadius, double $anglePerItem, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        PoseStackExtensionsKt.translateXY($this$usePose, this$0.width / 2, this$0.height / 2);
        float renderTicks = (float)this$0.ticks + $partialTick;
        GuiGraphicsExtensionsKt.usePose($guiGraphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> FociScreen.render$lambda$2$lambda$0($animatedRadius, renderTicks, $guiGraphics, arg_0)));
        Iterator iterator = ((Iterable)this$0.foci).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            ItemStack stack = (ItemStack)iterator.next();
            GuiGraphicsExtensionsKt.usePose($guiGraphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> FociScreen.render$lambda$2$lambda$1($anglePerItem, i, $animatedRadius, this$0, $guiGraphics, stack, arg_0)));
        }
        if ($equippedFocus != null) {
            PoseStackExtensionsKt.scale($this$usePose, 2.0f);
            if (this$0.selectedIndex == null) {
                PoseStackExtensionsKt.scaleXY($this$usePose, Float.valueOf(1.5f));
            }
            PoseStackExtensionsKt.translateXY($this$usePose, -8, -8);
            $guiGraphics.renderItem($equippedFocus, 0, 0);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lme/alegian/thavma/impl/client/gui/foci/FociScreen$Companion;", "", "<init>", "()V", "TITLE_ID", "", "BACKGROUND", "Lme/alegian/thavma/impl/client/texture/Texture;", "SCALE", "", "DEGREES_PER_TICK", "MAX_RADIUS", "ANIMATION_DURATION", "", "thavma-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

