/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.client.gui.layout;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.alegian.thavma.impl.client.gui.layout.LayoutAPIKt;
import me.alegian.thavma.impl.client.gui.layout.LayoutExtensions;
import me.alegian.thavma.impl.client.gui.layout.Props;
import me.alegian.thavma.impl.client.gui.layout.T7LayoutElement;
import me.alegian.thavma.impl.client.texture.Texture;
import me.alegian.thavma.impl.client.util.GuiGraphicsExtensionsKt;
import me.alegian.thavma.impl.client.util.PoseStackExtensionsKt;
import me.alegian.thavma.impl.common.menu.slot.DynamicSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001\u001a'\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u0012\u00a2\u0006\u0002\b\u0013\u001a\u0014\u0010\u0014\u001a\u00020\r*\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a+\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0019\u001aX\u0010\u001a\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001f2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f2\b\b\u0002\u0010!\u001a\u00020\u00052\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u00020\r0\u0012\u00a8\u0006#"}, d2={"debugRect", "Lnet/minecraft/client/gui/components/Renderable;", "size", "Lnet/minecraft/world/phys/Vec2;", "color", "", "text", "content", "Lnet/minecraft/network/chat/Component;", "renderableTexture", "texture", "Lme/alegian/thavma/impl/client/texture/Texture;", "relativeRenderable", "", "renderable", "TextureBox", "Lme/alegian/thavma/impl/client/gui/layout/T7LayoutElement;", "children", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "slotSetup", "slot", "Lnet/minecraft/world/inventory/Slot;", "Slot", "slotSize", "(Lnet/minecraft/world/inventory/Slot;Lme/alegian/thavma/impl/client/texture/Texture;Ljava/lang/Integer;)Lme/alegian/thavma/impl/client/gui/layout/T7LayoutElement;", "Grid", "T", "rows", "columns", "elements", "", "bgLayers", "gapSize", "child", "thavma-neoforge"})
public final class LayoutExtensionsKt {
    @NotNull
    public static final Renderable debugRect(@NotNull Vec2 size, int color) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return (arg_0, arg_1, arg_2, arg_3) -> LayoutExtensionsKt.debugRect$lambda$0(size, color, arg_0, arg_1, arg_2, arg_3);
    }

    @NotNull
    public static final Renderable text(@NotNull Component content, int color) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return (arg_0, arg_1, arg_2, arg_3) -> LayoutExtensionsKt.text$lambda$1(content, color, arg_0, arg_1, arg_2, arg_3);
    }

    public static /* synthetic */ Renderable text$default(Component component, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return LayoutExtensionsKt.text(component, n);
    }

    private static final Renderable renderableTexture(Texture texture) {
        return (arg_0, arg_1, arg_2, arg_3) -> LayoutExtensionsKt.renderableTexture$lambda$2(texture, arg_0, arg_1, arg_2, arg_3);
    }

    public static final void relativeRenderable(@NotNull Renderable renderable) {
        Intrinsics.checkNotNullParameter((Object)renderable, (String)"renderable");
        Screen screen = LayoutExtensions.INSTANCE.getCurrScreen();
        if (screen == null) {
            throw new IllegalStateException("Thavma Exception: cannot add renderable without setting LayoutExtensions.currScreen first!");
        }
        Screen screen2 = screen;
        LayoutAPIKt.afterLayout((Function1<? super T7LayoutElement, Unit>)((Function1)arg_0 -> LayoutExtensionsKt.relativeRenderable$lambda$5(screen2, renderable, arg_0)));
    }

    @NotNull
    public static final T7LayoutElement TextureBox(@NotNull Texture texture, @NotNull Function1<? super T7LayoutElement, Unit> children) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        return LayoutAPIKt.Row((Function1<? super Props, Unit>)((Function1)arg_0 -> LayoutExtensionsKt.TextureBox$lambda$6(texture, arg_0)), (Function1<? super T7LayoutElement, Unit>)((Function1)arg_0 -> LayoutExtensionsKt.TextureBox$lambda$7(texture, children, arg_0)));
    }

    private static final void slotSetup(T7LayoutElement $this$slotSetup, Slot slot) {
        if (!(slot instanceof DynamicSlot)) {
            return;
        }
        ((DynamicSlot)slot).setActualX($this$slotSetup.getPosition().x);
        ((DynamicSlot)slot).setActualY($this$slotSetup.getPosition().y);
        ((DynamicSlot)slot).setSize((int)$this$slotSetup.getSize().x);
    }

    @NotNull
    public static final T7LayoutElement Slot(@NotNull Slot slot, @Nullable Texture texture, @Nullable Integer slotSize) {
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        return texture != null ? LayoutExtensionsKt.TextureBox(texture, (Function1<? super T7LayoutElement, Unit>)((Function1)arg_0 -> LayoutExtensionsKt.Slot$lambda$9(slot, arg_0))) : LayoutAPIKt.Box((Function1<? super Props, Unit>)((Function1)arg_0 -> LayoutExtensionsKt.Slot$lambda$10(slotSize, arg_0)), (Function1<? super T7LayoutElement, Unit>)((Function1)arg_0 -> LayoutExtensionsKt.Slot$lambda$12(slot, arg_0)));
    }

    public static /* synthetic */ T7LayoutElement Slot$default(Slot slot, Texture texture, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            texture = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        return LayoutExtensionsKt.Slot(slot, texture, n);
    }

    @NotNull
    public static final <T> T7LayoutElement Grid(int rows, int columns, @NotNull List<? extends T> elements, @NotNull List<Texture> bgLayers, int gapSize, @NotNull Function1<? super T, Unit> child) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(bgLayers, (String)"bgLayers");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        return LayoutAPIKt.Column((Function1<? super Props, Unit>)((Function1)arg_0 -> LayoutExtensionsKt.Grid$lambda$13(gapSize, arg_0)), (Function1<? super T7LayoutElement, Unit>)((Function1)arg_0 -> LayoutExtensionsKt.Grid$lambda$16(bgLayers, rows, gapSize, columns, child, elements, arg_0)));
    }

    public static /* synthetic */ T7LayoutElement Grid$default(int n, int n2, List list, List list2, int n3, Function1 function1, int n4, Object object) {
        if ((n4 & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        return LayoutExtensionsKt.Grid(n, n2, list, list2, n3, function1);
    }

    private static final void debugRect$lambda$0(Vec2 $size, int $color, GuiGraphics guiGraphics, int n, int n2, float f) {
        guiGraphics.fill(0, 0, (int)$size.x, (int)$size.y, $color);
    }

    private static final void text$lambda$1(Component $content, int $color, GuiGraphics guiGraphics, int n, int n2, float f) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Font font = Minecraft.getInstance().font;
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"font");
        GuiGraphicsExtensionsKt.drawString(guiGraphics, font, $content, $color);
    }

    private static final void renderableTexture$lambda$2(Texture $texture, GuiGraphics guiGraphics, int n, int n2, float f) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        GuiGraphicsExtensionsKt.blit(guiGraphics, $texture);
        RenderSystem.disableBlend();
    }

    private static final Unit relativeRenderable$lambda$5$lambda$4$lambda$3(T7LayoutElement $this_afterLayout, Renderable $renderable, GuiGraphics $guiGraphics, int $mouseX, int $mouseY, float $partialTick, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        PoseStackExtensionsKt.translateXY($this$usePose, Float.valueOf($this_afterLayout.getPosition().x), Float.valueOf($this_afterLayout.getPosition().y));
        $renderable.render($guiGraphics, $mouseX, $mouseY, $partialTick);
        return Unit.INSTANCE;
    }

    private static final void relativeRenderable$lambda$5$lambda$4(T7LayoutElement $this_afterLayout, Renderable $renderable, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNull((Object)guiGraphics);
        GuiGraphicsExtensionsKt.usePose(guiGraphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> LayoutExtensionsKt.relativeRenderable$lambda$5$lambda$4$lambda$3($this_afterLayout, $renderable, guiGraphics, mouseX, mouseY, partialTick, arg_0)));
    }

    private static final Unit relativeRenderable$lambda$5(Screen $screen, Renderable $renderable, T7LayoutElement $this$afterLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$afterLayout, (String)"$this$afterLayout");
        $screen.renderables.add((arg_0, arg_1, arg_2, arg_3) -> LayoutExtensionsKt.relativeRenderable$lambda$5$lambda$4($this$afterLayout, $renderable, arg_0, arg_1, arg_2, arg_3));
        return Unit.INSTANCE;
    }

    private static final Unit TextureBox$lambda$6(Texture $texture, Props $this$Row) {
        Intrinsics.checkNotNullParameter((Object)$this$Row, (String)"$this$Row");
        $this$Row.setWidth(LayoutAPIKt.fixed($texture.getWidth()));
        $this$Row.setHeight(LayoutAPIKt.fixed($texture.getHeight()));
        return Unit.INSTANCE;
    }

    private static final Unit TextureBox$lambda$7(Texture $texture, Function1 $children, T7LayoutElement $this$Row) {
        Intrinsics.checkNotNullParameter((Object)$this$Row, (String)"$this$Row");
        LayoutExtensionsKt.relativeRenderable(LayoutExtensionsKt.renderableTexture($texture));
        $children.invoke((Object)$this$Row);
        return Unit.INSTANCE;
    }

    private static final Unit Slot$lambda$9$lambda$8(Slot $slot, T7LayoutElement $this$afterLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$afterLayout, (String)"$this$afterLayout");
        LayoutExtensionsKt.slotSetup($this$afterLayout, $slot);
        return Unit.INSTANCE;
    }

    private static final Unit Slot$lambda$9(Slot $slot, T7LayoutElement $this$TextureBox) {
        Intrinsics.checkNotNullParameter((Object)$this$TextureBox, (String)"$this$TextureBox");
        LayoutAPIKt.afterLayout((Function1<? super T7LayoutElement, Unit>)((Function1)arg_0 -> LayoutExtensionsKt.Slot$lambda$9$lambda$8($slot, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit Slot$lambda$10(Integer $slotSize, Props $this$Box) {
        Intrinsics.checkNotNullParameter((Object)$this$Box, (String)"$this$Box");
        Integer n = $slotSize;
        $this$Box.setSize(LayoutAPIKt.fixed(n != null ? n : 0));
        return Unit.INSTANCE;
    }

    private static final Unit Slot$lambda$12$lambda$11(Slot $slot, T7LayoutElement $this$afterLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$afterLayout, (String)"$this$afterLayout");
        LayoutExtensionsKt.slotSetup($this$afterLayout, $slot);
        return Unit.INSTANCE;
    }

    private static final Unit Slot$lambda$12(Slot $slot, T7LayoutElement $this$Box) {
        Intrinsics.checkNotNullParameter((Object)$this$Box, (String)"$this$Box");
        LayoutAPIKt.afterLayout((Function1<? super T7LayoutElement, Unit>)((Function1)arg_0 -> LayoutExtensionsKt.Slot$lambda$12$lambda$11($slot, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit Grid$lambda$13(int $gapSize, Props $this$Column) {
        Intrinsics.checkNotNullParameter((Object)$this$Column, (String)"$this$Column");
        $this$Column.setGap($gapSize);
        return Unit.INSTANCE;
    }

    private static final Unit Grid$lambda$16$lambda$14(int $gapSize, Props $this$Row) {
        Intrinsics.checkNotNullParameter((Object)$this$Row, (String)"$this$Row");
        $this$Row.setGap($gapSize);
        return Unit.INSTANCE;
    }

    private static final Unit Grid$lambda$16$lambda$15(int $columns, Function1 $child, List $elements, int $i, T7LayoutElement $this$Row) {
        Intrinsics.checkNotNullParameter((Object)$this$Row, (String)"$this$Row");
        for (int j = 0; j < $columns; ++j) {
            $child.invoke($elements.get($i * $columns + j));
        }
        return Unit.INSTANCE;
    }

    private static final Unit Grid$lambda$16(List $bgLayers, int $rows, int $gapSize, int $columns, Function1 $child, List $elements, T7LayoutElement $this$Column) {
        Intrinsics.checkNotNullParameter((Object)$this$Column, (String)"$this$Column");
        for (Texture layer : $bgLayers) {
            LayoutExtensionsKt.relativeRenderable(LayoutExtensionsKt.renderableTexture(layer));
        }
        for (int i = 0; i < $rows; ++i) {
            LayoutAPIKt.Row((Function1<? super Props, Unit>)((Function1)arg_0 -> LayoutExtensionsKt.Grid$lambda$16$lambda$14($gapSize, arg_0)), (Function1<? super T7LayoutElement, Unit>)((Function1)arg_0 -> LayoutExtensionsKt.Grid$lambda$16$lambda$15($columns, $child, $elements, i, arg_0)));
        }
        return Unit.INSTANCE;
    }
}

