/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.client.gui.research_table;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.alegian.thavma.impl.client.gui.research_table.ResearchScreen;
import me.alegian.thavma.impl.client.gui.tooltip.T7Tooltip;
import me.alegian.thavma.impl.client.renderer.AspectRenderer;
import me.alegian.thavma.impl.client.texture.Texture;
import me.alegian.thavma.impl.client.util.GuiGraphicsExtensionsKt;
import me.alegian.thavma.impl.client.util.PoseStackExtensionsKt;
import me.alegian.thavma.impl.common.aspect.Aspect;
import me.alegian.thavma.impl.common.payload.SocketStatePayload;
import me.alegian.thavma.impl.common.research.SocketState;
import me.alegian.thavma.impl.common.util.Indices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u000e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\"H\u0016J \u0010#\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0018H\u0016J\b\u0010%\u001a\u00020\u0014H\u0002J\u0010\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"Lme/alegian/thavma/impl/client/gui/research_table/SocketWidget;", "Lnet/minecraft/client/gui/components/AbstractWidget;", "position", "Lnet/minecraft/world/phys/Vec2;", "indices", "Lme/alegian/thavma/impl/common/util/Indices;", "screen", "Lme/alegian/thavma/impl/client/gui/research_table/ResearchScreen;", "<init>", "(Lnet/minecraft/world/phys/Vec2;Lme/alegian/thavma/impl/common/util/Indices;Lme/alegian/thavma/impl/client/gui/research_table/ResearchScreen;)V", "getPosition", "()Lnet/minecraft/world/phys/Vec2;", "value", "Lme/alegian/thavma/impl/common/research/SocketState;", "state", "getState", "()Lme/alegian/thavma/impl/common/research/SocketState;", "setState", "(Lme/alegian/thavma/impl/common/research/SocketState;)V", "renderWidget", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "", "mouseY", "partialTick", "", "renderConnectionsDeferred", "renderAspectDeferred", "renderConnections", "aspect", "Lme/alegian/thavma/impl/common/aspect/Aspect;", "onRelease", "", "onClick", "button", "updateTooltip", "updateWidgetNarration", "narrationElementOutput", "Lnet/minecraft/client/gui/narration/NarrationElementOutput;", "playDownSound", "handler", "Lnet/minecraft/client/sounds/SoundManager;", "Companion", "thavma-neoforge"})
@SourceDebugExtension(value={"SMAP\nSocketWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketWidget.kt\nme/alegian/thavma/impl/client/gui/research_table/SocketWidget\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1563#2:132\n1634#2,3:133\n*S KotlinDebug\n*F\n+ 1 SocketWidget.kt\nme/alegian/thavma/impl/client/gui/research_table/SocketWidget\n*L\n82#1:132\n82#1:133,3\n*E\n"})
public final class SocketWidget
extends AbstractWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vec2 position;
    @NotNull
    private final Indices indices;
    @NotNull
    private final ResearchScreen screen;
    @NotNull
    private static final String NAMESPACE = ".socketWidget";
    @NotNull
    private static final Texture TEXTURE = new Texture("gui/research_table/socket", 22, 22, 22, 22);
    @NotNull
    private static final Texture BROKEN_TEXTURE = new Texture("gui/research_table/broken_socket", 22, 22, 22, 22);
    @NotNull
    private static final String removeTranslationId = ResearchScreen.Companion.getTranslationId() + ".socketWidget.remove";

    public SocketWidget(@NotNull Vec2 position, @NotNull Indices indices, @NotNull ResearchScreen screen) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        Intrinsics.checkNotNullParameter((Object)((Object)screen), (String)"screen");
        super((int)position.x, (int)position.y, TEXTURE.getWidth(), TEXTURE.getHeight(), (Component)Component.empty());
        this.position = position;
        this.indices = indices;
        this.screen = screen;
    }

    @NotNull
    public final Vec2 getPosition() {
        return this.position;
    }

    @NotNull
    public final SocketState getState() {
        Map<Indices, SocketState> map = this.screen.getMenu().getResearchState();
        if (map == null || (map = map.get(this.indices)) == null) {
            map = new SocketState(this.indices, null, false, false, 14, null);
        }
        return map;
    }

    public final void setState(@NotNull SocketState value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PacketDistributor.sendToServer((CustomPacketPayload)new SocketStatePayload(value), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        if (this.screen.getMenu().getResearchState() == null) {
            return;
        }
        if (this.screen.getMenu().getCompleted() && this.getState().getAspect() == null) {
            return;
        }
        this.updateTooltip();
        GuiGraphicsExtensionsKt.usePose(guiGraphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> SocketWidget.renderWidget$lambda$0(this, guiGraphics, arg_0)));
    }

    public final void renderConnectionsDeferred(@NotNull GuiGraphics guiGraphics) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
            Aspect aspect = this.getState().getAspect();
            if (aspect == null) break block0;
            Aspect it = aspect;
            boolean bl = false;
            GuiGraphicsExtensionsKt.usePose(guiGraphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> SocketWidget.renderConnectionsDeferred$lambda$2$lambda$1(this, it, guiGraphics, arg_0)));
        }
    }

    public final void renderAspectDeferred(@NotNull GuiGraphics guiGraphics) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
            Aspect aspect = this.getState().getAspect();
            if (aspect == null) break block0;
            Aspect it = aspect;
            boolean bl = false;
            GuiGraphicsExtensionsKt.usePose(guiGraphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> SocketWidget.renderAspectDeferred$lambda$4$lambda$3(this, guiGraphics, it, arg_0)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderConnections(Aspect aspect, GuiGraphics guiGraphics) {
        for (Indices neighborIdx : this.indices.getAxial().getAxialNeighbors()) {
            boolean bl;
            SocketWidget neighbor = this.screen.getSocketWidgets().get(neighborIdx);
            if (neighbor == null) continue;
            Object object = neighbor.getState().getAspect();
            if (object != null && (object = ((Aspect)object).getComponents()) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Supplier supplier = (Supplier)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add((Aspect)it.get());
                }
                bl = ((List)destination$iv$iv).contains(aspect);
            } else {
                bl = false;
            }
            if (!bl) continue;
            float dx = neighbor.position.x - this.position.x;
            float dy = neighbor.position.y - this.position.y;
            double angleDegrees = (double)((float)Math.atan2(dy, dx) * (float)180) / Math.PI;
            GuiGraphicsExtensionsKt.usePose(guiGraphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> SocketWidget.renderConnections$lambda$6(angleDegrees, guiGraphics, arg_0)));
        }
    }

    public void onRelease(double mouseX, double mouseY) {
        if (this.getState().getAspect() != null || this.getState().getBroken() || this.getState().getLocked()) {
            return;
        }
        Aspect aspect = this.screen.getSelectedAspect();
        if (aspect == null) {
            return;
        }
        Aspect carriedAspect = aspect;
        this.setState(this.getState().withAspect(carriedAspect));
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.CHISELED_BOOKSHELF_INSERT, (float)1.0f, (float)1.0f));
    }

    public void onClick(double mouseX, double mouseY, int button) {
        if (this.getState().getAspect() != null && !this.getState().getLocked()) {
            this.setState(this.getState().withAspect(null).withBroken(true));
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.DEEPSLATE_BREAK, (float)1.0f, (float)1.0f));
        }
    }

    private final void updateTooltip() {
        Tooltip tooltip;
        Aspect aspect = this.getState().getAspect();
        if (aspect != null) {
            Component[] componentArray = new Component[2];
            Intrinsics.checkNotNullExpressionValue((Object)Component.translatable((String)aspect.getTranslationId()), (String)"translatable(...)");
            Intrinsics.checkNotNullExpressionValue((Object)Component.translatable((String)removeTranslationId).withStyle(ChatFormatting.GRAY), (String)"withStyle(...)");
            tooltip = new T7Tooltip(componentArray);
        } else {
            tooltip = null;
        }
        this.setTooltip(tooltip);
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        Intrinsics.checkNotNullParameter((Object)narrationElementOutput, (String)"narrationElementOutput");
    }

    public void playDownSound(@NotNull SoundManager handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
    }

    private static final Unit renderWidget$lambda$0(SocketWidget this$0, GuiGraphics $guiGraphics, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        PoseStackExtensionsKt.translateXY($this$usePose, this$0.getX(), this$0.getY());
        Texture texture = TEXTURE;
        if (this$0.getState().getBroken()) {
            texture = BROKEN_TEXTURE;
        }
        GuiGraphicsExtensionsKt.blit($guiGraphics, texture);
        return Unit.INSTANCE;
    }

    private static final Unit renderConnectionsDeferred$lambda$2$lambda$1(SocketWidget this$0, Aspect $it, GuiGraphics $guiGraphics, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        PoseStackExtensionsKt.translateXY($this$usePose, this$0.getX(), this$0.getY());
        PoseStackExtensionsKt.translateXY($this$usePose, TEXTURE.getWidth() / 2, TEXTURE.getHeight() / 2);
        this$0.renderConnections($it, $guiGraphics);
        return Unit.INSTANCE;
    }

    private static final Unit renderAspectDeferred$lambda$4$lambda$3(SocketWidget this$0, GuiGraphics $guiGraphics, Aspect $it, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        PoseStackExtensionsKt.translateXY($this$usePose, this$0.getX(), this$0.getY());
        PoseStackExtensionsKt.translateXY($this$usePose, TEXTURE.getWidth() / 2, TEXTURE.getHeight() / 2);
        PoseStackExtensionsKt.scaleXY($this$usePose, Float.valueOf(0.8f));
        PoseStackExtensionsKt.translateXY($this$usePose, -8, -8);
        AspectRenderer.INSTANCE.drawAspectIcon($guiGraphics, $it);
        return Unit.INSTANCE;
    }

    private static final Unit renderConnections$lambda$6(double $angleDegrees, GuiGraphics $guiGraphics, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        PoseStackExtensionsKt.rotateZ($this$usePose, $angleDegrees);
        PoseStackExtensionsKt.translateXY($this$usePose, 0, -0.5);
        $guiGraphics.hLine(0, TEXTURE.getWidth() + 2, 0, -9175133);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lme/alegian/thavma/impl/client/gui/research_table/SocketWidget$Companion;", "", "<init>", "()V", "NAMESPACE", "", "TEXTURE", "Lme/alegian/thavma/impl/client/texture/Texture;", "getTEXTURE", "()Lme/alegian/thavma/impl/client/texture/Texture;", "BROKEN_TEXTURE", "getBROKEN_TEXTURE", "removeTranslationId", "getRemoveTranslationId", "()Ljava/lang/String;", "thavma-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Texture getTEXTURE() {
            return TEXTURE;
        }

        @NotNull
        public final Texture getBROKEN_TEXTURE() {
            return BROKEN_TEXTURE;
        }

        @NotNull
        public final String getRemoveTranslationId() {
            return removeTranslationId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

