/*
 * Decompiled with CFR 0.152.
 */
package me.alegian.thavma.impl.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.alegian.thavma.impl.ThavmaKt;
import me.alegian.thavma.impl.client.renderer.RenderHelperKt;
import me.alegian.thavma.impl.client.texture.atlas.AspectAtlas;
import me.alegian.thavma.impl.client.util.GuiGraphicsExtensionsKt;
import me.alegian.thavma.impl.client.util.PoseStackExtensionsKt;
import me.alegian.thavma.impl.common.aspect.Aspect;
import me.alegian.thavma.impl.common.aspect.AspectMap;
import me.alegian.thavma.impl.common.aspect.AspectStack;
import me.alegian.thavma.impl.common.util.Vec2ExtensionsKt;
import me.alegian.thavma.impl.common.util.Vec3ExtensionsKt;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"Lme/alegian/thavma/impl/client/renderer/AspectRenderer;", "", "<init>", "()V", "renderAfterWeather", "", "aspects", "Lme/alegian/thavma/impl/common/aspect/AspectMap;", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "camera", "Lnet/minecraft/client/Camera;", "blockPos", "Lnet/minecraft/core/BlockPos;", "renderAspectsWrapped", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "renderAspect", "aspectStack", "Lme/alegian/thavma/impl/common/aspect/AspectStack;", "drawAspectIcon", "aspect", "Lme/alegian/thavma/impl/common/aspect/Aspect;", "calculateOffsets", "", "Lnet/minecraft/world/phys/Vec2;", "numAspects", "", "drawCount", "text", "", "thavma-neoforge"})
@SourceDebugExtension(value={"SMAP\nAspectRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspectRenderer.kt\nme/alegian/thavma/impl/client/renderer/AspectRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class AspectRenderer {
    @NotNull
    public static final AspectRenderer INSTANCE = new AspectRenderer();

    private AspectRenderer() {
    }

    public final void renderAfterWeather(@NotNull AspectMap aspects, @NotNull PoseStack poseStack, @NotNull Camera camera, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)aspects, (String)"aspects");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        if (aspects.isEmpty()) {
            return;
        }
        GuiGraphics guiGraphics = new GuiGraphics(Minecraft.getInstance(), poseStack, Minecraft.getInstance().renderBuffers().bufferSource());
        GuiGraphicsExtensionsKt.usePose(guiGraphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> AspectRenderer.renderAfterWeather$lambda$0(camera, blockPos, aspects, guiGraphics, arg_0)));
    }

    public final void renderAspectsWrapped(@NotNull AspectMap aspects, @NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)aspects, (String)"aspects");
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        List<Vec2> offsets = this.calculateOffsets(aspects.getSize());
        Iterator iterator = ((Iterable)aspects).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            AspectStack aspectStack = (AspectStack)iterator.next();
            GuiGraphicsExtensionsKt.usePose(guiGraphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> AspectRenderer.renderAspectsWrapped$lambda$1(offsets, i, guiGraphics, aspectStack, arg_0)));
        }
    }

    public final void renderAspect(@NotNull GuiGraphics guiGraphics, @NotNull AspectStack aspectStack) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)aspectStack, (String)"aspectStack");
        this.drawAspectIcon(guiGraphics, aspectStack.getAspect());
        this.drawCount(guiGraphics, String.valueOf(aspectStack.getAmount()));
    }

    public final void drawAspectIcon(@NotNull GuiGraphics guiGraphics, @NotNull Aspect aspect) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)aspect, (String)"aspect");
        ResourceLocation resourceLocation = ThavmaKt.rl(aspect.getId());
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"rl(...)");
        TextureAtlasSprite sprite = AspectAtlas.INSTANCE.getSprite(resourceLocation);
        RenderSystem.disableDepthTest();
        GuiGraphicsExtensionsKt.blit(guiGraphics, 0, 0, 0, 16, 16, sprite, aspect.getColor());
        RenderSystem.enableDepthTest();
    }

    private final List<Vec2> calculateOffsets(int numAspects) {
        ArrayList<Vec2> arrayList = new ArrayList<Vec2>(numAspects);
        int n = 0;
        while (n < numAspects) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<Vec2> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(Vec2.ZERO);
        }
        List offsets = arrayList;
        int rows = (int)Math.ceil(1.0f * (float)numAspects / (float)5);
        for (int i = 0; i < rows; ++i) {
            int it = numAspects - i * 5;
            int bl = 5;
            int cols = Math.min(it, bl);
            for (int j = 0; j < cols; ++j) {
                float xOffset = (float)(cols - 1) / -2.0f + (float)j;
                offsets.set(i * 5 + j, Vec2ExtensionsKt.vec2(Float.valueOf((float)16 * xOffset), -16 * i - 8));
            }
        }
        return offsets;
    }

    private final void drawCount(GuiGraphics guiGraphics, String text) {
        GuiGraphicsExtensionsKt.usePose(guiGraphics, (Function1<? super PoseStack, Unit>)((Function1)arg_0 -> AspectRenderer.drawCount$lambda$3(text, guiGraphics, arg_0)));
    }

    private static final Unit renderAfterWeather$lambda$0(Camera $camera, BlockPos $blockPos, AspectMap $aspects, GuiGraphics $guiGraphics, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        Vec3 vec3 = $camera.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPosition(...)");
        Vec3 vec32 = Vec3ExtensionsKt.unaryMinus(vec3);
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"unaryMinus(...)");
        Vec3 vec33 = $blockPos.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"getCenter(...)");
        Vec3 vec34 = Vec3ExtensionsKt.plus(vec32, vec33);
        Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"plus(...)");
        PoseStackExtensionsKt.translate($this$usePose, Vec3ExtensionsKt.plus(vec34, new Vec3(0.0, 0.75, 0.0)));
        Vec3 vec35 = $blockPos.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec35, (String)"getCenter(...)");
        float angle = RenderHelperKt.calculatePlayerAngle(vec35);
        $this$usePose.mulPose(Axis.YP.rotation(angle));
        PoseStackExtensionsKt.scaleXY($this$usePose, Float.valueOf(0.3f));
        PoseStackExtensionsKt.scaleXY($this$usePose, Float.valueOf(0.0625f));
        $this$usePose.scale(1.0f, -1.0f, 1.0f);
        INSTANCE.renderAspectsWrapped($aspects, $guiGraphics);
        return Unit.INSTANCE;
    }

    private static final Unit renderAspectsWrapped$lambda$1(List $offsets, int $i, GuiGraphics $guiGraphics, AspectStack $aspectStack, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        PoseStackExtensionsKt.translateXY($this$usePose, (Vec2)$offsets.get($i));
        PoseStackExtensionsKt.translateXY($this$usePose, -8, 0);
        INSTANCE.renderAspect($guiGraphics, $aspectStack);
        return Unit.INSTANCE;
    }

    private static final Unit drawCount$lambda$3(String $text, GuiGraphics $guiGraphics, PoseStack $this$usePose) {
        Intrinsics.checkNotNullParameter((Object)$this$usePose, (String)"$this$usePose");
        PoseStackExtensionsKt.translateXY($this$usePose, 16, 16);
        PoseStackExtensionsKt.scale($this$usePose, 0.5f);
        Font font = Minecraft.getInstance().font;
        PoseStackExtensionsKt.translateXY($this$usePose, -font.width($text), -font.lineHeight);
        Intrinsics.checkNotNull((Object)font);
        GuiGraphicsExtensionsKt.drawOutlinedSeethroughString($guiGraphics, font, $text, 0xFFFFFF, 0);
        return Unit.INSTANCE;
    }
}

